/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.plan.split.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.arapcommon.service.plan.split.entity.SplitRowData;

public class ConditonSplitServiceHelper {
    public static List<SplitRowData> getSplitRowDatas(DynamicObject condition, Date billDate, BigDecimal totalAmt, BigDecimal totalLocalAmt, int precision, int basePrecision) {
        ArrayList<SplitRowData> result = new ArrayList<SplitRowData>(8);
        String basis = condition.getString("basis");
        DynamicObjectCollection entries = condition.getDynamicObjectCollection("entry");
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal remainAmount = BigDecimal.ZERO;
        BigDecimal remainAmountLocal = BigDecimal.ZERO;
        int size = entries.size();
        for (int i = 1; i <= size; ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i - 1);
            SplitRowData rowData = new SplitRowData();
            if ("A".equals(basis)) {
                if (i == size) {
                    rowData.setPriceTaxTotal(totalAmt.subtract(remainAmount));
                    rowData.setPriceTaxTotalLocal(totalLocalAmt.subtract(remainAmountLocal));
                } else {
                    BigDecimal rate = entry.getBigDecimal("rate");
                    BigDecimal priceTaxTotal = totalAmt.multiply(rate).divide(hundred, precision, RoundingMode.HALF_UP);
                    rowData.setPriceTaxTotal(priceTaxTotal);
                    BigDecimal priceTaxTotalLocal = totalLocalAmt.multiply(rate).divide(hundred, basePrecision, RoundingMode.HALF_UP);
                    rowData.setPriceTaxTotalLocal(priceTaxTotalLocal);
                    remainAmount = remainAmount.add(priceTaxTotal);
                    remainAmountLocal = remainAmountLocal.add(priceTaxTotalLocal);
                }
            }
            Date dueDate = ConditonSplitServiceHelper.calculateDate(billDate, entry);
            rowData.setDueDate(dueDate);
            result.add(rowData);
        }
        return result;
    }

    private static Date calculateDate(Date billDate, DynamicObject entry) {
        Map data;
        HashMap confirmTypeJson;
        Map detailInfo;
        String confirmType = entry.getString("confirmtype");
        String confirmTypeData = entry.getString("confirmtypedata");
        Date dueDate = billDate;
        if (StringUtils.isNotBlank((CharSequence)confirmType) && StringUtils.isNotBlank((CharSequence)confirmTypeData) && !ObjectUtils.isEmpty((Object)billDate) && (detailInfo = (Map)(confirmTypeJson = (HashMap)SerializationUtils.fromJsonString((String)confirmTypeData, Map.class)).get("DETAIL")) != null && (data = (Map)detailInfo.get("DATA")) != null) {
            switch (confirmType) {
                case "A": {
                    dueDate = billDate;
                    break;
                }
                case "B": {
                    int odmonth = (Integer)data.get("odmonth");
                    int odday = (Integer)data.get("odday");
                    Calendar c = Calendar.getInstance();
                    c.setTime(billDate);
                    c.add(2, odmonth);
                    c.add(5, odday);
                    dueDate = c.getTime();
                    break;
                }
                case "C": {
                    int settleDay = (Integer)data.get("monsettlementday");
                    int monodmonth = (Integer)data.get("monodmonth");
                    int monodday = (Integer)data.get("monodday");
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime(billDate);
                    c1.add(2, monodmonth);
                    c1.add(5, monodday);
                    int day1 = c1.get(5);
                    if (settleDay < day1) {
                        c1.add(2, 1);
                    }
                    int actualMaximum = c1.getActualMaximum(5);
                    c1.set(5, Math.min(settleDay, actualMaximum));
                    dueDate = c1.getTime();
                    break;
                }
                case "D": {
                    break;
                }
            }
        }
        return dueDate;
    }
}

