/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.repair;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;

public class DataUpgradeRepairService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(DataUpgradeRepairService.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultECServiceIdempotentProperties.generate(((Object)((Object)this)).getClass().getName(), param);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        try (TXHandle tx = TX.requiresNew((String)"executeRepair");){
            try {
                CommonParam ecParam = (CommonParam)param;
                String methodName = (String)ecParam.get((Object)"methodName");
                if ("repairBusArBills".equals(methodName)) {
                    Set busArBaseAmtbillIds = (Set)ecParam.get((Object)"busArBaseAmtbillIds");
                    Set busArBaseQtybillIds = (Set)ecParam.get((Object)"busArBaseQtybillIds");
                    this.repairBusArBills(busArBaseAmtbillIds, busArBaseQtybillIds);
                } else if ("BusArRelateAmtQtyRepair".equals(methodName)) {
                    Set arBusBillIds = (Set)ecParam.get((Object)"arBusBillIds");
                    this.repairBusArRelateAmtQtyBills(arBusBillIds);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw e;
            }
        }
        return null;
    }

    public void repairBusArRelateAmtQtyBills(Set<Long> arBusBillIds) {
        String arBusSelector = "id,payproperty,entry.id,entry.e_quantity,entry.e_relateinvamt,entry.e_recamount,entry.e_reclocalamt,entry.e_relateinvlocamt,entry.e_unrelateinvamt,entry.e_unrelateinvlocamt,entry.e_relateinvqty,entry.e_unrelateinvqty";
        DynamicObjectCollection arBusBillCol = QueryServiceHelper.query((String)"ar_busbill", (String)arBusSelector, (QFilter[])new QFilter[]{new QFilter("id", "in", arBusBillIds)});
        Set<Long> arBusEntryIds = arBusBillCol.stream().map(e1 -> e1.getLong("entry.id")).collect(Collectors.toSet());
        Set payProPertyIds = arBusBillCol.stream().map(e1 -> e1.getLong("payproperty")).collect(Collectors.toSet());
        Map payProPertyMap = BusinessDataServiceHelper.loadFromCache((String)"ar_payproperty", (String)"id,isbasedonamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payProPertyIds)});
        Map<Long, Set<Long>> targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap("ar_busbill", "entry", arBusEntryIds.toArray(new Long[0]), "sim_original_bill");
        Set invEntryIds = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        String selector = "id,sim_original_bill_item.id,sim_original_bill_item.combinenum,sim_original_bill_item.combineamount,sim_original_bill_item.combinelocalamount";
        QFilter filter = new QFilter("invoicestatus", "!=", (Object)"3");
        filter.and(new QFilter("invoicestatus", "!=", (Object)"6"));
        filter.and(new QFilter("closestatus", "!=", (Object)"1"));
        filter.and(new QFilter("sim_original_bill_item.id", "in", invEntryIds));
        DynamicObjectCollection invoiceCol = QueryServiceHelper.query((String)"sim_original_bill", (String)selector, (QFilter[])new QFilter[]{filter});
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(8);
        for (DynamicObject arBusBill : arBusBillCol) {
            Long arBusEntryId = arBusBill.getLong("entry.id");
            BigDecimal e_quantity = arBusBill.getBigDecimal("entry.e_quantity");
            BigDecimal e_recamount = arBusBill.getBigDecimal("entry.e_recamount");
            BigDecimal e_reclocalamt = arBusBill.getBigDecimal("entry.e_reclocalamt");
            Set<Long> tarEntryIds = targetRowIdsMap.get(arBusEntryId);
            BigDecimal relateinvqtySum = BigDecimal.ZERO;
            BigDecimal relateinvamtSum = BigDecimal.ZERO;
            BigDecimal relateinvlocamtSum = BigDecimal.ZERO;
            List invoiceColFilter = invoiceCol.stream().filter(invoiceInfo -> tarEntryIds.contains(invoiceInfo.getLong("sim_original_bill_item.id"))).collect(Collectors.toList());
            for (DynamicObject invoiceInfo2 : invoiceColFilter) {
                relateinvqtySum = relateinvqtySum.add(invoiceInfo2.getBigDecimal("sim_original_bill_item.combinenum"));
                relateinvamtSum = relateinvamtSum.add(invoiceInfo2.getBigDecimal("sim_original_bill_item.combineamount"));
                relateinvlocamtSum = relateinvlocamtSum.add(invoiceInfo2.getBigDecimal("sim_original_bill_item.combinelocalamount"));
            }
            logger.info("relateinvqtySum : " + relateinvqtySum + ",e_quantity : " + e_quantity + ",relateinvamtSum : " + relateinvamtSum + ",e_recamount : " + e_recamount + ",relateinvlocamtSum : " + relateinvlocamtSum + ",e_reclocalamt : " + e_reclocalamt + ",arBusEntryId : " + arBusEntryId);
            BigDecimal unrelateinvqty = e_quantity.subtract(relateinvqtySum);
            BigDecimal unrelateinvamt = e_recamount.subtract(relateinvamtSum);
            BigDecimal unrelateinvlocamt = e_reclocalamt.subtract(relateinvlocamtSum);
            updateList.add(new Object[]{relateinvqtySum, unrelateinvqty, relateinvamtSum, unrelateinvamt, relateinvlocamtSum, unrelateinvlocamt, arBusEntryId});
        }
        if (updateList.size() > 0) {
            logger.info("BusArRelateAmtQtyRepair.updateList\uff1a" + updateList);
            String updateSql = "update t_ar_busbillentry_e set frelateinvqty = ?, funrelateinvqty = ?, frelateinvamt = ?, funrelateinvamt = ?, frelateinvlocamt = ?, funrelateinvlocamt = ? where fentryid = ?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateList);
        }
        updateList = new ArrayList(8);
        QFilter filter_1 = new QFilter("invoicestatus", "!=", (Object)"3");
        filter_1.and(new QFilter("invoicestatus", "!=", (Object)"6"));
        filter_1.and(new QFilter("closestatus", "=", (Object)"1"));
        filter_1.and(new QFilter("confirmstate", "=", (Object)"1").or(new QFilter("confirmstate", "=", (Object)"2")));
        filter_1.and(new QFilter("sim_original_bill_item.id", "in", invEntryIds));
        String selector_1 = "id,sim_original_bill_item.id,sim_original_bill_item.fromissuedtaxamount,sim_original_bill_item.issuednum,sim_original_bill_item.issuedtotaltaxamount";
        DynamicObjectCollection invoiceCol_1 = QueryServiceHelper.query((String)"sim_original_bill", (String)selector_1, (QFilter[])new QFilter[]{filter_1});
        if (invoiceCol_1.size() > 0) {
            for (DynamicObject arBusBill : arBusBillCol) {
                DynamicObject payProPerty;
                Long payProPertyId = arBusBill.getLong("payproperty");
                if (ObjectUtils.isEmpty((Object)payProPertyId) || (payProPerty = (DynamicObject)payProPertyMap.get(payProPertyId)) == null) continue;
                boolean isAmount = payProPerty.getBoolean("isbasedonamt");
                BigDecimal fromissuedtaxamountSum = BigDecimal.ZERO;
                BigDecimal issuedtotaltaxamountSum = BigDecimal.ZERO;
                BigDecimal issuednumSum = BigDecimal.ZERO;
                Long arBusEntryId = arBusBill.getLong("entry.id");
                Set<Long> tarEntryIds = targetRowIdsMap.get(arBusEntryId);
                List invoiceColFilter = invoiceCol_1.stream().filter(invoiceInfo -> tarEntryIds.contains(invoiceInfo.getLong("sim_original_bill_item.id"))).collect(Collectors.toList());
                for (DynamicObject invoiceInfo3 : invoiceColFilter) {
                    fromissuedtaxamountSum = fromissuedtaxamountSum.add(invoiceInfo3.getBigDecimal("sim_original_bill_item.fromissuedtaxamount"));
                    issuedtotaltaxamountSum = issuedtotaltaxamountSum.add(invoiceInfo3.getBigDecimal("sim_original_bill_item.issuedtotaltaxamount"));
                    issuednumSum = issuednumSum.add(invoiceInfo3.getBigDecimal("sim_original_bill_item.issuednum"));
                }
                if (isAmount) {
                    updateList.add(new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, fromissuedtaxamountSum, fromissuedtaxamountSum, issuedtotaltaxamountSum, issuedtotaltaxamountSum, arBusEntryId});
                    continue;
                }
                updateList.add(new Object[]{issuednumSum, issuednumSum, fromissuedtaxamountSum, fromissuedtaxamountSum, issuedtotaltaxamountSum, issuedtotaltaxamountSum, arBusEntryId});
            }
            if (updateList.size() > 0) {
                String updateSql = "update t_ar_busbillentry_e set frelateinvqty = frelateinvqty + ?, funrelateinvqty = funrelateinvqty - ?, frelateinvamt = frelateinvamt + ?, funrelateinvamt = funrelateinvamt - ?, frelateinvlocamt = frelateinvlocamt + ?, funrelateinvlocamt = funrelateinvlocamt - ? where fentryid = ?";
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateList);
            }
        }
        DataUpgradeRepairService.RecHeadAmountSum(arBusBillIds);
    }

    private static void RecHeadAmountSum(Set<Long> arBusBillIds) {
        if (arBusBillIds.size() > 0) {
            String updatesql = "update t_ar_busbill a set frelateinvamt=(select sum(frelateinvamt) from t_ar_busbillentry_e b where a.fid=b.fid),frelateinvlocamt=(select sum(frelateinvlocamt) from t_ar_busbillentry_e c where a.fid =c.fid),funrelateinvamt=(select sum(funrelateinvamt) from t_ar_busbillentry_e d where a.fid =d.fid),funrelateinvlocamt=(select sum(funrelateinvlocamt) from t_ar_busbillentry_e e where a.fid =e.fid) where fid in (" + StringUtils.join((Object[])arBusBillIds.toArray(), (String)",") + ");";
            DB.execute((DBRoute)new DBRoute("fi"), (String)updatesql);
        }
    }

    public void repairBusArBills(Set<Long> busArBaseAmtbillIds, Set<Long> busArBaseQtybillIds) {
        if (busArBaseAmtbillIds.size() > 0) {
            DynamicObjectCollection busEntrys = QueryServiceHelper.query((String)"ar_busbill", (String)"entry.id,entry.e_confirmedamt,entry.e_amount", (QFilter[])new QFilter[]{new QFilter("id", "in", busArBaseAmtbillIds)});
            ArrayList<Object[]> updateFullCfmParams = new ArrayList<Object[]>(8);
            ArrayList<Object[]> updateUnFullCfmParams = new ArrayList<Object[]>(8);
            for (DynamicObject busEntry : busEntrys) {
                Object param;
                BigDecimal confirmedamt = busEntry.getBigDecimal("entry.e_confirmedamt");
                BigDecimal amount = busEntry.getBigDecimal("entry.e_amount");
                long entryid = busEntry.getLong("entry.id");
                if (confirmedamt.abs().compareTo(amount.abs()) >= 0) {
                    param = new Object[]{entryid};
                    updateFullCfmParams.add((Object[])param);
                    continue;
                }
                param = new Object[]{entryid};
                updateUnFullCfmParams.add((Object[])param);
            }
            if (updateFullCfmParams.size() > 0) {
                String updateFullCfmSql = "update t_ar_busbillentry_e set fconfirmedqty=1,funconfirmqty=0 where fentryid=?";
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateFullCfmSql, updateFullCfmParams);
            }
            if (updateUnFullCfmParams.size() > 0) {
                String updateUnFullCfmSql = "update t_ar_busbillentry_e set fconfirmedqty=0,funconfirmqty=1 where fentryid=?";
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateUnFullCfmSql, updateUnFullCfmParams);
            }
        }
        if (busArBaseQtybillIds.size() > 0) {
            QFilter idFilter = new QFilter("id", "in", busArBaseQtybillIds);
            DynamicObjectCollection busEntrys = QueryServiceHelper.query((String)"ar_busbill", (String)"entry.id,entry.e_quantity", (QFilter[])new QFilter[]{idFilter});
            Map<Long, BigDecimal> entryIdToQtyMap = busEntrys.stream().collect(Collectors.toMap(entry -> entry.getLong("entry.id"), entry -> entry.getBigDecimal("entry.e_quantity")));
            Set<Long> busEntryIds = entryIdToQtyMap.keySet();
            Map<Long, Set<Long>> targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap("ar_busbill", "entry", busEntryIds.toArray(new Long[0]), "ar_revcfmbill");
            Set revEntryIds = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            DynamicObjectCollection revEntrys = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"entry.id,entry.e_confirmqty", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", revEntryIds)});
            Map<Long, BigDecimal> entryIdToCfmQtyMap = revEntrys.stream().collect(Collectors.toMap(entry -> entry.getLong("entry.id"), entry -> entry.getBigDecimal("entry.e_confirmqty")));
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
            for (Map.Entry entry2 : targetRowIdsMap.entrySet()) {
                long busEntryid = (Long)entry2.getKey();
                BigDecimal confirmedqty = BigDecimal.ZERO;
                Set revEntryids = (Set)entry2.getValue();
                for (Long revEntryid : revEntryids) {
                    confirmedqty = confirmedqty.add(entryIdToCfmQtyMap.get(revEntryid));
                }
                BigDecimal qty = entryIdToQtyMap.get(busEntryid);
                Object[] param = new Object[]{confirmedqty, qty.subtract(confirmedqty), busEntryid};
                updateParams.add(param);
            }
            if (updateParams.size() > 0) {
                String updateSql = "update t_ar_busbillentry_e set fconfirmedqty = ?,funconfirmqty = ?  where fentryid = ?";
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateParams);
            }
        }
    }
}

