/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.SchemeSettleService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.vo.ImportSettleParam;

public abstract class AbstractImportSettleService {
    protected static final Log logger = LogFactory.getLog(SchemeSettleService.class);
    protected Map<String, Object> resultMap = new HashMap<String, Object>(1);
    protected Set<String> settledBillSet = new HashSet<String>(2);
    private static final String ERRKEY_EXCESS = "excessErr";
    private static final String ERRKEY_STATUS = "statusErr";
    private static final int SETTLE_BATCH_SIZE = 10000;
    Map<String, String> serviceMap = new HashMap<String, String>(16);

    protected String getSelector(String entityName) {
        if ("ap_finapbill".equals(entityName)) {
            return "id,detailentry.unlockamt unlockamt";
        }
        if ("ar_finarbill".equals(entityName)) {
            return "id,entry.e_unlockamt unlockamt";
        }
        return "id,entry.e_unsettledamt unlockamt";
    }

    protected QFilter[] getFilter(String entityName, Set<Long> billIds) {
        if ("cas_paybill".equals(entityName)) {
            return new QFilter[]{new QFilter("id", "in", billIds), new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE)};
        }
        if ("cas_recbill".equals(entityName)) {
            return new QFilter[]{new QFilter("id", "in", billIds), new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE)};
        }
        return new QFilter[]{new QFilter("id", "in", billIds)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Map<String, Object> execute(DynamicObject[] settleArr, ImportSettleParam importSettleParam) {
        if (settleArr.length > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d85\u8fc7\u5bfc\u5165\u7ed3\u7b97\u76ee\u524d\u5904\u7406\u7684\u6700\u5927\u6570\u636e\u91cf\u3002", (String)"AbstractImportSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        long preStart = System.currentTimeMillis();
        long orgId = settleArr[0].getLong("org.id");
        HashMap<String, Set<Long>> groupByBillType = new HashMap<String, Set<Long>>(16);
        HashMap<Object, BigDecimal> currentSettleAmtMap = new HashMap<Object, BigDecimal>(16);
        for (DynamicObject data : settleArr) {
            Long mainBillID = data.getLong("mainbillid");
            String mainEntityName = data.getString("billentity");
            Set<Long> billIds = (HashSet<Long>)groupByBillType.get(mainEntityName);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
            }
            billIds.add(mainBillID);
            groupByBillType.put(mainEntityName, billIds);
            BigDecimal mainCurSettleAmt = data.getBigDecimal("totalsettleamt");
            BigDecimal currentSettleAmtSum = (BigDecimal)currentSettleAmtMap.get(mainBillID);
            if (currentSettleAmtSum == null) {
                currentSettleAmtMap.put(mainBillID, mainCurSettleAmt);
            } else {
                currentSettleAmtMap.put(mainBillID, mainCurSettleAmt.add(currentSettleAmtSum));
            }
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entry");
            for (DynamicObject asst : entry) {
                Long asstBillId = asst.getLong("billid");
                String asstEntityName = asst.getString("e_billentity");
                billIds = (Set)groupByBillType.get(asstEntityName);
                if (billIds == null) {
                    billIds = new HashSet(16);
                }
                billIds.add(asstBillId);
                groupByBillType.put(asstEntityName, billIds);
                BigDecimal asstCurSettleAmt = asst.getBigDecimal("settleamt");
                currentSettleAmtSum = (BigDecimal)currentSettleAmtMap.get(asstBillId);
                if (currentSettleAmtSum == null) {
                    currentSettleAmtMap.put(asstBillId, asstCurSettleAmt);
                    continue;
                }
                currentSettleAmtMap.put(asstBillId, asstCurSettleAmt.add(currentSettleAmtSum));
            }
        }
        this.addSettleControl(groupByBillType);
        try {
            HashMap<Long, BigDecimal> billCanSettleAmtMap = new HashMap<Long, BigDecimal>(16);
            for (Map.Entry entrySet : groupByBillType.entrySet()) {
                DynamicObjectCollection bills = QueryServiceHelper.query((String)((String)entrySet.getKey()), (String)this.getSelector((String)entrySet.getKey()), (QFilter[])this.getFilter((String)entrySet.getKey(), (Set)entrySet.getValue()));
                for (DynamicObject bill : bills) {
                    Long id = bill.getLong("id");
                    BigDecimal unlockAmt = bill.getBigDecimal("unlockamt");
                    billCanSettleAmtMap.merge(id, unlockAmt, (a, b) -> b.add((BigDecimal)a));
                }
            }
            HashSet<Long> overSettlementIds = new HashSet<Long>(16);
            for (Map.Entry entrySet : currentSettleAmtMap.entrySet()) {
                Long id = (Long)entrySet.getKey();
                BigDecimal currentSettleAmt = (BigDecimal)entrySet.getValue();
                BigDecimal billCanSettleAmt = (BigDecimal)billCanSettleAmtMap.get(id);
                if (billCanSettleAmt == null || currentSettleAmt.signum() == billCanSettleAmt.signum() && billCanSettleAmt.abs().compareTo(currentSettleAmt.abs()) >= 0) continue;
                overSettlementIds.add(id);
            }
            ArrayList<DynamicObject> settleList = new ArrayList<DynamicObject>(settleArr.length);
            settleList.addAll(Arrays.asList(settleArr));
            Iterator iterator = settleList.iterator();
            block19: while (iterator.hasNext()) {
                DynamicObject bill = (DynamicObject)iterator.next();
                Long mainBillId = bill.getLong("mainbillid");
                if (overSettlementIds.contains(mainBillId)) {
                    this.handleErrResult(bill.getLong("id"), ERRKEY_EXCESS);
                    iterator.remove();
                    continue;
                }
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                for (DynamicObject asst : entry) {
                    Long asstId = asst.getLong("billid");
                    if (!overSettlementIds.contains(asstId)) continue;
                    this.handleErrResult(bill.getLong("id"), ERRKEY_EXCESS);
                    iterator.remove();
                    continue block19;
                }
            }
            HashMap<void, ArrayList<DynamicObject>> importBillGroupMap = new HashMap<void, ArrayList<DynamicObject>>(16);
            for (DynamicObject bill : settleList) {
                void var19_29;
                Long mainCurrencyId = bill.getLong("maincurrency.id");
                Long asstCurrencyId = ((DynamicObject)bill.getDynamicObjectCollection("entry").get(0)).getLong("currency.id");
                String settleRelation = bill.getString("settlerelation");
                if (mainCurrencyId.equals(asstCurrencyId)) {
                    String string = "same_" + (String)settleRelation;
                } else {
                    String string = "diff_" + (String)settleRelation;
                }
                ArrayList<DynamicObject> importBills = (ArrayList<DynamicObject>)importBillGroupMap.get(var19_29);
                if (importBills == null) {
                    importBills = new ArrayList<DynamicObject>(16);
                }
                importBills.add(bill);
                importBillGroupMap.put(var19_29, importBills);
            }
            long startSettle = System.currentTimeMillis();
            logger.info("IMPORTSETTLE_PRE_COST" + (startSettle - preStart));
            try (TXHandle tx = TX.requiresNew((String)"rpaimportsettle");){
                try {
                    for (Map.Entry entry : importBillGroupMap.entrySet()) {
                        List settleRecords = (List)entry.getValue();
                        AssignSettleParam param = new AssignSettleParam(orgId, SettleTypeEnum.IMPORT.getValue(), SettleDetailTypeEnum.BYHEAD.getValue());
                        ArrayList<SettleDetailParam> mainDetailParam = new ArrayList<SettleDetailParam>(2);
                        ArrayList<SettleDetailParam> asstDetailParam = new ArrayList<SettleDetailParam>(2);
                        boolean isContinPre = false;
                        boolean haveCasBill = false;
                        String settleRelation = null;
                        for (DynamicObject settleRecord : settleRecords) {
                            long settleRecordId = settleRecord.getLong("id");
                            long mainbillid = settleRecord.getLong("mainbillid");
                            settleRelation = settleRecord.getString("settlerelation");
                            BigDecimal totalsettleamt = settleRecord.getBigDecimal("totalsettleamt");
                            SettleDetailParam mainParam = new SettleDetailParam(mainbillid, totalsettleamt);
                            mainParam.setMatchFieldValue("importBillId", settleRecordId);
                            mainDetailParam.add(mainParam);
                            DynamicObjectCollection entrColl = settleRecord.getDynamicObjectCollection("entry");
                            for (DynamicObject entry2 : entrColl) {
                                long billid = entry2.getLong("billid");
                                BigDecimal settleamt = entry2.getBigDecimal("settleamt");
                                SettleDetailParam asstParam = new SettleDetailParam(billid, settleamt);
                                asstParam.setMatchFieldValue("importBillId", settleRecordId);
                                asstDetailParam.add(asstParam);
                                String asstEntity = entry2.getString("e_billentity");
                                if (!"appaysettle".equals(settleRelation) && !"recsettle".equals(settleRelation)) continue;
                                if (!haveCasBill && ("cas_paybill".equals(asstEntity) || "cas_recbill".equals(asstEntity))) {
                                    haveCasBill = true;
                                }
                                if (isContinPre || !"ap_paidbill".equals(asstEntity) && !"ar_receivedbill".equals(asstEntity)) continue;
                                isContinPre = true;
                            }
                        }
                        param.setMainDetailParamList(mainDetailParam);
                        param.setAsstDetailParamList(asstDetailParam);
                        if (isContinPre) {
                            if (haveCasBill) {
                                param.setContainPre(true);
                            } else {
                                param.setAsstEntity("appaysettle".equals(settleRelation) ? "ap_paidbill" : "ar_receivedbill");
                            }
                        }
                        if (((String)entry.getKey()).startsWith("diff_")) {
                            param.setMatchDiffCurrency(true);
                        }
                        param.setMatchServiceClass("kd.fi.arapcommon.service.match.ImportSettleMatchService");
                        String[] keyStr = ((String)entry.getKey()).split("_");
                        param.setDiffCurrencySettle("diff".equals(keyStr[0]));
                        String relation = keyStr[1];
                        ISettleService service = ArApServiceAPIFactory.getSettleService(this.getServiceByRelation(relation));
                        service.assignSettle(param);
                    }
                    long endSettle = System.currentTimeMillis();
                    logger.info("IMPORTSETTLE_SETTLE_COST" + (endSettle - startSettle));
                    this.disposeImportBill(settleArr, importSettleParam.isDisposeImportBill());
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        finally {
            this.releaseSettleControl();
        }
        return this.resultMap;
    }

    protected String getServiceByRelation(String relation) {
        if (this.serviceMap.isEmpty()) {
            this.serviceMap.put("appaysettle", "appaysettle");
            this.serviceMap.put("payself", "payselfsettle");
            this.serviceMap.put("apself", "apselfsettle");
            this.serviceMap.put("aparsettle", "aparsettle");
            this.serviceMap.put("payrecsettle", "payrecsettle");
            this.serviceMap.put("aprecsettle", "aprecsettle");
            this.serviceMap.put("recsettle", "arrecsettle");
            this.serviceMap.put("arself", "arselfsettle");
            this.serviceMap.put("arapsettle", "arapsettle");
            this.serviceMap.put("recself", "recselfsettle");
            this.serviceMap.put("recpaysettle", "recpaysettle");
            this.serviceMap.put("arpaysettle", "arpaysettle");
        }
        return this.serviceMap.get(relation);
    }

    protected void disposeImportBill(DynamicObject[] bills, Boolean isDisposeImportBill) {
        if (isDisposeImportBill.booleanValue()) {
            List statusErr = (List)this.resultMap.get(ERRKEY_STATUS);
            List excessErr = (List)this.resultMap.get(ERRKEY_EXCESS);
            HashSet errSet = new HashSet(1);
            if (statusErr != null) {
                errSet.addAll(statusErr);
            }
            if (excessErr != null) {
                errSet.addAll(excessErr);
            }
            for (DynamicObject bill : bills) {
                Long id = bill.getLong("id");
                if (errSet.contains(id)) {
                    bill.set("settleresult", (Object)"2");
                    continue;
                }
                bill.set("settleresult", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    void handleErrResult(long billId, String errType) {
        ArrayList<Long> excessErr = (ArrayList<Long>)this.resultMap.get(errType);
        if (excessErr == null) {
            excessErr = new ArrayList<Long>(1);
        }
        excessErr.add(billId);
        this.resultMap.put(errType, excessErr);
    }

    private void addSettleControl(Map<String, Set<Long>> billMap) {
        for (Map.Entry<String, Set<Long>> entry : billMap.entrySet()) {
            CommonSettleServiceHelper.settleAddMutexCtrl(entry.getValue(), entry.getKey(), false);
        }
    }

    private void releaseSettleControl() {
        CommonSettleServiceHelper.settleReleaseMutexCtrl();
    }

    protected abstract AbstractSettleTemplate getSettleService(String var1);
}

