/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.log.RPASettleLogInfo;

public class RPASchemeSettleLogService {
    private static final String SUCCESS = "0";
    private static final String EXECUTE = "1";
    private static final String FAIL = "2";

    public static DynamicObject newSettleLog(DynamicObject scheme, long orgId, DynamicObject ruleEntry, String entityName, boolean isManual) {
        DynamicObject settleLog = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        settleLog.set("billno", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSSS").format(new Date()));
        settleLog.set("schemenumber", (Object)scheme.getString("number"));
        settleLog.set("schemename", (Object)scheme.getString("name"));
        settleLog.set("executor", scheme.get("executor"));
        settleLog.set("starttime", (Object)new Date());
        settleLog.set("executetype", (Object)(isManual ? EXECUTE : SUCCESS));
        settleLog.set("executestate", (Object)EXECUTE);
        settleLog.set("isstop", (Object)SUCCESS);
        settleLog.set("org", (Object)orgId);
        settleLog.set("schemeid", scheme.getPkValue());
        settleLog.set("schemeruleid", ruleEntry.getPkValue());
        settleLog.set("settlerelation", (Object)ruleEntry.getString("settlerelation"));
        settleLog.set("mainbillentity", (Object)ruleEntry.getString("mainbill"));
        settleLog.set("asstbillentity", (Object)ruleEntry.getString("asstbill"));
        try (TXHandle tx = TX.requiresNew((String)"newSettleLog");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{settleLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        return settleLog;
    }

    public static void updateCount(DynamicObject settleLog, int mainCount, int mainEntryCount, int asstCount, int asstEntryCount) {
        settleLog.set("maincount", (Object)mainCount);
        settleLog.set("mainentrycount", (Object)mainEntryCount);
        settleLog.set("asstcount", (Object)asstCount);
        settleLog.set("asstentrycount", (Object)asstEntryCount);
        try (TXHandle tx = TX.requiresNew((String)"updateSettleLog");){
            try {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{settleLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void updateProgress(DynamicObject settleLog, int mainProcessCount, int asstProcessCount, int settleRecordSize, BigDecimal mainSettleAmt, BigDecimal asstSettleAmt) {
        settleLog.set("mainexecutedcount", (Object)mainProcessCount);
        settleLog.set("asstexecutedcount", (Object)asstProcessCount);
        settleLog.set("settlerecordcount", (Object)(settleLog.getInt("settlerecordcount") + settleRecordSize));
        settleLog.set("mainsettleamt", (Object)new BigDecimal(settleLog.getString("mainsettleamt")).add(mainSettleAmt).toPlainString());
        settleLog.set("asstsettleamt", (Object)settleLog.getBigDecimal("asstsettleamt").add(asstSettleAmt));
        settleLog.set("executeprocess", (Object)RPASchemeSettleLogService.decimalToPercent(settleLog.getInt("mainexecutedcount") / settleLog.getInt("maincount")));
        try (TXHandle tx = TX.requiresNew((String)"updateSettleLog");){
            try {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{settleLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void updateSuccess(DynamicObject settleLog) {
        settleLog.set("executestate", (Object)SUCCESS);
    }

    public static void catchException(DynamicObject settleLog, String errorInfo) {
        settleLog.set("executestate", (Object)FAIL);
        settleLog.set("errordesc", (Object)(errorInfo.length() > 255 ? errorInfo.substring(0, 255) : errorInfo));
        settleLog.set("errordesc_tag", (Object)errorInfo);
    }

    public static void updateProgressComplete(DynamicObject settleLog) {
        settleLog.set("executeprocess", (Object)"100%");
        settleLog.set("endtime", (Object)new Date());
        String endDate = DateUtils.formatString(settleLog.getDate("endtime"), "yyyy-MM-dd HH:mm:ss");
        String startDate = DateUtils.formatString(settleLog.getDate("starttime"), "yyyy-MM-dd HH:mm:ss");
        long useTime = DateUtils.parseDate(endDate, "yyyy-MM-dd HH:mm:ss").getTime() - DateUtils.parseDate(startDate, "yyyy-MM-dd HH:mm:ss").getTime();
        BigDecimal useTimeSeconds = BigDecimal.valueOf(useTime).divide(BigDecimal.valueOf(1000L), 0, RoundingMode.HALF_UP);
        settleLog.set("usetime", (Object)useTimeSeconds);
        String errorInfo = settleLog.getString("errordesc");
        if (StringUtils.isEmpty(errorInfo)) {
            settleLog.set("executestate", (Object)SUCCESS);
        } else {
            settleLog.set("executestate", (Object)FAIL);
        }
        try (TXHandle tx = TX.requiresNew((String)"updateSettleLog");){
            try {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{settleLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static boolean isStop(DynamicObject settleLog) {
        DynamicObject rpaSettleLog = BusinessDataServiceHelper.loadSingle((Object)settleLog.getPkValue(), (String)settleLog.getDataEntityType().getName());
        return rpaSettleLog.getBoolean("isstop");
    }

    public static DynamicObject updateSettleLog(DynamicObject settleLog, RPASettleLogInfo settleLogInfo) {
        settleLog.set("executestate", (Object)settleLogInfo.getExecuteState());
        settleLog.set("maincount", (Object)settleLogInfo.getMainCount());
        settleLog.set("mainentrycount", (Object)settleLogInfo.getMainEntryCount());
        settleLog.set("asstcount", (Object)settleLogInfo.getAsstCount());
        settleLog.set("asstentrycount", (Object)settleLogInfo.getAsstEntryCount());
        settleLog.set("settlerecordcount", (Object)settleLogInfo.getSettleRecordCount());
        settleLog.set("mainexecutedcount", (Object)settleLogInfo.getMainExecutedCount());
        settleLog.set("mainsettleamt", (Object)settleLogInfo.getMainSettleAmt());
        settleLog.set("asstsettleamt", (Object)settleLogInfo.getAsstsettleAmt());
        settleLog.set("executeprocess", (Object)settleLogInfo.getExecuteProcess());
        return settleLog;
    }

    public static DynamicObject catchException(DynamicObject settleLog, RPASettleLogInfo settleLogInfo) {
        settleLog.set("executestate", (Object)FAIL);
        String error = settleLogInfo.getErrorDesc();
        settleLog.set("errordesc", (Object)(error.length() > 255 ? error.substring(0, 255) : error));
        settleLog.set("errordesc_tag", (Object)error);
        return settleLog;
    }

    private static String decimalToPercent(float value) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        return nf.format(value);
    }
}

