/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme.dataloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.rpascheme.dataloader.AbstractRPABillDataLoader;
import kd.fi.arapcommon.service.rpascheme.entity.RPABillDataParam;
import kd.fi.arapcommon.util.StdConfig;

public class CasPayRPABillDataLoader
extends AbstractRPABillDataLoader {
    protected CasPayRPABillDataLoader(RPABillDataParam param) {
        super(param);
    }

    @Override
    protected List<String> billSelector() {
        ArrayList<String> selector = new ArrayList<String>(32);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("basecurrency");
        selector.add("billtype");
        selector.add("payeetype");
        selector.add("paymenttype");
        selector.add("entrance");
        selector.add("currency");
        selector.add("payee");
        selector.add("payeename");
        selector.add("payquotation");
        selector.add("exchangerate");
        selector.add("itempayeetype");
        selector.add("entry.id");
        selector.add("entry.e_paymenttype");
        selector.add("entry.settleorg");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_payableamt");
        selector.add("entry.e_sourcebillentryid");
        selector.add("entry.e_corebillno");
        selector.add("entry.e_corebillentryseq");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.e_settledamt");
        selector.add("entry.conbillnumber");
        selector.add("entry.conbillrownum");
        return selector;
    }

    @Override
    protected String orgEntityName() {
        return "entry.settleorg";
    }

    @Override
    protected String entityEntryName() {
        return "entry";
    }

    @Override
    protected Map<Long, Long> loadUnfinishedIdMap(List<Map<String, Object>> dataList) {
        HashMap<Long, Long> unFinishedIdMap = new HashMap<Long, Long>(1);
        if (dataList.size() == 0) {
            return unFinishedIdMap;
        }
        String schemeSettleLoadUnfinishedId = StdConfig.get("SchemeSettleLoadUnfinishedId");
        if (schemeSettleLoadUnfinishedId == null || "true".equals(schemeSettleLoadUnfinishedId)) {
            HashSet<Long> billIds = new HashSet<Long>(8);
            for (Map<String, Object> rowData : dataList) {
                billIds.add((Long)rowData.get("id"));
            }
            List<String> unFinishedIds = TxSettleServiceHelper.loadPayBillSettleUnfinishedTxBillIds(billIds.stream().map(String::valueOf).collect(Collectors.toList()));
            if (!unFinishedIds.isEmpty()) {
                for (String unFinishedId : unFinishedIds) {
                    unFinishedIdMap.put(Long.valueOf(unFinishedId), Long.valueOf(unFinishedId));
                }
            }
        }
        return unFinishedIdMap;
    }
}

