/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme.dataloader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;

public class ImportSettleBillLoader {
    public static Map<String, DynamicObject> reloadBill(Map<String, Set<Long>> billMap) {
        DynamicObject[] billArr = new DynamicObject[billMap.size()];
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(2);
        for (Map.Entry<String, Set<Long>> entry : billMap.entrySet()) {
            DynamicObject[] billKey = entry.getKey();
            QFilter filter = new QFilter("id", "in", entry.getValue());
            switch (billKey) {
                case "ap_finapbill": {
                    filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                    billArr = FinApBillHandleHelper.load(new QFilter[]{filter});
                    break;
                }
                case "cas_paybill": {
                    filter.and(new QFilter("billstatus", "in", (Object)new String[]{"D", "F", "I"}));
                    billArr = PayBillHandleHelper.loadPay(new QFilter[]{filter});
                    break;
                }
                case "ar_finarbill": {
                    filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
                    billArr = FinArBillHandleHelper.load(new QFilter[]{filter});
                    break;
                }
                case "cas_recbill": {
                    filter.and(new QFilter("billstatus", "=", (Object)"D"));
                    billArr = RecBillHandlerHelper.loadRec(new QFilter[]{filter});
                }
            }
            for (DynamicObject bill : billArr) {
                returnMap.put((String)billKey + bill.getString("billno"), bill);
            }
        }
        return returnMap;
    }
}

