/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.rpascheme.entity;

import kd.fi.arapcommon.service.rpascheme.match.EqualMatchStrategy;
import kd.fi.arapcommon.service.rpascheme.match.MatchStrategy;
import kd.fi.arapcommon.service.rpascheme.match.SplitMatchStrategy;

public enum MatchStrategyEnum {
    EQUAL("0", new EqualMatchStrategy()),
    CONTAINS("1", new SplitMatchStrategy()),
    IN("2", new SplitMatchStrategy());

    private final String matchMode;
    private final MatchStrategy matchStrategy;

    private MatchStrategyEnum(String matchMode, MatchStrategy matchStrategy) {
        this.matchMode = matchMode;
        this.matchStrategy = matchStrategy;
    }

    public String getMatchMode() {
        return this.matchMode;
    }

    public MatchStrategy getMatchStrategy() {
        return this.matchStrategy;
    }

    public static MatchStrategy getMatchStrategy(String matchMode) {
        MatchStrategy matchStrategy = null;
        for (MatchStrategyEnum type : MatchStrategyEnum.values()) {
            if (!type.getMatchMode().equals(matchMode)) continue;
            matchStrategy = type.getMatchStrategy();
            break;
        }
        return matchStrategy;
    }

    public static boolean isNeedSplit(String matchMode) {
        boolean isSplit = false;
        if (matchMode.equals(MatchStrategyEnum.CONTAINS.matchMode) || matchMode.equals(MatchStrategyEnum.IN.matchMode)) {
            isSplit = true;
        }
        return isSplit;
    }
}

