/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.DiffCurrencyMatchSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.DiffCurrencySettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.EntryRelationSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.OrdinalSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.ProportionNewSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.ProportionSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.RPAOrdinalSettleRecordBuilder;
import kd.fi.arapcommon.service.settle.settlerecord.SettleRecordBuildParam;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class SettleRecordManager {
    private static final Log logger = LogFactory.getLog(SettleRecordManager.class);

    public static List<SettleRecordVO> buildSettleRecord(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        AbstractSettleRecordBuilder builder;
        if (1 == scheme.getSettleEntryParam()) {
            logger.info("settleParam:detail,settlerecord build use new");
            builder = scheme.isPremAutoSettle() ? (SettleRecordManager.isUseOldSRBuild(mainList) ? new ProportionSettleRecordBuilder() : new ProportionNewSettleRecordBuilder()) : (scheme.isOnlyByBotp() ? new EntryRelationSettleRecordBuilder() : (scheme.isRpaSchemeSettle() ? new RPAOrdinalSettleRecordBuilder() : new OrdinalSettleRecordBuilder()));
        } else if (SettleRecordManager.isUseOldSRBuild(mainList)) {
            logger.info("settleParam:plan,settlerecord build use old");
            if (scheme.isPremAutoSettle()) {
                builder = new ProportionSettleRecordBuilder();
            } else if (scheme.isAdjust()) {
                builder = new OrdinalSettleRecordBuilder();
            } else if (scheme.isTransferPay()) {
                ArrayList<BillSettleVO> upgradeBeforeAsstList = new ArrayList<BillSettleVO>(8);
                ArrayList<BillSettleVO> upgradeAfterAsstList = new ArrayList<BillSettleVO>(asstList.size());
                SettleRecordManager.groupForTransferSettle(asstList, upgradeBeforeAsstList, upgradeAfterAsstList);
                if (upgradeBeforeAsstList.size() > 0) {
                    logger.info("BIZ_V5.0.023 version execute old transfersettle");
                    OrdinalSettleRecordBuilder builder2 = new OrdinalSettleRecordBuilder();
                    builder2.initParam(new SettleRecordBuildParam(scheme, settleType));
                    return builder2.build(mainList, upgradeBeforeAsstList);
                }
                if (upgradeAfterAsstList.size() > 0) {
                    EntryRelationSettleRecordBuilder builder3 = new EntryRelationSettleRecordBuilder();
                    builder3.initParam(new SettleRecordBuildParam(scheme, settleType));
                    return builder3.build(mainList, upgradeAfterAsstList);
                }
                builder = new OrdinalSettleRecordBuilder();
            } else if (scheme.isLiquidateSettle()) {
                ArrayList<BillSettleVO> upgradeBeforeAsstList = new ArrayList<BillSettleVO>(8);
                ArrayList<BillSettleVO> upgradeAfterAsstList = new ArrayList<BillSettleVO>(asstList.size());
                SettleRecordManager.groupForLiquidationSettle(asstList, upgradeBeforeAsstList, upgradeAfterAsstList);
                if (upgradeBeforeAsstList.size() > 0) {
                    logger.info("BIZ_V6.0.001 version execute old liquidationsettle");
                    OrdinalSettleRecordBuilder builder4 = new OrdinalSettleRecordBuilder();
                    builder4.initParam(new SettleRecordBuildParam(scheme, settleType));
                    return builder4.build(mainList, upgradeBeforeAsstList);
                }
                if (upgradeAfterAsstList.size() > 0) {
                    EntryRelationSettleRecordBuilder builder5 = new EntryRelationSettleRecordBuilder();
                    builder5.initParam(new SettleRecordBuildParam(scheme, settleType));
                    return builder5.build(mainList, upgradeAfterAsstList);
                }
                builder = new OrdinalSettleRecordBuilder();
            } else {
                builder = scheme.isOnlyByBotp() ? new EntryRelationSettleRecordBuilder() : (scheme.isRpaSchemeSettle() ? new RPAOrdinalSettleRecordBuilder() : new OrdinalSettleRecordBuilder());
            }
        } else {
            logger.info("settleParam:plan,settlerecord build use new");
            builder = scheme.isPremAutoSettle() ? new ProportionNewSettleRecordBuilder() : (scheme.isOnlyByBotp() ? new EntryRelationSettleRecordBuilder() : (scheme.isRpaSchemeSettle() ? new RPAOrdinalSettleRecordBuilder() : new OrdinalSettleRecordBuilder()));
        }
        builder.initParam(new SettleRecordBuildParam(scheme, settleType));
        return builder.build(mainList, asstList);
    }

    public static List<SettleRecordVO> buildDiffCurrencySettleRecord(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        DiffCurrencySettleRecordBuilder builder = scheme.isMatchDiffCurrency() ? new DiffCurrencyMatchSettleRecordBuilder() : new DiffCurrencySettleRecordBuilder();
        builder.initParam(new SettleRecordBuildParam(scheme, settleType));
        return builder.build(mainList, asstList);
    }

    private static boolean isUseOldSRBuild(List<BillSettleVO> mainList) {
        boolean result = false;
        BillSettleVO mainSettleVO = mainList.get(0);
        String settleVersion = mainSettleVO.getSettleVersion();
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        if (!newCustomerUseNewSettle) {
            boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg(mainSettleVO.getOrgId());
            if ("0".equals(settleVersion) || "".equals(settleVersion)) {
                result = true;
            } else if (!allowNewSettleByOrg) {
                result = true;
            }
        }
        return result;
    }

    private static void groupForTransferSettle(List<BillSettleVO> asstList, List<BillSettleVO> upgradeBeforeAsstList, List<BillSettleVO> upgradeAfterAsstList) {
        Set billIds = asstList.stream().map(BillSettleVO::getId).collect(Collectors.toSet());
        String billEntity = asstList.get(0).getBillEntity();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntity, (String)"id,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashMap<Long, Boolean> billIdToDataVerMap = new HashMap<Long, Boolean>(1);
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime("BIZ_V5.0.023_DataUpgrade");
        upgradeTime = upgradeTime == null ? DateUtils.parseDate("2023-07-10", "yyyy-MM-dd") : upgradeTime;
        for (DynamicObject bill : bills) {
            Date billCreateTime = bill.getDate("createtime");
            if (billCreateTime.compareTo(upgradeTime) <= 0) {
                billIdToDataVerMap.put(bill.getLong("id"), Boolean.TRUE);
                continue;
            }
            billIdToDataVerMap.put(bill.getLong("id"), Boolean.FALSE);
        }
        for (BillSettleVO billSettleVO : asstList) {
            long billId = billSettleVO.getId();
            if (((Boolean)billIdToDataVerMap.get(billId)).booleanValue()) {
                upgradeBeforeAsstList.add(billSettleVO);
                continue;
            }
            upgradeAfterAsstList.add(billSettleVO);
        }
    }

    private static void groupForLiquidationSettle(List<BillSettleVO> asstList, List<BillSettleVO> upgradeBeforeAsstList, List<BillSettleVO> upgradeAfterAsstList) {
        Set billIds = asstList.stream().map(BillSettleVO::getId).collect(Collectors.toSet());
        String billEntity = asstList.get(0).getBillEntity();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntity, (String)"id,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashMap<Long, Boolean> billIdToDataVerMap = new HashMap<Long, Boolean>(1);
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime("BIZ_V6.0.001_DataUpgrade");
        upgradeTime = upgradeTime == null ? DateUtils.parseDate("2023-10-01", "yyyy-MM-dd") : upgradeTime;
        for (DynamicObject bill : bills) {
            Date billCreateTime = bill.getDate("createtime");
            if (billCreateTime.compareTo(upgradeTime) <= 0) {
                billIdToDataVerMap.put(bill.getLong("id"), Boolean.TRUE);
                continue;
            }
            billIdToDataVerMap.put(bill.getLong("id"), Boolean.FALSE);
        }
        for (BillSettleVO billSettleVO : asstList) {
            long billId = billSettleVO.getId();
            if (((Boolean)billIdToDataVerMap.get(billId)).booleanValue()) {
                upgradeBeforeAsstList.add(billSettleVO);
                continue;
            }
            upgradeAfterAsstList.add(billSettleVO);
        }
    }
}

