/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.arapcommon.service.settle.callscmc.AbstractCallOrderConService;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public abstract class AbstractDimensionService
extends AbstractCallOrderConService {
    private Map<Long, Map<String, List<SettleRecordEntryVO>>> detailEntryIdToAsstSameDimensionMap = new HashMap<Long, Map<String, List<SettleRecordEntryVO>>>(64);

    @Override
    protected void prepareParam(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills, DynamicObject[] wbBeforeBills) {
        super.prepareParam(settleRecords, wbAfterBills, wbBeforeBills);
        this.detailEntryIdToAsstSameDimensionMap = this.prepareAsstSameDimensionParam();
    }

    @Override
    protected boolean isGoNextStep(List<SettleRecordVO> settleRecords, DynamicObject[] wbAfterBills) {
        return this.isMain && super.isGoNextStep(settleRecords, wbAfterBills);
    }

    protected abstract Map<Long, Map<String, List<SettleRecordEntryVO>>> prepareAsstSameDimensionParam();

    protected abstract Map<String, Object> buildAsstParam(BigDecimal var1, SettleRecordEntryVO var2);

    @Override
    protected void buildWriteBackParamAndCall(DynamicObject[] wbAfterBills) {
        ArrayList<Map<String, Object>> allWriteBackParams = new ArrayList<Map<String, Object>>(64);
        for (DynamicObject mainBill : wbAfterBills) {
            Map<Long, Map<String, BigDecimal>> billDimensionAmountMap;
            if (!this.isMainBillLegal(mainBill) || ObjectUtils.isEmpty(billDimensionAmountMap = this.getBillDimensionAmountMap(mainBill))) continue;
            DynamicObjectCollection detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
            for (DynamicObject detailEntry : detailEntries) {
                Map<String, Object> writeBackMainParam;
                BigDecimal wbBeforeAmount;
                BigDecimal wbAfterAmount = detailEntry.getBigDecimal(this.eSettleAmtName);
                BigDecimal beforeShareAmount = wbAfterAmount.subtract(wbBeforeAmount = (BigDecimal)this.wbBeforeAmountMap.get(detailEntry.getLong("id")));
                if (BigDecimal.ZERO.compareTo(beforeShareAmount) == 0 || ObjectUtils.isEmpty(writeBackMainParam = this.orderConParamBuilder.buildParam(beforeShareAmount, mainBill, detailEntry))) continue;
                long detailEntryId = detailEntry.getLong("id");
                Map<String, List<SettleRecordEntryVO>> sameDimensionMap = this.detailEntryIdToAsstSameDimensionMap.get(detailEntryId);
                Map<String, BigDecimal> dimensionAmountMap = billDimensionAmountMap.get(detailEntryId);
                for (Map.Entry<String, List<SettleRecordEntryVO>> entrySet : sameDimensionMap.entrySet()) {
                    String dimension = entrySet.getKey();
                    List<SettleRecordEntryVO> asstSettleEntries = entrySet.getValue();
                    BigDecimal dimensionDisposeAmt = dimensionAmountMap.getOrDefault(dimension, BigDecimal.ZERO);
                    HashMap<String, Object> finalWriteBackParam = new HashMap<String, Object>(64);
                    Map<String, Object> asstParam = this.buildAsstParam(dimensionDisposeAmt, asstSettleEntries.get(0));
                    if (ObjectUtils.isEmpty(asstParam)) continue;
                    finalWriteBackParam.putAll(writeBackMainParam);
                    finalWriteBackParam.putAll(asstParam);
                    allWriteBackParams.add(finalWriteBackParam);
                    this.callSCMC(allWriteBackParams, false);
                }
            }
        }
        this.callSCMC(allWriteBackParams, true);
    }

    private Map<Long, Map<String, BigDecimal>> getBillDimensionAmountMap(DynamicObject mainBill) {
        int amtPrecision = mainBill.getInt("currency.amtprecision");
        DynamicObjectCollection detailEntries = mainBill.getDynamicObjectCollection(this.entryName);
        HashMap<Long, Map<String, BigDecimal>> billDimensionAmountMap = new HashMap<Long, Map<String, BigDecimal>>(64);
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal wbBeforeAmount;
            long entryId = detailEntry.getLong("id");
            BigDecimal wbAfterAmount = detailEntry.getBigDecimal(this.eSettleAmtName);
            BigDecimal beforeShareAmount = wbAfterAmount.subtract(wbBeforeAmount = (BigDecimal)this.wbBeforeAmountMap.get(entryId));
            if (BigDecimal.ZERO.compareTo(beforeShareAmount) == 0) continue;
            Map<String, List<SettleRecordEntryVO>> sameDimensionMap = this.detailEntryIdToAsstSameDimensionMap.get(entryId);
            BigDecimal entrySettleTotal = BigDecimal.ZERO;
            for (List<SettleRecordEntryVO> recordEntrys : sameDimensionMap.values()) {
                for (SettleRecordEntryVO recordEntry : recordEntrys) {
                    entrySettleTotal = entrySettleTotal.add(recordEntry.getSettleAmt());
                }
            }
            HashMap<String, BigDecimal> dimensionAmountMap = new HashMap<String, BigDecimal>(32);
            BigDecimal remainingAmt = beforeShareAmount;
            int times = 0;
            for (Map.Entry<String, List<SettleRecordEntryVO>> entrySet : sameDimensionMap.entrySet()) {
                BigDecimal sameDimensionAmt;
                ++times;
                String dimension = entrySet.getKey();
                List<SettleRecordEntryVO> recordEntryS = entrySet.getValue();
                BigDecimal dimensionSumAmt = BigDecimal.ZERO;
                for (SettleRecordEntryVO recordEntryVO : recordEntryS) {
                    dimensionSumAmt = dimensionSumAmt.add(recordEntryVO.getSettleAmt());
                }
                if (times == sameDimensionMap.size()) {
                    sameDimensionAmt = remainingAmt;
                } else {
                    BigDecimal proportion = dimensionSumAmt.divide(entrySettleTotal, 10, RoundingMode.HALF_UP);
                    sameDimensionAmt = beforeShareAmount.multiply(proportion).setScale(amtPrecision, RoundingMode.HALF_UP);
                    remainingAmt = remainingAmt.subtract(sameDimensionAmt);
                }
                dimensionAmountMap.put(dimension, sameDimensionAmt);
            }
            billDimensionAmountMap.put(entryId, dimensionAmountMap);
        }
        return billDimensionAmountMap;
    }
}

