/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.callscmc.AbstractDimensionService;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class PayRecCallOrderConServiceImpl
extends AbstractDimensionService {
    @Override
    public void initParam(CallSCMCParam callSCMCParam) {
        super.initParam(callSCMCParam);
        this.entryName = "entry";
        this.eSettleAmtName = "e_settledamt";
        this.eCoreBillIdName = "e_corebillid";
        this.eConBillIdName = "conbillid";
    }

    @Override
    protected void prepareAsstParam(List<SettleRecordVO> settleRecords) {
        DynamicObject[] asstBills;
        String selectors;
        ArrayList<Long> asstCasRecIds = new ArrayList<Long>(64);
        ArrayList<Long> asstArRecIds = new ArrayList<Long>(64);
        for (SettleRecordVO settleRecord : settleRecords) {
            List<SettleRecordEntryVO> recordEntrys = settleRecord.getEntrys();
            for (SettleRecordEntryVO recordEntry : recordEntrys) {
                if ("cas_recbill".equals(recordEntry.getBillEntity())) {
                    asstCasRecIds.add(recordEntry.getBillId());
                    continue;
                }
                asstArRecIds.add(recordEntry.getBillId());
            }
        }
        if (!asstArRecIds.isEmpty()) {
            selectors = "id,rectype";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"ar_receivedbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstArRecIds)})) {
                this.asstBillMap.put(asstBill.getLong("id"), asstBill);
            }
        }
        if (!asstCasRecIds.isEmpty()) {
            selectors = "id,receivingtype,e_receivingtype";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstCasRecIds)})) {
                this.asstBillMap.put(asstBill.getLong("id"), asstBill);
                DynamicObjectCollection entries = asstBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    this.asstBillEntryMap.put(entry.getLong("id"), entry);
                }
            }
        }
    }

    @Override
    protected boolean isMainBillLegal(DynamicObject mainBill) {
        return true;
    }

    @Override
    protected Map<Long, Map<String, List<SettleRecordEntryVO>>> prepareAsstSameDimensionParam() {
        HashMap<Long, Map<String, List<SettleRecordEntryVO>>> asstSameDimensionMap = new HashMap<Long, Map<String, List<SettleRecordEntryVO>>>(64);
        for (Map.Entry entrySet : this.settleRecordsMap.entrySet()) {
            Long mainBillId = (Long)entrySet.getKey();
            Map sameDimensionMap = asstSameDimensionMap.getOrDefault(mainBillId, new HashMap(64));
            List recordEntryS = (List)entrySet.getValue();
            for (SettleRecordEntryVO recordEntry : recordEntryS) {
                String asstBillEntity = recordEntry.getBillEntity();
                DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
                DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                String dimension = null;
                if ("cas_recbill".equals(asstBillEntity)) {
                    dimension = asstEntry.getString("e_receivingtype.biztype");
                } else if ("ar_receivedbill".equals(asstBillEntity)) {
                    dimension = asstBill.getString("rectype.biztype");
                }
                if (dimension == null) continue;
                List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                sameDimensionEntrys.add(recordEntry);
                sameDimensionMap.put(dimension, sameDimensionEntrys);
            }
            asstSameDimensionMap.put(mainBillId, sameDimensionMap);
        }
        return asstSameDimensionMap;
    }

    @Override
    protected Map<String, Object> buildAsstParam(BigDecimal disposeAmt, SettleRecordEntryVO recordEntry) {
        HashMap<String, Object> asstParamMap = new HashMap<String, Object>(16);
        DynamicObject asstBill = (DynamicObject)this.asstBillMap.get(recordEntry.getBillId());
        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
        asstParamMap.put("amount", disposeAmt.negate());
        if ("cas_recbill".equals(recordEntry.getBillEntity())) {
            asstParamMap.put("recbill_rectype_biztype", asstEntry.getString("e_receivingtype.biztype"));
        } else {
            asstParamMap.put("recbill_rectype_biztype", asstBill.getString("rectype.biztype"));
        }
        return asstParamMap;
    }
}

