/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.callscmc.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.callscmc.AbstractDimensionService;
import kd.fi.arapcommon.vo.CallSCMCParam;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class RecSelfCallOrderConServiceImpl
extends AbstractDimensionService {
    @Override
    public void initParam(CallSCMCParam callSCMCParam) {
        super.initParam(callSCMCParam);
        this.entryName = "entry";
        this.eSettleAmtName = "e_settledamt";
        this.eCoreBillIdName = "e_corebillid";
        this.eConBillIdName = "conbillid";
    }

    @Override
    protected void prepareAsstParam(List<SettleRecordVO> settleRecords) {
        ArrayList<Long> asstCasRecIds = new ArrayList<Long>(64);
        for (SettleRecordVO settleRecord : settleRecords) {
            List<SettleRecordEntryVO> recordEntrys = settleRecord.getEntrys();
            for (SettleRecordEntryVO recordEntry : recordEntrys) {
                if (!"cas_recbill".equals(recordEntry.getBillEntity())) continue;
                asstCasRecIds.add(recordEntry.getBillId());
            }
        }
        if (!asstCasRecIds.isEmpty()) {
            DynamicObject[] asstBills;
            String selectors = "e_corebilltype,e_corebillid,e_corebillentryid,entry.id";
            for (DynamicObject asstBill : asstBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", asstCasRecIds)})) {
                DynamicObjectCollection entries = asstBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    this.asstBillEntryMap.put(entry.getLong("id"), entry);
                }
            }
        }
    }

    @Override
    protected boolean isMainBillLegal(DynamicObject mainBill) {
        return true;
    }

    @Override
    protected Map<Long, Map<String, List<SettleRecordEntryVO>>> prepareAsstSameDimensionParam() {
        HashMap<Long, Map<String, List<SettleRecordEntryVO>>> asstSameDimensionMap = new HashMap<Long, Map<String, List<SettleRecordEntryVO>>>(64);
        for (Map.Entry entrySet : this.settleRecordsMap.entrySet()) {
            Long mainBillId = (Long)entrySet.getKey();
            Map sameDimensionMap = asstSameDimensionMap.getOrDefault(mainBillId, new HashMap(64));
            List recordEntryS = (List)entrySet.getValue();
            for (SettleRecordEntryVO recordEntry : recordEntryS) {
                String asstBillEntity = recordEntry.getBillEntity();
                DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
                if (!"cas_recbill".equals(asstBillEntity)) continue;
                String eCoreBillType = asstEntry.getString("e_corebilltype");
                long eCoreBillId = asstEntry.getLong("e_corebillid");
                long eCoreBillEntryId = asstEntry.getLong("e_corebillentryid");
                String dimension = eCoreBillType + eCoreBillId + eCoreBillEntryId;
                List sameDimensionEntrys = sameDimensionMap.getOrDefault(dimension, new ArrayList(64));
                sameDimensionEntrys.add(recordEntry);
                sameDimensionMap.put(dimension, sameDimensionEntrys);
            }
            asstSameDimensionMap.put(mainBillId, sameDimensionMap);
        }
        return asstSameDimensionMap;
    }

    @Override
    protected Map<String, Object> buildAsstParam(BigDecimal disposeAmt, SettleRecordEntryVO recordEntry) {
        HashMap<String, Object> asstParamMap = new HashMap<String, Object>(16);
        DynamicObject asstEntry = (DynamicObject)this.asstBillEntryMap.get(recordEntry.getBillEntryId());
        if ("cas_recbill".equals(recordEntry.getBillEntity())) {
            asstParamMap.put("amount", disposeAmt.negate());
            asstParamMap.put("recMainBillEntity", asstEntry.getString("e_corebilltype"));
            asstParamMap.put("recMainBillID", asstEntry.getLong("e_corebillid"));
            asstParamMap.put("recMainBillEntryID", asstEntry.getLong("e_corebillentryid"));
        }
        return asstParamMap;
    }
}

