/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class FinApSettleVOConverter {
    private static final Log logger = LogFactory.getLog(FinApSettleVOConverter.class);

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills, SettleSchemeVO scheme) {
        int asstSettleEntryParam;
        logger.info("FinApSettleVOConverter convert2VO start");
        List<DynamicObject> billList = Arrays.stream(bills).collect(Collectors.toList());
        Iterator it = billList.iterator();
        while (it.hasNext()) {
            DynamicObject bill = (DynamicObject)it.next();
            String billStatus = bill.getString("billstatus");
            if (!"A".equals(billStatus)) continue;
            it.remove();
        }
        bills = billList.toArray(new DynamicObject[0]);
        int settleParam = scheme.getSettleEntryParam();
        if (SettleRelationEnum.ARAPSETTLE.getValue().equals(scheme.getSettleRelation()) && (asstSettleEntryParam = scheme.getAsstSettleEntryParam()) != 0) {
            settleParam = scheme.getAsstSettleEntryParam();
        }
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("ap_finapbill");
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(8);
        if (1 == settleParam) {
            logger.info("FinApSettleVOConverter convert2VO settleParam : detail");
            for (DynamicObject bill : bills) {
                DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries) {
                    BigDecimal allowSettleAmt = detailEntry.getBigDecimal("unsettleamt");
                    if (scheme.isOnlyByCoreBill() || scheme.isOnlyByConBill()) {
                        allowSettleAmt = detailEntry.getBigDecimal("unlockamt");
                    }
                    if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    BillSettleVO settleVO = FinApSettleVOConverter.newDetailVO(bill, detailEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    settleVO.setEntryUnSettleAmt(allowSettleAmt);
                    resultList.add(settleVO);
                }
            }
        } else {
            logger.info("FinApSettleVOConverter convert2VO settleParam : plan");
            for (DynamicObject bill : bills) {
                DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
                DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("detailentry");
                long coreBillId = 0L;
                if (detailEntrys.size() > 0) {
                    DynamicObject detailEntry = (DynamicObject)detailEntrys.get(0);
                    coreBillId = detailEntry.getLong("corebillid");
                }
                for (DynamicObject planEntry : planEntrys) {
                    BigDecimal allowSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (scheme.isOnlyByCoreBill() || scheme.isOnlyByConBill()) {
                        allowSettleAmt = planEntry.getBigDecimal("unplanlockamt");
                    }
                    if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    BillSettleVO settleVO = FinApSettleVOConverter.newPlanVO(bill, planEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    settleVO.setEntryUnSettleAmt(allowSettleAmt);
                    settleVO.setCorebillId(coreBillId);
                    resultList.add(settleVO);
                }
            }
        }
        logger.info("FinApSettleVOConverter convert2VO end");
        return resultList;
    }

    public static List<BillSettleVO> convert2VOForPremAndTransfor(DynamicObject[] assts, SettleSchemeVO scheme) {
        logger.info("FinApSettleVOConverter convert2VOForPremAndTransfor start");
        int settleParam = scheme.getSettleEntryParam();
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("ap_finapbill");
        ArrayList<BillSettleVO> asstList = new ArrayList<BillSettleVO>(8);
        if (1 == settleParam) {
            logger.info("FinApSettleVOConverter convert2VOForPremAndTransfor settleParam : detail");
            for (DynamicObject asst : assts) {
                DynamicObjectCollection detailEntrys = asst.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntrys) {
                    BillSettleVO settleVO = FinApSettleVOConverter.newDetailVO(asst, detailEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    settleVO.setSouBillId(asst.getLong("sourcebillid"));
                    settleVO.setEntryUnSettleAmt(settleVO.getEntryPayableAmt());
                    asstList.add(settleVO);
                }
            }
        } else {
            logger.info("FinApSettleVOConverter convert2VOForPremAndTransfor settleParam : plan");
            for (DynamicObject asst : assts) {
                DynamicObjectCollection planEntrys = asst.getDynamicObjectCollection("planentity");
                for (DynamicObject planEntry : planEntrys) {
                    BillSettleVO settleVO = FinApSettleVOConverter.newPlanVO(asst, planEntry, extKeys);
                    settleVO.setSettleEntry(settleParam);
                    settleVO.setSouBillId(asst.getLong("sourcebillid"));
                    settleVO.setEntryUnSettleAmt(settleVO.getEntryPayableAmt());
                    asstList.add(settleVO);
                }
            }
        }
        logger.info("FinApSettleVOConverter convert2VOForPremAndTransfor start");
        return asstList;
    }

    private static BillSettleVO newDetailVO(DynamicObject bill, DynamicObject detailEntry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        FinApSettleVOConverter.newHeadVO(settleVO, bill);
        settleVO.setEntryEntity(detailEntry.getDataEntityType().getName());
        settleVO.setEntryId(detailEntry.getLong("id"));
        settleVO.setEntryMaterialId(detailEntry.getLong("material.id"));
        settleVO.setEntryExpenseItemId(detailEntry.getLong("expenseitem.id"));
        settleVO.setEntryCoreBillNum(detailEntry.getString("corebillno"));
        settleVO.setEntryCoreBillseq(detailEntry.getString("corebillentryseq"));
        settleVO.setCorebillId(detailEntry.getLong("corebillid"));
        settleVO.setCorebillEntryId(detailEntry.getLong("corebillentryid"));
        settleVO.setEntryConBillNum(detailEntry.getString("e_conbillnumber"));
        settleVO.setEntryConBillseq(detailEntry.getString("e_conbillrownum"));
        settleVO.setEntryPayableAmt(detailEntry.getBigDecimal("e_pricetaxtotal"));
        settleVO.setEntrySettledAmt(detailEntry.getBigDecimal("settledamt"));
        settleVO.setEntryUnSettleAmt(detailEntry.getBigDecimal("unsettleamt"));
        settleVO.setEntrySouBillId(detailEntry.getLong("e_sourcebillentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, detailEntry, extKeys));
        }
        return settleVO;
    }

    private static BillSettleVO newPlanVO(DynamicObject bill, DynamicObject planEntry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        FinApSettleVOConverter.newHeadVO(settleVO, bill);
        settleVO.setEntryEntity(planEntry.getDataEntityType().getName());
        settleVO.setEntryId(planEntry.getLong("id"));
        settleVO.setEntryPayableAmt(planEntry.getBigDecimal("planpricetax"));
        settleVO.setEntrySettledAmt(planEntry.getBigDecimal("plansettledamt"));
        settleVO.setEntryUnSettleAmt(planEntry.getBigDecimal("unplansettleamt"));
        settleVO.setPlanDueDate(planEntry.getDate("planduedate"));
        settleVO.setEntrySouBillId(planEntry.getLong("p_sourcebillentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, planEntry, extKeys));
        }
        return settleVO;
    }

    private static void newHeadVO(BillSettleVO settleVO, DynamicObject bill) {
        settleVO.setBillEntity(bill.getDataEntityType().getName());
        settleVO.setId(bill.getLong("id"));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setOrgId(bill.getLong("org.id"));
        settleVO.setBillNo(bill.getString("billno"));
        long billType = bill.getLong("billtypeid.id");
        String billTypeEnum = BillTypeConsts.getBillTypeMap().get(billType);
        if (ObjectUtils.isEmpty((Object)billTypeEnum)) {
            billTypeEnum = bill.getString("billtypeid.number");
        }
        settleVO.setBillType(billTypeEnum);
        settleVO.setBizdate(bill.getDate("bizdate"));
        settleVO.setPayableAmt(bill.getBigDecimal("pricetaxtotal"));
        settleVO.setQuotation(bill.getString("quotation"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangeRate"));
        settleVO.setAsstActType(bill.getString("asstacttype"));
        settleVO.setAsstActId(bill.getLong("asstact.id"));
        settleVO.setAsstActName(bill.getString("asstact.name"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setPayPropertyType("ap_payproperty");
        settleVO.setPayPropertyField(bill.getLong("payproperty.id"));
        settleVO.setSettleVersion(bill.getString("settleversion"));
    }
}

