/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.vo.BillSettleVO;

public class LiquApSettleVOConverter {
    private static final Log logger = LogFactory.getLog(LiquApSettleVOConverter.class);

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills) {
        logger.info("LiquApSettleVOConverter convert2VO start");
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(64);
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("ap_liquidation");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                BigDecimal allowSettleAmt = entry.getBigDecimal("unsettleamt");
                if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BillSettleVO settleVO = LiquApSettleVOConverter.newVO(bill, entry, extKeys);
                resultList.add(settleVO);
            }
        }
        logger.info("LiquApSettleVOConverter convert2VO end");
        return resultList;
    }

    private static BillSettleVO newVO(DynamicObject bill, DynamicObject entry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        settleVO.setId(bill.getLong("id"));
        settleVO.setBillEntity(bill.getDataEntityType().getName());
        settleVO.setBillType(SettleBillTypeEnum.LIQUIDATION.getValue());
        settleVO.setBillNo(bill.getString("billno"));
        settleVO.setOrgId(bill.getDynamicObject("org").getLong("id"));
        settleVO.setBizdate(bill.getDate("liquidationdate"));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setQuotation(bill.getString("quotation"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangeRate"));
        settleVO.setPayPropertyType("ap_payproperty");
        settleVO.setPayPropertyField(entry.getLong("e_payproperty.id"));
        settleVO.setAsstActType(bill.getString("asstacttype"));
        settleVO.setAsstActId(bill.getLong("asstact.id"));
        settleVO.setAsstActName(bill.getString("asstact.name"));
        settleVO.setEntryId(entry.getLong("id"));
        settleVO.setEntryEntity(entry.getDataEntityType().getName());
        String itemType = entry.getString("itemtype");
        if ("bd_material".equalsIgnoreCase(itemType)) {
            settleVO.setEntryMaterialId(entry.getLong("item.id"));
        } else {
            settleVO.setEntryExpenseItemId(entry.getLong("item.id"));
        }
        settleVO.setEntryPayableAmt(entry.getBigDecimal("amount"));
        settleVO.setEntryUnSettleAmt(entry.getBigDecimal("unsettleamt"));
        settleVO.setEntrySettledAmt(new BigDecimal("0"));
        settleVO.setEntrySouBillId(entry.getLong("sourceentryid"));
        settleVO.setSouBillId(entry.getLong("sourcebillid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, entry, extKeys));
        }
        return settleVO;
    }
}

