/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.ext.SettleRecordExtDataListKeyVO;
import kd.fi.arapcommon.service.settle.convert.SettleRecordExtConverter;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.BillSettleVO;

public class RecSettleVOConverter {
    private static final Log logger = LogFactory.getLog(RecSettleVOConverter.class);
    private static final String RECTYPE_NUM = "101";

    public static List<BillSettleVO> convert2VO(DynamicObject[] bills) {
        logger.info("RecSettleVOConverter convert2VO start");
        ArrayList<BillSettleVO> resultList = new ArrayList<BillSettleVO>(64);
        List<SettleRecordExtDataListKeyVO> extKeys = SettleExtDataLoader.loadSettleRecordExtListKeys("cas_recbill");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                DynamicObject receivingType = entry.getDynamicObject("e_receivingtype");
                if (ObjectUtils.isEmpty((Object)receivingType)) continue;
                boolean isPartReceivable = receivingType.getBoolean("ispartreceivable");
                BigDecimal allowSettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (allowSettleAmt.compareTo(BigDecimal.ZERO) == 0 || !isPartReceivable) continue;
                BillSettleVO settleVO = RecSettleVOConverter.newVO(bill, entry, extKeys);
                resultList.add(settleVO);
            }
        }
        logger.info("RecSettleVOConverter convert2VO end");
        return resultList;
    }

    private static BillSettleVO newVO(DynamicObject bill, DynamicObject entry, List<SettleRecordExtDataListKeyVO> extKeys) {
        BillSettleVO settleVO = new BillSettleVO();
        settleVO.setBillEntity(bill.getDynamicObjectType().getName());
        settleVO.setId(bill.getLong("id"));
        settleVO.setOrgId(entry.getLong("e_settleorg.id"));
        settleVO.setBillNo(bill.getString("billno"));
        settleVO.setBillType(bill.getString("biztype"));
        DynamicObject receivingType = bill.getDynamicObject("receivingtype");
        if (receivingType != null && EntityMetadataUtils.isExistProperty(receivingType, "biztype") && RECTYPE_NUM.equals(receivingType.getString("biztype"))) {
            settleVO.setBillType(SettleBillTypeEnum.ADVREC.getValue());
        }
        settleVO.setBizdate(bill.getDate("bizdate"));
        settleVO.setCurrencyId(bill.getLong("currency.id"));
        settleVO.setAsstActType(bill.getString("payertype"));
        settleVO.setAsstActId(bill.getLong("payer"));
        settleVO.setAsstActName(bill.getString("payername"));
        settleVO.setPrecision(bill.getInt("currency.amtprecision"));
        settleVO.setBasePrecision(bill.getInt("basecurrency.amtprecision"));
        settleVO.setQuotation(bill.getString("quotation"));
        settleVO.setExchangeRate(bill.getBigDecimal("exchangerate"));
        settleVO.setPayPropertyType("cas_receivingbilltype");
        settleVO.setPayPropertyField(entry.getLong("e_receivingtype.id"));
        settleVO.setEntryId(entry.getLong("id"));
        settleVO.setEntryEntity(entry.getDataEntityType().getName());
        settleVO.setEntryMaterialId(entry.getLong("e_material.id"));
        settleVO.setEntryExpenseItemId(entry.getLong("e_expenseitem.id"));
        settleVO.setEntryPayableAmt(entry.getBigDecimal("e_receivableamt"));
        settleVO.setEntryUnSettleAmt(entry.getBigDecimal("e_unsettledamt"));
        settleVO.setEntrySettledAmt(entry.getBigDecimal("e_settledamt"));
        settleVO.setEntryCoreBillType(entry.getString("e_corebilltype"));
        settleVO.setEntryCoreBillNum(entry.getString("e_corebillno"));
        settleVO.setEntryCoreBillseq(entry.getString("e_corebillentryseq"));
        settleVO.setEntrySouBillId(entry.getLong("e_sourcebillentryid"));
        if (extKeys.size() > 0) {
            settleVO.setExtFields(SettleRecordExtConverter.convert(bill, entry, extKeys));
        }
        return settleVO;
    }
}

