/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.convert;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class SettleRecordConverter {
    private static final Log logger = LogFactory.getLog(SettleRecordConverter.class);

    public static DynamicObject[] convertVO2Dyn(List<SettleRecordVO> resultList, boolean isAr) {
        logger.info("SettleRecordConverter convertVO2Dyn start");
        DynamicObject[] resultArr = new DynamicObject[resultList.size()];
        DynamicObjectType dt = null;
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        HashSet orgIds = new HashSet(2);
        resultList.forEach(settleRecordVO -> orgIds.add(settleRecordVO.getOrgId()));
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgIds.toArray(), (String)"bos_org");
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            SettleRecordVO sr = resultList.get(i);
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)settleRecordEntity);
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            result.set("billstatus", (Object)"B");
            result.set("org", orgs.get(sr.getOrgId()));
            result.set("creator", (Object)sr.getCreatorId());
            result.set("billno", (Object)sr.getBillNo());
            result.set("mainbizdate", (Object)sr.getBillDate());
            result.set("mainbilltype", (Object)sr.getBillType());
            result.set("mainasstacttype", (Object)sr.getAsstActType());
            result.set("mainasstactid", (Object)sr.getAsstActId());
            result.set("mainasstact", (Object)sr.getAsstActName());
            result.set("material", (Object)sr.getMaterialId());
            result.set("expenseitem", (Object)sr.getExpenseItemId());
            result.set("maincurrency", (Object)sr.getCurrencyId());
            result.set("mainpayableamt", (Object)sr.getMainPayableAmt());
            result.set("quotation", (Object)sr.getQuotation());
            result.set("exchangerate", (Object)sr.getExchangeRate());
            result.set("totalsettleamt", (Object)sr.getTotalSettleAmt());
            result.set("localtotalsettleamt", (Object)sr.getLocalTotalSettleamt());
            result.set("swappl", (Object)sr.getSwapPL());
            result.set("settlerelation", (Object)sr.getSettleRela());
            result.set("settledate", (Object)sr.getSettleDate());
            result.set("settletype", (Object)sr.getSettleType());
            result.set("settleseq", (Object)sr.getSettleSeq());
            result.set("mainbillid", (Object)sr.getMainBillId());
            result.set("mainbillentryid", (Object)sr.getMainBillEntryId());
            result.set("corebillid", (Object)sr.getCorebillId());
            result.set("corebillentryid", (Object)sr.getCorebillEntryId());
            result.set("settlelogentryid", (Object)sr.getSettleLogEntryId());
            result.set("planduedate", (Object)sr.getPlanDueDate());
            result.set("settleentry", (Object)sr.getSettleEntry());
            result.set("billentity", (Object)sr.getBillEntity());
            result.set("paypropertytype", (Object)sr.getPayPropertyType());
            result.set("paypropertyfield", (Object)sr.getPayPropertyField());
            result.set("autosettletype", (Object)sr.getAutoSettleType());
            Map<String, Object> mapExtData = sr.getExtFields();
            if (mapExtData != null) {
                mapExtData.forEach((k, v) -> {
                    if (EntityMetadataUtils.isExistProperty(result, k)) {
                        result.set(k, v);
                    }
                });
            }
            List<SettleRecordEntryVO> srEntrys = sr.getEntrys();
            int seq = 1;
            for (SettleRecordEntryVO srEntry : srEntrys) {
                DynamicObject resultEntry = new DynamicObject(dt);
                resultEntry.set("seq", (Object)seq);
                resultEntry.set("billnum", (Object)srEntry.getBillNum());
                resultEntry.set("billdate", (Object)srEntry.getBillDate());
                resultEntry.set("billtype", (Object)srEntry.getBillType());
                resultEntry.set("currency", (Object)srEntry.getCurrencyId());
                resultEntry.set("asstacttype", (Object)srEntry.getAsstActType());
                resultEntry.set("asstactid", (Object)srEntry.getAsstActId());
                resultEntry.set("asstact", (Object)srEntry.getAsstAct());
                resultEntry.set("e_material", (Object)srEntry.getMaterialId());
                resultEntry.set("e_expenseitem", (Object)srEntry.getExpenseItemId());
                resultEntry.set("payableamt", (Object)srEntry.getPayableAmt());
                resultEntry.set("e_quotation", (Object)srEntry.getQuotation());
                resultEntry.set("e_exchangerate", (Object)srEntry.getExchangeRate());
                resultEntry.set("settleamt", (Object)srEntry.getSettleAmt());
                resultEntry.set("localsettleamt", (Object)srEntry.getLocalSettleAmt());
                resultEntry.set("e_swappl", (Object)srEntry.getSwapPL());
                resultEntry.set("billid", (Object)srEntry.getBillId());
                resultEntry.set("billentryid", (Object)srEntry.getBillEntryId());
                resultEntry.set("e_planduedate", (Object)srEntry.getPlanDueDate());
                resultEntry.set("e_settleentry", (Object)srEntry.getSettleEntry());
                resultEntry.set("e_billentity", (Object)srEntry.getBillEntity());
                resultEntry.set("e_paypropertytype", (Object)srEntry.getPayPropertyType());
                resultEntry.set("e_paypropertyfield", (Object)srEntry.getPayPropertyField());
                Map<String, Object> mapExtDataEntry = srEntry.getExtFields();
                if (mapExtDataEntry != null) {
                    mapExtDataEntry.forEach((k, v) -> {
                        String key = "e_" + k;
                        if (EntityMetadataUtils.isExistProperty(resultEntry, key)) {
                            resultEntry.set(key, v);
                        }
                    });
                }
                result.getDynamicObjectCollection("entry").add((Object)resultEntry);
                ++seq;
            }
            resultArr[i] = result;
        }
        logger.info("SettleRecordConverter convertVO2Dyn end");
        return resultArr;
    }

    public static SettleRecordVO convertDyn2VO(DynamicObject result) {
        SettleRecordVO vo = new SettleRecordVO();
        if (EntityMetadataUtils.isExistProperty(result, "billentity")) {
            vo.setBillEntity(result.getString("billentity"));
        }
        vo.setBillType(result.getString("mainbilltype"));
        vo.setMainPayableAmt(result.getBigDecimal("mainpayableamt"));
        vo.setMainBillId(result.getLong("mainbillid"));
        vo.setMainBillEntryId(result.getLong("mainbillentryid"));
        vo.setTotalSettleAmt(result.getBigDecimal("totalsettleamt"));
        vo.setLocalTotalSettleamt(result.getBigDecimal("localtotalsettleamt"));
        vo.setSettleRela(result.getString("settlerelation"));
        vo.setSettleType(result.getString("settletype"));
        vo.setExchangeRate(result.getBigDecimal("exchangerate"));
        vo.setCorebillId(result.getLong("corebillid"));
        vo.setCorebillEntryId(result.getLong("corebillentryid"));
        vo.setSettleEntry(result.getInt("settleentry"));
        vo.setAutoSettleType(result.getString("autosettletype"));
        DynamicObjectCollection dynEntrys = result.getDynamicObjectCollection("entry");
        for (DynamicObject dynEntry : dynEntrys) {
            SettleRecordEntryVO entryVO = new SettleRecordEntryVO();
            entryVO.setBillId(dynEntry.getLong("billid"));
            entryVO.setBillEntryId(dynEntry.getLong("billentryid"));
            entryVO.setBillType(dynEntry.getString("billtype"));
            if (EntityMetadataUtils.isExistProperty(dynEntry, "e_billentity")) {
                entryVO.setBillEntity(dynEntry.getString("e_billentity"));
            }
            entryVO.setCurrencyId(dynEntry.getLong("currency.id"));
            entryVO.setSettleAmt(dynEntry.getBigDecimal("settleamt"));
            entryVO.setLocalSettleAmt(dynEntry.getBigDecimal("localsettleamt"));
            entryVO.setExchangeRate(dynEntry.getBigDecimal("e_exchangerate"));
            entryVO.setSettleType(result.getString("settletype"));
            entryVO.setSettleEntry(dynEntry.getInt("e_settleentry"));
            entryVO.setAutoSettleType(result.getString("autosettletype"));
            vo.getEntrys().add(entryVO);
        }
        return vo;
    }
}

