/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.match.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.settle.match.base.CurrencyMatch;
import kd.fi.arapcommon.service.settle.match.base.ExtMatch;
import kd.fi.arapcommon.service.settle.match.base.ISettleMatch;
import kd.fi.arapcommon.service.settle.match.base.OrgMatch;
import kd.fi.arapcommon.service.settle.match.service.ISettleMatcher;
import kd.fi.arapcommon.service.settle.match.service.SettleMatcherParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractSettleMatcher
implements ISettleMatcher {
    private static final Log logger = LogFactory.getLog(AbstractSettleMatcher.class);
    protected SettleSchemeVO scheme;
    protected List<ISettleMatch> matchHandlers;

    @Override
    public void initParam(SettleMatcherParam param) {
        logger.info("SettleMatcher use:" + this.getClass().getSimpleName());
        this.scheme = param.getScheme();
        this.matchHandlers = new ArrayList<ISettleMatch>(3);
        this.matchHandlers.add(new OrgMatch());
        this.matchHandlers.add(new CurrencyMatch());
        this.matchHandlers.add(new ExtMatch());
        this.addMatchHandlers();
    }

    @Override
    public boolean match(BillSettleVO main, BillSettleVO asst) {
        ISettleMatch matchHandler;
        boolean match = true;
        Iterator<ISettleMatch> iterator = this.matchHandlers.iterator();
        while (iterator.hasNext() && (match = (matchHandler = iterator.next()).match(main, asst, this.scheme))) {
        }
        return match;
    }

    protected abstract void addMatchHandlers();
}

