/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.settle.MatchManager;
import kd.fi.arapcommon.service.settle.match.service.ISettleMatcher;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class EntryRelationSettleRecordBuilder
extends AbstractSettleRecordBuilder {
    @Override
    protected List<SettleRecordVO> doBuild(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        String mainBillEntity = mainList.get(0).getBillEntity();
        Map<Long, Long> botpMap = this.loadEntryRelationMapping(mainBillEntity, asstList);
        this.scheme.setBotpMap(botpMap);
        HashMap<Long, ArrayList<BillSettleVO>> asstSettleVOMap = new HashMap<Long, ArrayList<BillSettleVO>>(asstList.size());
        for (BillSettleVO asstVO : asstList) {
            ArrayList<BillSettleVO> asstBillList;
            long sourceEntryId = asstVO.getEntrySouBillId();
            Long botpSourceEntryId = botpMap.get(asstVO.getEntryId());
            if (botpSourceEntryId != null) {
                sourceEntryId = botpSourceEntryId;
            }
            if ((asstBillList = (ArrayList<BillSettleVO>)asstSettleVOMap.get(sourceEntryId)) == null) {
                asstBillList = new ArrayList<BillSettleVO>(1);
                asstBillList.add(asstVO);
                asstSettleVOMap.put(sourceEntryId, asstBillList);
                continue;
            }
            asstBillList.add(asstVO);
        }
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(64);
        ISettleMatcher matcher = MatchManager.getMatcher(this.scheme);
        ArrayList<BillSettleVO> matchAsstList = new ArrayList<BillSettleVO>(asstList.size());
        for (BillSettleVO main : mainList) {
            matchAsstList.clear();
            long mainEntryId = main.getEntryId();
            List asstBillList = (List)asstSettleVOMap.get(mainEntryId);
            if (asstBillList != null) {
                for (BillSettleVO asst : asstBillList) {
                    if (asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0 || !matcher.match(main, asst)) continue;
                    matchAsstList.add(asst);
                }
            }
            if (matchAsstList.size() <= 0) continue;
            SettleRecordVO result = super.buildSettleRecord(main, matchAsstList);
            resultList.add(result);
        }
        return resultList;
    }

    private Map<Long, Long> loadEntryRelationMapping(String mainBillEntity, List<BillSettleVO> asstList) {
        String asstBill = asstList.get(0).getBillEntity();
        String entryType = asstList.get(0).getEntryEntity();
        HashSet<Long> asstIds = new HashSet<Long>(asstList.size());
        HashSet<Long> asstEntryIds = new HashSet<Long>(asstList.size());
        for (BillSettleVO asst : asstList) {
            asstIds.add(asst.getId());
            asstEntryIds.add(asst.getEntryId());
        }
        return BOTPHelper.loadSourceRowIdsMap(asstBill, entryType, asstIds.toArray(new Long[0]), asstEntryIds.toArray(new Long[0]), mainBillEntity);
    }
}

