/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.settlerecord;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.fi.arapcommon.service.DimensionJoiner;
import kd.fi.arapcommon.service.DimensionValueResolver;
import kd.fi.arapcommon.service.rpascheme.RPASchemeServiceHelper;
import kd.fi.arapcommon.service.settle.MatchManager;
import kd.fi.arapcommon.service.settle.match.service.ISettleMatcher;
import kd.fi.arapcommon.service.settle.settlerecord.AbstractSettleRecordBuilder;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class RPAOrdinalSettleRecordBuilder
extends AbstractSettleRecordBuilder {
    @Override
    protected List<SettleRecordVO> doBuild(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        ArrayList<SettleRecordVO> resultList = new ArrayList<SettleRecordVO>(64);
        ISettleMatcher matcher = MatchManager.getMatcher(this.scheme);
        boolean isAfterMatch = RPASchemeServiceHelper.isAfterMatch();
        logger.info("RPAOrdinalSettleRecordBuilder.doBuild isAfterMatch:" + isAfterMatch);
        if (isAfterMatch) {
            logger.info("RPAOrdinalSettleRecordBuilder.doBuild loadMainEntryIdToDimensionMap start");
            Map<Long, List<String>> mainEntryIdToDimension = this.loadMainEntryIdToDimensionMap();
            logger.info("RPAOrdinalSettleRecordBuilder.doBuild loadMainEntryIdToDimensionMap end");
            logger.info("RPAOrdinalSettleRecordBuilder.doBuild loadAsstDimensionToEntryIds start");
            Map<String, List<Long>> asstDimensionToEntryIds = this.loadAsstDimensionToEntryIds();
            logger.info("RPAOrdinalSettleRecordBuilder.doBuild loadAsstDimensionToEntryIds end");
            ArrayList<BillSettleVO> matchAsstList = new ArrayList<BillSettleVO>(asstList.size());
            for (BillSettleVO main : mainList) {
                matchAsstList.clear();
                long mainEntryId = main.getEntryId();
                List<String> mainDimensions = mainEntryIdToDimension.get(mainEntryId);
                HashSet<Long> asstEntryIds = new HashSet<Long>(8);
                for (String mainDimension : mainDimensions) {
                    List<Long> asstEntryIdsByMainDimension = asstDimensionToEntryIds.get(mainDimension);
                    if (asstEntryIdsByMainDimension == null || asstEntryIdsByMainDimension.size() <= 0) continue;
                    asstEntryIds.addAll(asstEntryIdsByMainDimension);
                }
                for (BillSettleVO asst : asstList) {
                    long asstEntryId = asst.getEntryId();
                    if (!asstEntryIds.contains(asstEntryId) || asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0 || !matcher.match(main, asst)) continue;
                    matchAsstList.add(asst);
                }
                if (matchAsstList.size() <= 0) continue;
                SettleRecordVO result = super.buildSettleRecord(main, matchAsstList);
                resultList.add(result);
            }
        } else {
            ArrayList<BillSettleVO> matchAsstList = new ArrayList<BillSettleVO>(asstList.size());
            for (BillSettleVO main : mainList) {
                matchAsstList.clear();
                for (BillSettleVO asst : asstList) {
                    if (asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0 || !matcher.match(main, asst)) continue;
                    matchAsstList.add(asst);
                }
                if (matchAsstList.size() <= 0) continue;
                SettleRecordVO result = super.buildSettleRecord(main, matchAsstList);
                resultList.add(result);
            }
        }
        return resultList;
    }

    private Map<Long, List<String>> loadMainEntryIdToDimensionMap() {
        List<Map<String, Object>> matchFieldMap = this.scheme.getMatchFieldMap();
        Map<Long, Map<String, Object>> mainFieldValueMap = this.scheme.getMainFieldValueMap();
        HashMap<Long, List<String>> mainEntryIdToDimension = new HashMap<Long, List<String>>(mainFieldValueMap.size());
        for (Map.Entry<Long, Map<String, Object>> mainFieldValue : mainFieldValueMap.entrySet()) {
            Long entryId = mainFieldValue.getKey();
            Map<String, Object> fieldToValue = mainFieldValue.getValue();
            DimensionJoiner dimensionJoiner = new DimensionJoiner();
            for (Map<String, Object> matchEntry : matchFieldMap) {
                DimensionValueResolver.Params params;
                String[] dimensionValues;
                String mainField = (String)matchEntry.get("mainfield");
                String matchRelation = (String)matchEntry.get("matchrelation");
                String splitSign = (String)matchEntry.get("splitsign");
                Object value = fieldToValue.get(mainField);
                if (value == null || (dimensionValues = DimensionValueResolver.loadValues(params = new DimensionValueResolver.Params(matchRelation, splitSign), value)).length <= 0) continue;
                dimensionJoiner.addDimensionValue(dimensionValues);
            }
            mainEntryIdToDimension.put(entryId, dimensionJoiner.join());
        }
        return mainEntryIdToDimension;
    }

    private Map<String, List<Long>> loadAsstDimensionToEntryIds() {
        HashMap<String, List<Long>> dimensionToAsstEntryIds = new HashMap<String, List<Long>>(8);
        List<Map<String, Object>> matchFieldMap = this.scheme.getMatchFieldMap();
        Map<Long, Map<String, Object>> asstFieldValueMap = this.scheme.getAsstFieldValueMap();
        for (Map.Entry<Long, Map<String, Object>> mainFieldValue : asstFieldValueMap.entrySet()) {
            Long entryId = mainFieldValue.getKey();
            Map<String, Object> fieldToValue = mainFieldValue.getValue();
            DimensionJoiner dimensionJoiner = new DimensionJoiner();
            for (Map<String, Object> matchEntry : matchFieldMap) {
                DimensionValueResolver.Params params;
                String[] dimensionValues;
                String asstField = (String)matchEntry.get("asstfield");
                String matchRelation = (String)matchEntry.get("matchrelation");
                String splitSign = (String)matchEntry.get("splitsign");
                Object value = fieldToValue.get(asstField);
                if (value == null || (dimensionValues = DimensionValueResolver.loadValues(params = new DimensionValueResolver.Params(matchRelation, splitSign), value)).length <= 0) continue;
                dimensionJoiner.addDimensionValue(dimensionValues);
            }
            List<String> dimensions = dimensionJoiner.join();
            for (String dimension : dimensions) {
                List entryIds = (List)dimensionToAsstEntryIds.get(dimension);
                if (entryIds != null) {
                    entryIds.add(entryId);
                    continue;
                }
                ArrayList<Long> aEntryIds = new ArrayList<Long>(1);
                aEntryIds.add(entryId);
                dimensionToAsstEntryIds.put(dimension, aEntryIds);
            }
        }
        return dimensionToAsstEntryIds;
    }
}

