/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.PaySettle4ScmcHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.freeze.UnSettleFreezeService;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.FinSettleWriteBacker;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class FinApSettleWriteBacker
extends FinSettleWriteBacker {
    @Override
    protected void afterDoWriteBack(DynamicObject[] wbAfterBills, List<SettleRecordVO> settleRecordVOList) {
        Set billIds = Arrays.stream(wbAfterBills).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] wbBeforeBills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashMap<Long, DynamicObject> wbBeforeBillDetailEntry = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject wbBeforeBill : wbBeforeBills) {
            DynamicObjectCollection entries = wbBeforeBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                wbBeforeBillDetailEntry.put(entry.getLong("id"), entry);
            }
        }
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokeCoreBillExtractScmc start");
        this.invokeCoreBillExtractScmc(wbAfterBills, wbBeforeBillDetailEntry);
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokeCoreBillExtractScmc end");
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokePurAndConBill start");
        Settle4ScmcHelper.newWriteBackPurAndCon(settleRecordVOList, wbAfterBills, this.scheme, wbBeforeBills);
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokePurAndConBill end");
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokeFeeBill start");
        this.invokeFeeBill(wbAfterBills);
        logger.info("FinApSettleWriteBacker.afterDoWriteBack invokeFeeBill end");
        OpLogServiceHelper.addLog(this.scheme.isSettle() ? "settle" : "unsettle", (Object)this.scheme.toString(), wbAfterBills, false);
        this.wbAfterExt(wbAfterBills);
    }

    @Override
    protected void afterSaveBills(DynamicObject[] bills) {
        if (!this.scheme.isSettle()) {
            Set<Long> apBillIds = Arrays.stream(bills).map(v -> v.getLong("id")).collect(Collectors.toSet());
            UnSettleFreezeService service = new UnSettleFreezeService();
            service.freeze(apBillIds, true);
        }
    }

    private void invokeCoreBillExtractScmc(DynamicObject[] wbAfterBills, Map<Long, DynamicObject> wbBeforeBillDetailEntry) {
        String settleRelation = this.scheme.getSettleRelation();
        if (!ObjectUtils.isEmpty((Object)settleRelation) && (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation))) {
            ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(64);
            for (DynamicObject wbAfterBill : wbAfterBills) {
                DynamicObjectCollection wbAfterEntries = wbAfterBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject wbAfterEntry : wbAfterEntries) {
                    BigDecimal wbBeforeSettledAmt;
                    long entryId = wbAfterEntry.getLong("id");
                    DynamicObject wbBeforeEntry = wbBeforeBillDetailEntry.get(entryId);
                    BigDecimal wbAfterSettledAmt = wbAfterEntry.getBigDecimal("settledamt");
                    BigDecimal needWbSettleAmt = wbAfterSettledAmt.subtract(wbBeforeSettledAmt = wbBeforeEntry.getBigDecimal("settledamt"));
                    if (needWbSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    String corebillType = wbAfterEntry.getString("corebilltype");
                    String corebillNo = wbAfterEntry.getString("corebillno");
                    long corebillId = wbAfterEntry.getLong("corebillid");
                    if (corebillId == 0L || ObjectUtils.isEmpty((Object)corebillType) || ObjectUtils.isEmpty((Object)corebillNo)) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mainbilltype", corebillType);
                    row.put("mainbillid", corebillId);
                    row.put("mainbillentryid", wbAfterEntry.getLong("corebillentryid"));
                    row.put("apbillid", wbAfterBill.getLong("id"));
                    row.put("apbillentryid", entryId);
                    row.put("currencyid", wbAfterBill.getDynamicObject("currency").getLong("id"));
                    row.put("orgid", wbAfterBill.getLong("org.id"));
                    row.put("asstactid", wbAfterBill.getLong("asstact.id"));
                    row.put("asstacttype", wbAfterBill.getString("asstacttype"));
                    row.put("paidamount", needWbSettleAmt);
                    paramList.add(row);
                }
            }
            if (!paramList.isEmpty()) {
                PaySettle4ScmcHelper.disposeCoreBillExceptScmc(paramList, this.scheme.isSettle());
            }
        }
    }

    private void invokeFeeBill(DynamicObject[] wbAfterBills) {
        boolean settle = this.scheme.isSettle();
        PaySettle4ScmcHelper.disposeFeeBill(Arrays.stream(wbAfterBills).collect(Collectors.toList()), settle);
    }

    private void wbAfterExt(DynamicObject[] wbAfterBills) {
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("settlescheme", SerializationUtils.toJsonString((Object)this.scheme));
            OperationResult afterSettleResut = OperationServiceHelper.executeOperate((String)"aftersettle", (String)"ap_finapbill", (DynamicObject[])wbAfterBills, (OperateOption)option);
            OperationHelper.assertResult(afterSettleResut);
        }
        catch (Exception e) {
            logger.error("aftersettle Exception:" + e);
        }
    }

    @Override
    protected List<String> getWBSelector() {
        ArrayList<String> selector = new ArrayList<String>(50);
        selector.add("id");
        selector.add("org");
        selector.add("billno");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("settlestatus");
        selector.add("currency");
        selector.add("pricetaxtotal");
        selector.add("pricetaxtotalbase");
        selector.add("settleamount");
        selector.add("settleamountbase");
        selector.add("unsettleamount");
        selector.add("unsettleamountbase");
        selector.add("exchangerate");
        selector.add("premiumamt");
        selector.add("basecurrency");
        selector.add("quotation");
        selector.add("settleversion");
        selector.add("e_pricetaxtotal");
        selector.add("e_pricetaxtotalbase");
        selector.add("settledamt");
        selector.add("settledamtbase");
        selector.add("unsettleamt");
        selector.add("unsettleamtbase");
        selector.add("lockedamt");
        selector.add("unlockamt");
        selector.add("sourcebilltype");
        selector.add("e_sourcebillid");
        selector.add("e_sourcebillentryid");
        selector.add("corebilltype");
        selector.add("corebillno");
        selector.add("corebillid");
        selector.add("corebillentryid");
        selector.add("planpricetax");
        selector.add("planpricetaxloc");
        selector.add("unplansettleamt");
        selector.add("unplansettlelocamt");
        selector.add("plansettledamt");
        selector.add("plansettledlocamt");
        selector.add("planlockedamt");
        selector.add("unplanlockamt");
        selector.add("e_baseunitqty");
        selector.add("quantity");
        selector.add("e_conbillentity");
        selector.add("e_conbillid");
        selector.add("e_conbillentryid");
        selector.add("ispresent");
        selector.add("istanspay");
        selector.add("e_fixlockedamt");
        selector.add("e_fixsettleedamt");
        selector.add("p_sourcebillid");
        selector.add("p_sourcebillentryid");
        selector.add("e_splitdimensionid");
        selector.add("p_splitdimensionid");
        selector.add("e_expensebillids_tag");
        return selector;
    }
}

