/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settle.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.AbstractSettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.FinArSettleWriteBacker;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class FinArAdjustSettleWriteBacker
extends FinArSettleWriteBacker {
    @Override
    protected void doWriteBack(List<SettleRecordVO> settleRecordVOList) {
        if (1 == this.scheme.getSettleEntryParam()) {
            super.doWriteBack(settleRecordVOList);
        } else if (this.isAsMain) {
            logger.info("settle writeback head start");
            this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
                DynamicObject bill = (DynamicObject)this.billMap.get(billId);
                super.wbHead(bill, (AbstractSettleWriteBacker.WBAmtInfo)headWBAmtInfo);
            });
            logger.info("settle writeback head end");
            logger.info("settle writeback mainentry start");
            this.entryIdToSettleRecordMap.forEach((entryId, resultList) -> {
                DynamicObject entry = (DynamicObject)this.billEntryMap.get(entryId);
                super.wbPlanEntryByEntryId(entry, (List<SettleRecordVO>)resultList);
            });
            logger.info("settle writeback mainentry end");
            logger.info("settle writeback asstentry start");
            this.wbDetailEntry(settleRecordVOList);
            logger.info("settle writeback asstentry end");
            logger.info("settle writeback head status start");
            this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
                DynamicObject bill = (DynamicObject)this.billMap.get(billId);
                super.wbHeadSettleStatus(bill);
            });
            logger.info("settle writeback head status end");
        } else {
            super.doWriteBack(settleRecordVOList);
        }
    }

    private void wbDetailEntry(List<SettleRecordVO> settleRecordVOList) {
        HashSet<Long> adjustBillIds = new HashSet<Long>(8);
        HashMap<Long, Long> sourceBillPlanEntryIdMap = new HashMap<Long, Long>(8);
        for (SettleRecordVO vo : settleRecordVOList) {
            long mainBillEntryId = vo.getMainBillEntryId();
            sourceBillPlanEntryIdMap.put(mainBillEntryId, mainBillEntryId);
            List<SettleRecordEntryVO> entrys = vo.getEntrys();
            for (SettleRecordEntryVO entry : entrys) {
                long billId2 = entry.getBillId();
                adjustBillIds.add(billId2);
            }
        }
        DynamicObject[] adjustBills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.getAdjustBillSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", adjustBillIds)});
        HashMap<Long, AbstractSettleWriteBacker.WBAmtInfo> detailDisposeAmtMap = new HashMap<Long, AbstractSettleWriteBacker.WBAmtInfo>(8);
        for (DynamicObject adjustBill : adjustBills) {
            DynamicObjectCollection adjustDetailEntries = adjustBill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject adjustDetailEntry : adjustDetailEntries) {
                long sourceEntryId = adjustDetailEntry.getLong(this.billModel.E_SOURCEBILLENTRYID);
                BigDecimal disposeAmt = adjustDetailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL);
                BigDecimal disposeLocalAmt = adjustDetailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC);
                AbstractSettleWriteBacker.WBAmtInfo wbAmtInfo = (AbstractSettleWriteBacker.WBAmtInfo)detailDisposeAmtMap.get(sourceEntryId);
                if (wbAmtInfo == null) {
                    detailDisposeAmtMap.put(sourceEntryId, new AbstractSettleWriteBacker.WBAmtInfo(disposeAmt, disposeLocalAmt));
                    continue;
                }
                wbAmtInfo.wbAmt = wbAmtInfo.wbAmt.add(disposeAmt);
                wbAmtInfo.wbLocalAmt = wbAmtInfo.wbLocalAmt.add(disposeLocalAmt);
            }
        }
        HashMap<Long, Boolean> dimensionIdIsExit = new HashMap<Long, Boolean>(8);
        for (Map.Entry planEntrySet : this.billEntryMap.entrySet()) {
            Long planEntryId = (Long)planEntrySet.getKey();
            DynamicObject planEntry = (DynamicObject)planEntrySet.getValue();
            Boolean isExist = (Boolean)dimensionIdIsExit.get(planEntry.getLong(this.billModel.P_SPLITDIMENSION_ID));
            if (isExist != null && isExist.booleanValue()) continue;
            if (sourceBillPlanEntryIdMap.get(planEntryId) == null) {
                dimensionIdIsExit.put(planEntry.getLong(this.billModel.P_SPLITDIMENSION_ID), Boolean.FALSE);
                continue;
            }
            dimensionIdIsExit.put(planEntry.getLong(this.billModel.P_SPLITDIMENSION_ID), Boolean.TRUE);
        }
        this.headNeedWBAmtMap.forEach((billId, headWBAmtInfo) -> {
            DynamicObject bill = (DynamicObject)this.billMap.get(billId);
            DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject detailEntry : detailEntries) {
                boolean isUnSettleDisposeAll;
                Boolean isNeedWBByDimensionId;
                long entryId = detailEntry.getLong("id");
                AbstractSettleWriteBacker.WBAmtInfo wbAmtInfo = (AbstractSettleWriteBacker.WBAmtInfo)detailDisposeAmtMap.get(entryId);
                if (wbAmtInfo == null || (isNeedWBByDimensionId = (Boolean)dimensionIdIsExit.get(detailEntry.getLong(this.billModel.E_SPLITDIMENSION_ID))) == null || !isNeedWBByDimensionId.booleanValue()) continue;
                BigDecimal disposeAmt = wbAmtInfo.wbAmt;
                BigDecimal disposeLocalAmt = wbAmtInfo.wbLocalAmt;
                BigDecimal direction = new BigDecimal(detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL).signum());
                disposeAmt = disposeAmt.abs().multiply(direction);
                disposeLocalAmt = disposeLocalAmt.abs().multiply(direction);
                if (!this.scheme.isSettle()) {
                    disposeAmt = disposeAmt.negate();
                    disposeLocalAmt = disposeLocalAmt.negate();
                }
                if (disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                detailEntry.set(this.billModel.E_UNLOCKAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNLOCKAMT).subtract(disposeAmt));
                detailEntry.set(this.billModel.E_LOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_LOCKEDAMT).add(disposeAmt));
                detailEntry.set(this.billModel.E_FIXLOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_FIXLOCKEDAMT).add(disposeAmt));
                detailEntry.set(this.billModel.E_UNSETTLEAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).subtract(disposeAmt));
                detailEntry.set(this.billModel.E_SETTLEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).add(disposeAmt));
                detailEntry.set(this.billModel.E_FIXSETTLEEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_FIXSETTLEEDAMT).add(disposeAmt));
                boolean isSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_UNSETTLEAMT).compareTo(BigDecimal.ZERO) == 0;
                boolean bl = isUnSettleDisposeAll = detailEntry.getBigDecimal(this.billModel.E_SETTLEDAMT).compareTo(BigDecimal.ZERO) == 0;
                if (isSettleDisposeAll) {
                    detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
                    detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)BigDecimal.ZERO);
                    continue;
                }
                if (isUnSettleDisposeAll) {
                    detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)BigDecimal.ZERO);
                    detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC));
                    continue;
                }
                detailEntry.set(this.billModel.E_SETTLEDLOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_SETTLEDLOCALAMT).add(disposeLocalAmt));
                detailEntry.set(this.billModel.E_UNSETTLELOCALAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNSETTLELOCALAMT).subtract(disposeLocalAmt));
            }
        });
    }

    private List<String> getAdjustBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(12);
        selector.add("id");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        selector.add("entry.e_srcid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_splitdimensionid");
        return selector;
    }
}

