/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import kd.fi.arapcommon.service.settleconsole.FinApBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.FinApRedBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.FinArBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.FinArRedBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.LossBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.PayBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.PayFundBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.RecBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.RecFundBillDataProvider;

public enum BillDataProviderEnum {
    FINAPBILL("ap_finapbill", FinApBillDataProvider.class, FinApRedBillDataProvider.class),
    FINARBILL("ar_finarbill", FinArBillDataProvider.class, FinArRedBillDataProvider.class),
    CAS_PAYBILL("cas_paybill", PayBillDataProvider.class, PayFundBillDataProvider.class),
    CAS_RECBILL("cas_recbill", RecBillDataProvider.class, RecFundBillDataProvider.class),
    AR_BADDEBTLOSSBILL("ar_baddebtlossbill", LossBillDataProvider.class, null);

    private String key;
    private Class<?> className;
    private Class<?> classNameRed;

    private BillDataProviderEnum(String key, Class<?> className, Class<?> classNameRed) {
        this.key = key;
        this.className = className;
        this.classNameRed = classNameRed;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getClassName() {
        return this.className;
    }

    public Class<?> getClassNameRed() {
        return this.classNameRed;
    }

    public static Class<?> getValue(String key, boolean isRed) {
        BillDataProviderEnum[] values;
        for (BillDataProviderEnum value : values = BillDataProviderEnum.values()) {
            if (!value.getKey().equals(key)) continue;
            if (isRed) {
                return value.getClassNameRed();
            }
            return value.getClassName();
        }
        return null;
    }
}

