/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.settleconsole.AbstractBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;

public class FinArBillDataProvider
extends AbstractBillDataProvider {
    public FinArBillDataProvider(BillDataProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("billtype.number billtype");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (this.param.isTotalDisplay()) {
            selector.add("recamount pricetaxtotal");
            selector.add("0 e_pricetaxtotal");
            if (this.param.getSettleEntry() == 1) {
                selector.add("entry.id entryid");
                selector.add("entry.e_unsettleamt unsettleamt");
                selector.add("entry.e_unlockamt enableamt");
                selector.add("entry.e_unlockamt cursettleamt");
            } else {
                selector.add("planentity.id as entryid");
                selector.add("planentity.unplansettleamt as unsettleamt");
                selector.add("planentity.unplanlockamt as enableamt");
                selector.add("planentity.unplanlockamt as cursettleamt");
            }
        } else if (this.param.getSettleEntry() == 1) {
            selector.add("0 pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_recamount e_pricetaxtotal");
            selector.add("entry.e_unsettleamt unsettleamt");
            selector.add("entry.e_unlockamt enableamt");
            selector.add("entry.e_unlockamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        } else if (this.param.getSettleEntry() == 2) {
            selector.add("0 pricetaxtotal");
            selector.add("planentity.id as entryid");
            selector.add("planentity.planduedate as planduedate");
            selector.add("planentity.planpricetax as e_pricetaxtotal");
            selector.add("planentity.unplansettleamt as unsettleamt");
            selector.add("planentity.unplanlockamt as enableamt");
            selector.add("planentity.unplanlockamt as cursettleamt");
            selector.add("planentity.plancorebillno as corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter() {
        QFilter filter = new QFilter("org", "=", this.param.getOrgPk());
        if (this.param.getGridFilter() != null) {
            filter.and(this.param.getGridFilter());
        }
        if (SettleRelationEnum.RECSETTLE.getValue().equals(this.param.getSettleRelation()) && this.param.isSubmitSettle()) {
            filter.and("billstatus", "in", (Object)new String[]{"B", "C"});
        } else {
            filter.and("billstatus", "=", (Object)"C");
        }
        String sign = "<>";
        if (SettleRelationEnum.ARSELF.getValue().equals(this.param.getSettleRelation())) {
            sign = this.param.isMain() ? ">" : "<";
        }
        if (this.param.isTotalDisplay() || !SettleRelationEnum.ARSELF.getValue().equals(this.param.getSettleRelation())) {
            filter.and("unsettleamount", sign, (Object)0);
        }
        if (this.param.getSettleEntry() == 1) {
            filter.and("entry.e_unlockamt", sign, (Object)0);
        } else if (this.param.getSettleEntry() == 2) {
            filter.and("planentity.unplanlockamt", sign, (Object)0);
        }
        filter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
        if (this.param.isMain()) {
            filter.and("asstacttype", "=", (Object)this.param.getAsstactype());
        }
        if (!StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
            if (this.param.isMain()) {
                filter.and("asstact", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
            } else if ("asstandcur".equals(this.param.getMatchCondition())) {
                if ("aparsettle".equals(this.param.getSettleRelation())) {
                    List<Long> asstactIdList = this.getAsstactIds(this.param.getAsstactype(), this.param.getAsstactId());
                    filter.and("asstact", "in", asstactIdList);
                } else {
                    filter.and("asstact", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
                }
            }
        } else if (!ObjectUtils.isEmpty(this.param.getMainAsstactIdSet()) && this.param.isMain()) {
            Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("masterid", "in", this.param.getMainAsstactIdSet())});
            filter.and("asstact", "in", asstactMap.keySet());
        }
        return filter;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"FinArBillDataProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public String getEntityNumber() {
        return "ar_finarbill";
    }

    @Override
    public List<String> getTreeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("asstacttype");
        selector.add("asstact");
        if (!this.param.isTotalDisplay()) {
            if (this.param.getSettleEntry() == 1) {
                selector.add("entry.seq");
            } else {
                selector.add("planentity.seq");
            }
        }
        return selector;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        return fc;
    }

    @Override
    protected String getAsstactKey() {
        return "asstact";
    }
}

