/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.settleconsole.AbstractBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;

public class LossBillDataProvider
extends AbstractBillDataProvider {
    public LossBillDataProvider(BillDataProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("null paymenttype");
        selector.add("billtype.number billtype");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (this.param.isTotalDisplay()) {
            selector.add("recamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettleamt unsettleamt");
            selector.add("entry.e_unsettleamt enableamt");
            selector.add("entry.e_unsettleamt cursettleamt");
        } else if (1 == this.param.getSettleEntry()) {
            selector.add("0 pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_baddebtamt e_pricetaxtotal");
            selector.add("entry.e_unsettleamt unsettleamt");
            selector.add("entry.e_unsettleamt enableamt");
            selector.add("entry.e_unsettleamt cursettleamt");
        } else if (2 == this.param.getSettleEntry()) {
            selector.add("0 pricetaxtotal");
            selector.add("planentry.id as entryid");
            selector.add("planentry.p_baddebtamt as e_pricetaxtotal");
            selector.add("planentry.p_duedate as planduedate");
            selector.add("planentry.p_unsettleamt as unsettleamt");
            selector.add("planentry.p_unsettleamt as enableamt");
            selector.add("planentry.p_unsettleamt as cursettleamt");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter() {
        QFilter filter = new QFilter("org", "=", this.param.getOrgPk());
        if (this.param.getGridFilter() != null) {
            filter.and(this.param.getGridFilter());
        }
        filter.and("asstacttype", "=", (Object)this.param.getAsstactype());
        if (!StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
            filter.and("asstact", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
        } else if (!ObjectUtils.isEmpty(this.param.getMainAsstactIdSet()) && this.param.isMain()) {
            Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("masterid", "in", this.param.getMainAsstactIdSet())});
            filter.and("asstact", "in", asstactMap.keySet());
        }
        filter.and("billstatus", "=", (Object)"C");
        filter.and("unsettleamt", "<>", (Object)0);
        return filter;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        FilterCondition fc = new FilterCondition();
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>();
        SimpleFilterRow bizDateRow = new SimpleFilterRow();
        bizDateRow.setCompareType("63");
        bizDateRow.setFieldName("bizdate");
        bizDateRow.setLogic("0");
        ArrayList<FilterValue> dateValues = new ArrayList<FilterValue>();
        FilterValue dateValue = new FilterValue();
        dateValue.setValue((Object)"");
        dateValues.add(dateValue);
        bizDateRow.setValue(dateValues);
        rows.add(bizDateRow);
        fc.setFilterRow(rows);
        return fc;
    }

    @Override
    public List<String> getTreeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("asstacttype");
        selector.add("asstact");
        if (!this.param.isTotalDisplay()) {
            if (this.param.getSettleEntry() == 1) {
                selector.add("entry.seq");
            } else {
                selector.add("planentry.seq");
            }
        }
        return selector;
    }

    @Override
    public LocaleString getAmtColumnName() {
        return new LocaleString(ResManager.loadKDString((String)"\u574f\u8d26\u91d1\u989d", (String)"LossBillDataProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    protected String getAsstactKey() {
        return "asstact";
    }

    @Override
    public String getEntityNumber() {
        return "ar_baddebtlossbill";
    }
}

