/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.ext.SettleExtDataFilterKeyVO;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.settleconsole.AbstractBillDataProvider;
import kd.fi.arapcommon.service.settleconsole.BillDataProviderParam;

public class PaidBillDataProvider
extends AbstractBillDataProvider {
    public PaidBillDataProvider(BillDataProviderParam param) {
        super(param);
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("paymenttype");
        selector.add("'" + this.getEntityNumber() + "' billtype");
        selector.add("payeetype asstacttype");
        selector.add("payee asstact");
        selector.add("payeetype asstacttypeenum");
        selector.add("payee.name asstactname");
        selector.add("currency");
        selector.add("quotation");
        selector.add("exchangerate");
        if (this.param.isTotalDisplay()) {
            selector.add("entry.e_actamt pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("0 e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
        } else {
            selector.add("0 pricetaxtotal");
            selector.add("entry.id entryid");
            selector.add("entry.e_material material");
            selector.add("entry.e_expenseitem expenseitem");
            selector.add("entry.e_actamt e_pricetaxtotal");
            selector.add("entry.e_unsettledamt unsettleamt");
            selector.add("entry.e_unsettledamt enableamt");
            selector.add("entry.e_unsettledamt cursettleamt");
            selector.add("entry.e_corebillno corebillno");
        }
        return selector;
    }

    @Override
    public QFilter getQueryFilter() {
        QFilter filter = new QFilter("org", "=", this.param.getOrgPk());
        if (this.param.getGridFilter() != null) {
            filter.and(this.param.getGridFilter());
        }
        if (this.param.isMain()) {
            filter.and("payeetype", "=", (Object)this.param.getAsstactype());
            if (!StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
                filter.and("payee", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
            } else if (!ObjectUtils.isEmpty(this.param.getMainAsstactIdSet())) {
                Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)this.param.getAsstactype(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("masterid", "in", this.param.getMainAsstactIdSet())});
                filter.and("payee", "in", asstactMap.keySet());
            }
        } else if ("asstandcur".equals(this.param.getMatchCondition()) && !StringUtils.isEmpty((CharSequence)this.param.getAsstactId())) {
            filter.and("payee", "in", BaseDataHelper.getBaseDataIds(this.param.getAsstactype(), Long.parseLong(this.param.getAsstactId())));
        }
        this.replaceFilterProp("description", "usage", filter);
        this.replaceFilterProp("itempayeetype", "payeetype", filter);
        this.replaceFilterProp("itempayee", "payee", filter);
        this.replaceFilterPropForMulti("itempayee", "payee", filter);
        this.replaceFilterProp("entry.e_unlockamt", "entry.e_unsettledamt", filter);
        this.replaceFilterProp("entry.e_settleorg", "org", filter);
        List<SettleExtDataFilterKeyVO> vos = SettleExtDataLoader.loadManualSettleFilterInfo("cas_paybill");
        for (SettleExtDataFilterKeyVO vo : vos) {
            String matchFieldKey = vo.getMatchFieldKey();
            if (!StringUtils.isNotEmpty((CharSequence)matchFieldKey)) continue;
            String filedKey = vo.getFiledKey().split("\\.")[0];
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"cas_paybill").getProperty(filedKey);
            filedKey = vo.getFiledKey();
            if (property == null) {
                filedKey = "entry." + filedKey;
            }
            this.replaceFilterProp(filedKey, matchFieldKey, filter);
        }
        String sign = "<>";
        if (SettleRelationEnum.PAYSELF.getValue().equals(this.param.getSettleRelation())) {
            sign = this.param.isMain() ? ">" : "<";
        }
        if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(this.param.getSettleRelation())) {
            sign = ">";
        }
        filter.and("billstatus", "=", (Object)"C").and("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE).and("entry.e_unsettledamt", sign, (Object)0);
        return filter;
    }

    @Override
    public String getEntityNumber() {
        return "ap_paidbill";
    }

    @Override
    public List<String> getTreeSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("payeetype");
        selector.add("payee");
        if (!this.param.isTotalDisplay()) {
            selector.add("entry.seq");
        }
        return selector;
    }

    @Override
    public FilterCondition getDefaultFilter() {
        return null;
    }

    @Override
    protected String getAsstactKey() {
        return "payee";
    }
}

