/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.settleconsole;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.helper.ArApLicenseServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.settleconsole.SettleConsoleLeftTreeHandler;
import kd.fi.arapcommon.service.settleconsole.SettleConsoleRightHandler;

public abstract class SettleConsoleBasePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TabSelectListener {
    private SettleConsoleLeftTreeHandler leftHandler;
    private SettleConsoleRightHandler rightHandler;

    public void initialize() {
        Tab tab;
        Search search;
        super.initialize();
        OrgEdit orgCtrl = (OrgEdit)this.getControl("settleorg");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> orgIdList = this.getOrgIdList();
            QFilter qFilter = new QFilter("id", "in", orgIdList);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(qFilter);
            showParameter.getListFilterParameter().getQFilters().addAll(filters);
        });
        TreeView treeView = (TreeView)this.getControl("treeview");
        if (treeView != null) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((search = (Search)this.getControl("search")) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((tab = (Tab)this.getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        Button btn = (Button)this.getControl("settle");
        btn.addClickListener((ClickListener)this);
        this.getRightHandler().addListeners();
        Label label = (Label)this.getControl("query");
        label.addClickListener((ClickListener)this);
        Button btn_check = (Button)this.getControl("checkverifybill");
        btn_check.addClickListener((ClickListener)this);
        Button btn_findbill = (Button)this.getControl("findbill");
        btn_findbill.addClickListener((ClickListener)this);
        Button btn_viewCurrent = (Button)this.getControl("viewcurrent");
        btn_viewCurrent.addClickListener((ClickListener)this);
        Button btn_viewHistory = (Button)this.getControl("viewhistory");
        btn_viewHistory.addClickListener((ClickListener)this);
        Button btn_refresh = (Button)this.getControl("refresh");
        btn_refresh.addClickListener((ClickListener)this);
        Button btn_clearing = (Button)this.getControl("clearing");
        btn_clearing.addClickListener((ClickListener)this);
        Button btn_resettle = (Button)this.getControl("resettle");
        btn_resettle.addClickListener((ClickListener)this);
        EntryGrid apGrid = (EntryGrid)this.getControl("mainbill");
        EntryGrid payGrid = (EntryGrid)this.getControl("asstbill");
        apGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                if (!"billno".equals(evt.getFieldName())) {
                    return;
                }
                SettleConsoleBasePlugin.this.billHyperClick(evt.getFieldName(), evt.getRowIndex());
            }
        });
        payGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                if (!"asst_billno".equals(evt.getFieldName())) {
                    return;
                }
                SettleConsoleBasePlugin.this.billHyperClick(evt.getFieldName(), evt.getRowIndex());
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId)) {
            String formId = e.getFormShowParameter().getFormId();
            String entityName = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
            String mainAppId = this.isAr() ? "/BBRH+122=39" : "+HKZHSKFXOX";
            LicenseCheckResult checkResult = ArApLicenseServiceHelper.check(mainAppId, entityName);
            if (!checkResult.getHasLicense().booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(checkResult.getMsg());
                e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
            }
        }
    }

    private void billHyperClick(String operationKey, int index) {
        String entryEntity = "billno".equals(operationKey) ? "mainbill" : "asstbill";
        String formId = "billno".equals(operationKey) ? "mainEntity" : "asstEntity";
        String idEntity = "billno".equals(operationKey) ? "id" : "asst_id";
        String billtype = "billno".equals(operationKey) ? "billtype" : "asst_billtype";
        BillShowParameter param = new BillShowParameter();
        param.setPkId(((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).get(idEntity));
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String billTypeEntity = ((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).getString(billtype);
        if ("ap_paidbill".equals(billTypeEntity) || "ar_receivedbill".equals(billTypeEntity)) {
            param.setFormId(((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(index)).getString(billtype));
        } else {
            param.setFormId(this.getPageCache().get(formId));
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setOrgValue();
        if (!this.validateOrgIsInitNull()) {
            this.setStandardCurrenyValue();
            this.setPageCacheAndButton();
            this.loadView();
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"clearing"});
    }

    private boolean validateOrgIsInitNull() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        return org == null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShortCuts();
        this.lockSettleDate();
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+alt+r");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts")) {
            String key;
            switch (key = e.getEventArgs()) {
                case "[17,18,82]": {
                    long userId = RequestContext.get().getCurrUserId();
                    String cacheKey = this.isAr() ? "ar_manualSettleNextHide" : "ap_manualSettleNextHide";
                    boolean manualSettleNextHideRes = UserConfigServiceHelper.setSetting((long)userId, (String)cacheKey, (String)"0");
                    if (manualSettleNextHideRes) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u64cd\u4f5c\u786e\u8ba4\u201d\u6062\u590d\u6210\u529f\u3002", (String)"SettleConsoleBasePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u64cd\u4f5c\u786e\u8ba4\u201d\u6062\u590d\u5931\u8d25\u3002", (String)"SettleConsoleBasePlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            }
        }
    }

    protected boolean isAr() {
        return "ar_init".equals(this.getInitEntityName());
    }

    public void click(EventObject evt) {
        String key;
        if (this.validateOrgIsInitNull()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleConsoleBasePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "settle": {
                boolean settle = this.getRightHandler().settle();
                if (!settle) break;
                this.refreshView();
                break;
            }
            case "clearing": {
                boolean clearing = this.getRightHandler().clearing();
                if (!clearing) break;
                this.refreshView();
                break;
            }
            case "query": {
                this.getRightHandler().query();
                break;
            }
            case "checkverifybill": {
                this.getRightHandler().billCheck();
                break;
            }
            case "findbill": {
                this.getRightHandler().billCheck();
                break;
            }
            case "refresh": {
                this.refreshView();
                break;
            }
            case "viewcurrent": {
                ListShowParameter listShowParameter = CommonSettleServiceHelper.getViewCurrentSettleRecordParam(this.getSettleRecordEntity(), this.getPageCache().get("org"), this.getPageCache().get("settleseq"));
                if (listShowParameter != null) {
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u672a\u751f\u6210\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"SettleConsoleBasePlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                break;
            }
            case "viewhistory": {
                ListShowParameter listShowParameter = CommonSettleServiceHelper.getViewHistorySettleRecordParam(this.getSettleRecordEntity(), this.getPageCache().get("org"));
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "resettle": {
                this.openReSettlePage();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (name) {
            case "settleorg": {
                this.validateOrg(oldValue, newValue);
                this.setStandardCurrenyValue();
                this.setPageCacheAndButton();
                this.lockSettleDate();
                this.refreshView();
                break;
            }
            case "pagedisplay": 
            case "matchcondition": 
            case "issettlable": {
                this.refreshView();
                break;
            }
            case "asstactype": {
                this.validateAsstactType(oldValue, newValue);
                this.refreshView();
                break;
            }
            default: {
                this.getRightHandler().propertyChanged(e);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put("node", nodeId);
        this.getRightHandler().setCountValue();
        this.getRightHandler().resetFilter();
        this.getRightHandler().fillGridValue();
        this.refreshClearingTab();
        this.setButtonVisible();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getRightHandler().closedCallBack(closedCallBackEvent);
    }

    public void search(SearchEnterEvent evt) {
        if (!this.validateOrgIsInitNull()) {
            this.getLeftTreeHandler().search(evt);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.refreshView();
    }

    private SettleConsoleLeftTreeHandler getLeftTreeHandler() {
        if (this.leftHandler == null) {
            this.leftHandler = new SettleConsoleLeftTreeHandler(this.getView(), this, this.getEntityName(), this.getInitEntityName());
        }
        return this.leftHandler;
    }

    private SettleConsoleRightHandler getRightHandler() {
        if (this.rightHandler == null) {
            this.rightHandler = new SettleConsoleRightHandler(this.getView(), this, this.getEntityName(), this.getInitEntityName());
        }
        return this.rightHandler;
    }

    private void loadView() {
        this.refreshView();
    }

    private void refreshView() {
        if (!this.validateOrgIsInitNull()) {
            this.cacheSettleRelation();
            this.getLeftTreeHandler().loadTreeView();
            this.refreshClearingTab();
        }
    }

    private void refreshClearingTab() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("recclearing".equals(currentTab) || "payclearing".equals(currentTab)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adv_asstbill", "settle"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"clearing"});
            int entryRowCount = this.getModel().getEntryRowCount("mainbill");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"cursettleamt", "cursettlelocamt"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"adv_asstbill", "settle"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"clearing"});
        }
    }

    private void cacheSettleRelation() {
        this.getRightHandler().cacheEntityNum();
    }

    private void setOrgValue() {
        List<Long> orgIdList = this.getOrgIdList();
        if (orgIdList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIdList.contains(orgId)) {
                orgId = orgIdList.get(0);
            }
            this.getModel().setValue("settleorg", (Object)orgId);
        }
    }

    private void validateOrg(Object oldValue, Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("settleorg", oldValue);
        }
    }

    private void validateAsstactType(Object oldValue, Object newValue) {
        if (StringUtils.isEmpty((String)((String)newValue))) {
            this.getModel().setValue("asstactype", oldValue);
        }
    }

    private void setStandardCurrenyValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        InitHelper init = new InitHelper(org.getLong("id"), this.getInitEntityName());
        this.getModel().setValue("standardcurrency", (Object)init.getStandardCurrency());
    }

    private void setPageCacheAndButton() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewcurrent"});
        DynamicObject org = (DynamicObject)this.getModel().getValue("settleorg");
        this.getPageCache().put("org", org.getPkValue().toString());
    }

    private List<Long> getOrgIdList() {
        List<Long> orgIds = OrgHelper.getAuthorizedBankOrgIds("ap_init".equals(this.getInitEntityName()) ? "ap" : "ar", this.getView().getEntityId(), "47150e89000000ac");
        if (orgIds.size() > 0) {
            DynamicObjectCollection initOrgs = QueryServiceHelper.query((String)this.getInitEntityName(), (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE), new QFilter("org", "in", orgIds)});
            orgIds.clear();
            for (DynamicObject org : initOrgs) {
                orgIds.add(org.getLong("org"));
            }
        }
        return orgIds;
    }

    public void lockSettleDate() {
        IDataModel m = this.getModel();
        InitHelper init = null;
        DynamicObject org = (DynamicObject)m.getValue("settleorg");
        if (org != null) {
            init = this.isAr() ? new InitHelper(org.getLong("id"), "ar_init") : new InitHelper(org.getLong("id"), "ap_init");
            Date currentDate = init.getCurrentDate();
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                currentDate = init.getStartDate();
            }
            DateTimeEdit settledate = (DateTimeEdit)this.getControl("settledate");
            settledate.setMinDate(currentDate);
        }
    }

    protected abstract String getEntityName();

    protected abstract String getInitEntityName();

    protected abstract String getSettleRecordEntity();

    private void setButtonVisible() {
        Container amountPanel = (Container)this.getControl("flexpanelap4");
        amountPanel.setCollapse(true);
        Container filterPanel = (Container)this.getControl("fieldsetpanelap");
        filterPanel.setCollapse(true);
    }

    public void openReSettlePage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("ap_resettle");
        this.getView().showForm(parameter);
    }
}

