/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.upgrade;

import java.util.HashMap;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.vo.BatchUpdateParam;

public abstract class AbstractUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        BatchUpdateParam pluginParamVO = this.getPluginParamVO();
        if (!ObjectUtils.isEmpty((Object)pluginParamVO) && pluginParamVO.isExecuteAfterSql()) {
            return this.execute();
        }
        return null;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        BatchUpdateParam pluginParamVO = this.getPluginParamVO();
        if (!ObjectUtils.isEmpty((Object)pluginParamVO) && !pluginParamVO.isExecuteAfterSql()) {
            return this.execute();
        }
        return null;
    }

    private UpgradeResult execute() {
        boolean notInit;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        String info = "ArApBaseUpgradePlugin Upgrade SUCCESS!";
        boolean success = true;
        BatchUpdateParam paramVO = this.getPluginParamVO();
        boolean bl = notInit = paramVO.getBizObj().startsWith("ap") ? ArApHelper.queryApIsNotInit() : ArApHelper.queryArIsNotInit();
        if (!notInit) {
            try (TXHandle tx = TX.required((String)"beginUpgradeTask");){
                try {
                    paramVO.setUpgradePlugin(true);
                    UpgradeConfigHelper.batchExecute(paramVO);
                }
                catch (Exception exc) {
                    tx.markRollback();
                    info = ArApHelper.getStackTraceMessage(exc);
                }
            }
        }
        resultMap.put("success", success);
        resultMap.put("log", info);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return new UpgradeResult(resultMap);
    }

    protected abstract BatchUpdateParam getPluginParamVO();
}

