/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.vchconsist;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.vchconsist.VoucherMutexHelper;

public class BizFinIntCoorTableManager {
    private static final Log logger = LogFactory.getLog(BizFinIntCoorTableManager.class);

    public DataSet getInvCoorTableDs(Long lastScanInvTableTime, long now) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FID,FREQUESTID,FCREATETIME,FEFFECTIVETIME,FDIMLOCK,FBILLID,FENTITYNUM from T_AP_TASKCOLLABORATE ", new Object[0]);
        sql.append(" where ", new Object[0]);
        sql.append(" FCREATETIME > ? ", new Object[]{new Timestamp(lastScanInvTableTime)});
        sql.append(" and FCREATETIME <= ? ", new Object[]{new Timestamp(now)});
        SqlBuilder effectSql = new SqlBuilder();
        effectSql.appendSqlBuilder(sql);
        effectSql.append(" and FEFFECTIVETIME >= ? ", new Object[]{now});
        DataSet effectInvCoorDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("fi"), (SqlBuilder)effectSql);
        SqlBuilder zeroEffectSql = new SqlBuilder();
        zeroEffectSql.appendSqlBuilder(sql);
        zeroEffectSql.append(" and FEFFECTIVETIME <= 0 ", new Object[0]);
        DataSet zeroEffectInvCoorDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("fi"), (SqlBuilder)zeroEffectSql);
        effectInvCoorDs = effectInvCoorDs.union(zeroEffectInvCoorDs);
        return effectInvCoorDs;
    }

    public void doDelInvCoorTable(String reqId, Set<Long> reqBillIds) {
        if (reqBillIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from T_AP_TASKCOLLABORATE where FREQUESTID = ? and ", new Object[]{reqId});
        sql.appendIn("FBILLID", reqBillIds.toArray());
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)this.getDBRoute(), (SqlBuilder)sql);
        }
    }

    public Map<String, Set<Long>> getInvTimeoutReqIdBillsMap() {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FID,FREQUESTID,FCREATETIME,FEFFECTIVETIME,FDIMLOCK,FBILLID,FENTITYNUM from T_AP_TASKCOLLABORATE ", new Object[0]);
        sql.append(" where ", new Object[0]);
        sql.append(" FEFFECTIVETIME < ? ", new Object[]{TimeServiceHelper.now().getTime()});
        DataSet invCoorDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.getDBRoute(), (SqlBuilder)sql);
        HashMap<String, Set<Long>> reqIdBillIdsMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> zeroEffEntityBillIdsMap = new HashMap<String, Set<Long>>(16);
        for (Row row : invCoorDs) {
            String reqId = row.getString("FREQUESTID");
            Long effectiveTime = row.getLong("FEFFECTIVETIME");
            Set billIds = reqIdBillIdsMap.computeIfAbsent(reqId, k -> new HashSet(16));
            Long billId = row.getLong("FBILLID");
            billIds.add(billId);
            if (effectiveTime > 0L) continue;
            Set zeroEffEntBillIds = zeroEffEntityBillIdsMap.computeIfAbsent(row.getString("FENTITYNUM"), k -> new HashSet(16));
            zeroEffEntBillIds.add(billId);
        }
        this.removeBizMutex(reqIdBillIdsMap, zeroEffEntityBillIdsMap);
        return reqIdBillIdsMap;
    }

    private void removeBizMutex(Map<String, Set<Long>> reqIdBillIdsMap, Map<String, Set<Long>> zeroEffEntityBillIdsMap) {
        HashSet<Long> muBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, Set<Long>> entry : zeroEffEntityBillIdsMap.entrySet()) {
            Set<Long> errorSet;
            String entity = entry.getKey();
            Set<Long> billIds = entry.getValue();
            HashMap<Long, Set<ExtendedDataEntity>> entityMap = new HashMap<Long, Set<ExtendedDataEntity>>(16);
            ArrayList<Map<String, Object>> releaseParamList = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Object>> generateRequireList = new ArrayList<Map<String, Object>>(16);
            for (Long billId : billIds) {
                HashMap<String, String> generateRequireParam = new HashMap<String, String>(16);
                generateRequireParam.put("dataObjId", billId.toString());
                generateRequireParam.put("groupId", "default_netctrl");
                generateRequireParam.put("entityKey", entity);
                generateRequireParam.put("operationKey", "audit");
                generateRequireParam.put("isStrict", (String)((Object)Boolean.TRUE));
                generateRequireParam.put("isOpenIntentLocks", (String)((Object)Boolean.FALSE));
                generateRequireList.add((Map<String, Object>)generateRequireParam);
                HashMap<String, String> releaseParam = new HashMap<String, String>(16);
                releaseParam.put("dataObjId", billId.toString());
                releaseParam.put("groupId", "default_netctrl");
                releaseParam.put("entityKey", entity);
                releaseParam.put("operationKey", "audit");
                releaseParamList.add(releaseParam);
                DynamicObject bizObj = BusinessDataServiceHelper.newDynamicObject((String)entity);
                bizObj.set("id", (Object)billId);
                ExtendedDataEntity dataEntity = new ExtendedDataEntity(bizObj, 0, 0);
                HashSet<ExtendedDataEntity> entities = new HashSet<ExtendedDataEntity>(16);
                entities.add(dataEntity);
                entityMap.put(billId, entities);
            }
            Map<String, Set<Long>> resultMap = VoucherMutexHelper.batchRequireVoucherMutex(generateRequireList, entityMap);
            VoucherMutexHelper.batchReleaseVoucherMutex(releaseParamList);
            if (resultMap != null && (errorSet = resultMap.get("error")) != null && errorSet.size() > 0) {
                for (Long billId : errorSet) {
                    muBillIds.add(billId);
                }
            }
            HashSet<Long> newBillIds = new HashSet<Long>(billIds);
            newBillIds.removeAll(muBillIds);
            Set<Long> auditBillIds = this.getAuditBizBillDs(entity, newBillIds);
            muBillIds.addAll(auditBillIds);
        }
        for (Map.Entry<String, Set<Long>> entry : reqIdBillIdsMap.entrySet()) {
            entry.getValue().removeAll(muBillIds);
        }
        logger.info("\u83b7\u53d6\u4e0d\u5230\u7f51\u7edc\u4e92\u65a5id\uff1a" + muBillIds);
    }

    private Set<Long> getAuditBizBillDs(String entity, Set<Long> newBillIds) {
        HashSet<Long> auditBillIds = new HashSet<Long>(16);
        if (newBillIds.isEmpty()) {
            return auditBillIds;
        }
        QFilter billIdsFilter = new QFilter("id", "in", newBillIds);
        billIdsFilter.and("billstatus", "=", (Object)"C");
        DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)"id", (QFilter[])billIdsFilter.toArray(), null);
        for (Row row : billDs) {
            auditBillIds.add(row.getLong("id"));
        }
        logger.info("\u83b7\u53d6\u5230\u7f51\u7edc\u4e92\u65a5\u4f46\u5e93\u5b58\u5355\u636e\u4e3a\u5ba1\u6838\u72b6\u6001\u5355\u636e\uff1a" + auditBillIds);
        return auditBillIds;
    }

    private DBRoute getDBRoute() {
        return DBRouteConst.AP;
    }
}

