/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.vchconsist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.service.vchconsist.BizFinIntCoorTableManager;
import kd.fi.arapcommon.util.CommonUtils;

public class BizFinIntHelper {
    private static final Log logger = LogFactory.getLog(BizFinIntHelper.class);

    public void doReverseByReqId(String reqId, Set<Long> reqBillIds) {
        DynamicObjectCollection dapDycs = this.getHasVouBillIds(reqBillIds);
        HashMap<String, Set<Long>> bizObjMap = new HashMap<String, Set<Long>>(16);
        HashSet<Long> vouIds = new HashSet<Long>(16);
        for (DynamicObject dapDyc : dapDycs) {
            Long billId = dapDyc.getLong("sourcebillid");
            vouIds.add(dapDyc.getLong("voucherid"));
            Set billIds = bizObjMap.computeIfAbsent(dapDyc.getString("billtype"), k -> new HashSet(16));
            billIds.add(billId);
        }
        boolean isDelVouchSucess = this.doDelVouch(bizObjMap, vouIds);
        if (!isDelVouchSucess) {
            return;
        }
        new BizFinIntCoorTableManager().doDelInvCoorTable(reqId, reqBillIds);
    }

    private boolean doDelVouch(Map<String, Set<Long>> bizObjMap, Set<Long> vouIds) {
        OperateOption option;
        if (bizObjMap.isEmpty()) {
            return true;
        }
        try {
            option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            option.setVariableValue("skipCheckSpecialDataPermission", "true");
            String glVoucherEntity = "gl_voucher";
            OperationResult result = OperationServiceHelper.executeOperate((String)"antipost", (String)glVoucherEntity, (Object[])vouIds.toArray(new Object[0]), (OperateOption)option);
            String atipostOpMsg = CommonUtils.getOpErrorMsg(result);
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5c1d\u8bd5\u53cd\u8fc7\u8d26\u51ed\u8bc1\uff1a" + atipostOpMsg);
            result = OperationServiceHelper.executeOperate((String)"unaudit", (String)glVoucherEntity, (Object[])vouIds.toArray(new Object[0]), (OperateOption)option);
            String unauditOpMsg = CommonUtils.getOpErrorMsg(result);
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5c1d\u8bd5\u53cd\u5ba1\u6838\u51ed\u8bc1\uff1a" + unauditOpMsg);
        }
        catch (Throwable e) {
            logger.error(e);
        }
        option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        for (Map.Entry<String, Set<Long>> entry : bizObjMap.entrySet()) {
            String entityKey = entry.getKey();
            Set<Long> billPks = entry.getValue();
            try {
                OperationResult voucherResult = OperationServiceHelper.executeOperate((String)"deletevoucher", (String)entityKey, (Object[])billPks.toArray(new Object[0]), (OperateOption)option);
                String delOpErrorMsg = CommonUtils.getOpErrorMsg(voucherResult);
                if (delOpErrorMsg.isEmpty()) continue;
                logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5220\u9664\u51ed\u8bc1\u5931\u8d25" + delOpErrorMsg);
                return false;
            }
            catch (Throwable e) {
                logger.error("\u4e1a\u8d22\u4e00\u4f53\u5316\u5220\u9664\u51ed\u8bc1\u5931\u8d25", e);
                return false;
            }
        }
        return true;
    }

    private DynamicObjectCollection getHasVouBillIds(Set<Long> costRecIds) {
        QFilter filter = new QFilter("sourcebillid", "in", costRecIds);
        DynamicObjectCollection dapDycs = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid, billtype, sourcebillid", (QFilter[])new QFilter[]{filter});
        return dapDycs;
    }
}

