/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;

public class ArOriginalUnWriteOffService {
    private static final Log logger = LogFactory.getLog(ArOriginalUnWriteOffService.class);
    private static final String AR_ORIGINAL_WFRECORD = "ar_originalwfrecord";
    private static final String RULEID = "1695728889583839232";
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE = 1678148494499522560L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_CORE = 1678144407779420160L;

    public void generateRedWfRecord(List<DynamicObject> writeOffBills) {
        HashMap<Long, Object[]> srcBillIdAndDate = new HashMap<Long, Object[]>(8);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            Long srcBillId = writeOffBill.getLong("sourcebillid");
            Object[] bookDate = writeOffBill.getDate("bookdate");
            srcBillIdAndDate.put(srcBillId, bookDate);
            srcBillIds.add(srcBillId);
        }
        if (ObjectUtils.isEmpty(srcBillIds)) {
            return;
        }
        QFilter mainBillIdFilter = new QFilter("entry.billid", "in", srcBillIds);
        Object[] records = BusinessDataServiceHelper.load((String)AR_ORIGINAL_WFRECORD, (String)"id,writeofftypeid,entry.id,entry.billid,entry.billentryid,entry.e_hadwrittenoff,entry.assbillid,entry.assbillentryid,entry.billtypeid,entry.assbillsourcetype", (QFilter[])new QFilter[]{mainBillIdFilter});
        if (ObjectUtils.isEmpty((Object[])records)) {
            return;
        }
        HashMap<Long, List<Long>> srcIdAndEntryId = new HashMap<Long, List<Long>>(8);
        for (Object object : records) {
            Long id = object.getLong("id");
            DynamicObjectCollection entries = object.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long entryId = entry.getLong("id");
                Long finBillId = entry.getLong("billid");
                if (!srcBillIds.contains(finBillId)) continue;
                List entryIdList = (List)srcIdAndEntryId.get(id);
                if (entryIdList == null) {
                    ArrayList<Long> temp = new ArrayList<Long>(8);
                    temp.add(entryId);
                    srcIdAndEntryId.put(id, temp);
                    continue;
                }
                entryIdList.add(entryId);
            }
        }
        if (srcIdAndEntryId.size() < 1) {
            return;
        }
        List<DynamicObject> redRecords = BOTPHelper.push4Result(AR_ORIGINAL_WFRECORD, "entry", AR_ORIGINAL_WFRECORD, RULEID, srcIdAndEntryId);
        if (ObjectUtils.isEmpty(redRecords)) {
            return;
        }
        ArrayList<Long> redRecordSrcFinIds = new ArrayList<Long>(8);
        for (DynamicObject dynamicObject : redRecords) {
            DynamicObjectCollection entries = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                redRecordSrcFinIds.add(entry.getLong("billid"));
            }
        }
        for (Object record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long finArBillId = entry.getLong("billid");
                if (!redRecordSrcFinIds.contains(finArBillId)) continue;
                entry.set("e_hadwrittenoff", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records);
        HashSet<Long> redRecordsForFinArBillIds = new HashSet<Long>(8);
        HashSet<Long> hashSet = new HashSet<Long>(8);
        for (DynamicObject redRecord : redRecords) {
            DynamicObjectCollection redEntries = redRecord.getDynamicObjectCollection("entry");
            Long writeOffTypeId = redRecord.getLong("writeofftypeid.id");
            for (DynamicObject redEntry : redEntries) {
                String writeBackType;
                Object writeBackTypeTemp;
                List backWriteDetailList;
                Map mainInfoMap;
                Object backWriteDetailListTemp;
                Long billId = redEntry.getLong("billid");
                Long assBillId = redEntry.getLong("assbillid");
                if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE.equals(writeOffTypeId) || HXLB_AR_ORIGINAL_VERIFY_QTY_CORE.equals(writeOffTypeId)) {
                    redRecordsForFinArBillIds.add(billId);
                    hashSet.add(assBillId);
                }
                Long billEntryId = redEntry.getLong("billentryid");
                Long assBillEntryId = redEntry.getLong("assbillentryid");
                Date date = (Date)srcBillIdAndDate.get(billId);
                if (date != null) {
                    redRecord.set("createtime", (Object)date);
                }
                for (Object record : records) {
                    DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        Long finArBillEntryId = entry.getLong("billentryid");
                        Long saloutEntryId = entry.getLong("assbillentryid");
                        if (!billEntryId.equals(finArBillEntryId) || !assBillEntryId.equals(saloutEntryId)) continue;
                        redEntry.set("billtypeid", entry.get("billtypeid"));
                        redEntry.set("assbillsourcetype", entry.get("assbillsourcetype"));
                    }
                }
                String mainWfInfo_tag = redEntry.getString("mainwfinfo_tag");
                String assWfInfo_tag = redEntry.getString("asswfinfo_tag");
                String mainInfoStr = null;
                String assInfoStr = null;
                if (StringUtils.isNotEmpty((CharSequence)mainWfInfo_tag) && (backWriteDetailListTemp = (mainInfoMap = (Map)SerializationUtils.fromJsonString((String)mainWfInfo_tag, Map.class)).get("backWriteDetailList")) != null) {
                    backWriteDetailList = (List)backWriteDetailListTemp;
                    for (Map infoMap : backWriteDetailList) {
                        writeBackTypeTemp = infoMap.get("writeBackType");
                        if (writeBackTypeTemp == null || !StringUtils.isNotEmpty((CharSequence)(writeBackType = (String)writeBackTypeTemp))) continue;
                        if ("1".equals(writeBackType)) {
                            infoMap.put("writeBackType", "0");
                        }
                        if (!"0".equals(writeBackType)) continue;
                        infoMap.put("writeBackType", "1");
                    }
                    mainInfoStr = SerializationUtils.toJsonString((Object)mainInfoMap);
                }
                if (StringUtils.isNotEmpty((CharSequence)assWfInfo_tag)) {
                    Map assInfoMap = (Map)SerializationUtils.fromJsonString((String)assWfInfo_tag, Map.class);
                    backWriteDetailListTemp = assInfoMap.get("backWriteDetailList");
                    if (backWriteDetailListTemp != null) {
                        backWriteDetailList = (List)backWriteDetailListTemp;
                        for (Map infoMap : backWriteDetailList) {
                            writeBackTypeTemp = infoMap.get("writeBackType");
                            if (writeBackTypeTemp == null || !StringUtils.isNotEmpty((CharSequence)(writeBackType = (String)writeBackTypeTemp))) continue;
                            if ("1".equals(writeBackType)) {
                                infoMap.put("writeBackType", "0");
                            }
                            if (!"0".equals(writeBackType)) continue;
                            infoMap.put("writeBackType", "1");
                        }
                    }
                    assInfoStr = SerializationUtils.toJsonString((Object)assInfoMap);
                }
                if (StringUtils.isNotEmpty(mainInfoStr)) {
                    redEntry.set("mainwfinfo_tag", mainInfoStr);
                }
                if (!StringUtils.isNotEmpty(assInfoStr)) continue;
                redEntry.set("asswfinfo_tag", assInfoStr);
            }
        }
        SaveServiceHelper.save((DynamicObject[])redRecords.toArray(new DynamicObject[0]));
        if (ObjectUtils.isEmpty(redRecordsForFinArBillIds) || ObjectUtils.isEmpty(hashSet)) {
            return;
        }
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,invoicecode,invoiceno,invoicedamt,invoicedlocalamt,uninvoicedamt,uninvoicedlocalamt,issueinvrecamt,issueinvreclocalamt,entry.id,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_invoicedamt,entry.e_invoicedlocalamt,entry.e_uninvoicedamt,entry.e_uninvoicedlocalamt,entry.e_invoicecode,entry.e_invoiceno,entry.e_issueinvqty,entry.e_issueinvamt,entry.e_issueinvlocalamt,entry.e_issueinvtax,entry.e_issueinvlocaltax,entry.e_issueinvrecamt,entry.e_issueinvreclocalamt,entry.e_invoicecode,entry.e_invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "in", redRecordsForFinArBillIds)});
        this.disposeFinBill(finArBills, redRecords);
        logger.info("ArOriginalUnWriteOffService disposeOriginalService begin ");
        this.disposeOriginalService(hashSet, redRecords);
        logger.info("ArOriginalUnWriteOffService disposeOriginalService end ");
    }

    private void disposeFinBill(DynamicObject[] finArBills, List<DynamicObject> redRecords) {
        HashMap<Long, ArrayList<DynamicObject>> entryIdRecordMap = new HashMap<Long, ArrayList<DynamicObject>>(redRecords.size());
        HashMap<Long, Long> entryIdVerifyTypeId = new HashMap<Long, Long>(redRecords.size());
        for (DynamicObject redRecord : redRecords) {
            Long writeOffTypeId = redRecord.getLong("writeofftypeid.id");
            DynamicObjectCollection entrys = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long billentryid = entry.getLong("billentryid");
                ArrayList<DynamicObject> redRecordList = (ArrayList<DynamicObject>)entryIdRecordMap.get(billentryid);
                if (ObjectUtils.isEmpty((Object)redRecordList)) {
                    redRecordList = new ArrayList<DynamicObject>(entrys.size());
                    redRecordList.add(entry);
                } else {
                    redRecordList.add(entry);
                }
                entryIdRecordMap.put(billentryid, redRecordList);
                entryIdVerifyTypeId.put(billentryid, writeOffTypeId);
            }
        }
        for (DynamicObject finArBill : finArBills) {
            BigDecimal headInvoicedamt = finArBill.getBigDecimal("invoicedamt");
            BigDecimal headInvoicedlocalamt = finArBill.getBigDecimal("invoicedlocalamt");
            BigDecimal headUnInvoicedamt = finArBill.getBigDecimal("uninvoicedamt");
            BigDecimal headUnInvoicedlocalamt = finArBill.getBigDecimal("uninvoicedlocalamt");
            BigDecimal headIssueinvrecamt = finArBill.getBigDecimal("issueinvrecamt");
            BigDecimal headIssueinvreclocalamt = finArBill.getBigDecimal("issueinvreclocalamt");
            DynamicObjectCollection finArEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject finArEntry : finArEntries) {
                Long entryId = finArEntry.getLong("id");
                BigDecimal invoicedqty = finArEntry.getBigDecimal("e_invoicedqty");
                BigDecimal unInvoicedQty = finArEntry.getBigDecimal("e_uninvoicedqty");
                BigDecimal invoicedAmt = finArEntry.getBigDecimal("e_invoicedamt");
                BigDecimal invoiceLocalAmt = finArEntry.getBigDecimal("e_invoicedlocalamt");
                BigDecimal unInvoicedAmt = finArEntry.getBigDecimal("e_uninvoicedamt");
                BigDecimal unInvoicedLocalAmt = finArEntry.getBigDecimal("e_uninvoicedlocalamt");
                BigDecimal issueInvQty = finArEntry.getBigDecimal("e_issueinvqty");
                BigDecimal issueInvAmt = finArEntry.getBigDecimal("e_issueinvamt");
                BigDecimal issueInvLocalAmt = finArEntry.getBigDecimal("e_issueinvlocalamt");
                BigDecimal issueInvTax = finArEntry.getBigDecimal("e_issueinvtax");
                BigDecimal issueInvLocalTax = finArEntry.getBigDecimal("e_issueinvlocaltax");
                BigDecimal issueInvRecAmt = finArEntry.getBigDecimal("e_issueinvrecamt");
                BigDecimal issueInvRecLocalAmt = finArEntry.getBigDecimal("e_issueinvreclocalamt");
                String invoiceCode = finArEntry.getString("e_invoicecode");
                String invoiceNo = finArEntry.getString("e_invoiceno");
                ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invoiceNo.split(", ")));
                ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invoiceCode.split(", ")));
                List redRecordEntryList = (List)entryIdRecordMap.get(entryId);
                if (ObjectUtils.isEmpty((Object)redRecordEntryList)) continue;
                for (DynamicObject entry : redRecordEntryList) {
                    headInvoicedamt = headInvoicedamt.add(entry.getBigDecimal("verifypricetax"));
                    headInvoicedlocalamt = headInvoicedlocalamt.add(entry.getBigDecimal("verifylocpricetax"));
                    headUnInvoicedamt = headUnInvoicedamt.subtract(entry.getBigDecimal("verifypricetax"));
                    headUnInvoicedlocalamt = headUnInvoicedlocalamt.subtract(entry.getBigDecimal("verifylocpricetax"));
                    headIssueinvrecamt = headIssueinvrecamt.add(entry.getBigDecimal("assverifypricetax"));
                    headIssueinvreclocalamt = headIssueinvreclocalamt.add(entry.getBigDecimal("assverifylocpricetax"));
                    invoicedqty = invoicedqty.add(entry.getBigDecimal("verifyqty"));
                    unInvoicedQty = unInvoicedQty.subtract(entry.getBigDecimal("verifyqty"));
                    invoicedAmt = invoicedAmt.add(entry.getBigDecimal("verifypricetax"));
                    invoiceLocalAmt = invoiceLocalAmt.add(entry.getBigDecimal("verifylocpricetax"));
                    unInvoicedAmt = unInvoicedAmt.subtract(entry.getBigDecimal("verifypricetax"));
                    unInvoicedLocalAmt = unInvoicedLocalAmt.subtract(entry.getBigDecimal("verifylocpricetax"));
                    Long writeOffTypeId = (Long)entryIdVerifyTypeId.get(entryId);
                    if (HXLB_AR_ORIGINAL_VERIFY_AMOUNT_CORE.equals(writeOffTypeId)) {
                        issueInvQty = issueInvQty.add(entry.getBigDecimal("verifyqty"));
                    } else if (HXLB_AR_ORIGINAL_VERIFY_QTY_CORE.equals(writeOffTypeId)) {
                        issueInvQty = issueInvQty.add(entry.getBigDecimal("assverifyqty"));
                    }
                    issueInvAmt = issueInvAmt.add(entry.getBigDecimal("assverifyamt"));
                    issueInvLocalAmt = issueInvLocalAmt.add(entry.getBigDecimal("assverifylocamt"));
                    issueInvTax = issueInvTax.add(entry.getBigDecimal("assverifytax"));
                    issueInvLocalTax = issueInvLocalTax.add(entry.getBigDecimal("assverifyloctax"));
                    issueInvRecAmt = issueInvRecAmt.add(entry.getBigDecimal("assverifypricetax"));
                    issueInvRecLocalAmt = issueInvRecLocalAmt.add(entry.getBigDecimal("assverifylocpricetax"));
                    inCodesList.remove("");
                    inNosList.remove("");
                    String assinvoiceno = entry.getString("assinvoiceno");
                    String assinvoicecode = entry.getString("assinvoicecode");
                    for (int i = inNosList.size() - 1; i >= 0; --i) {
                        if (ObjectUtils.isEmpty((Object)assinvoiceno) || !assinvoiceno.equals(inNosList.get(i))) continue;
                        if (!ObjectUtils.isEmpty((Object)assinvoicecode) && assinvoicecode.equals(inCodesList.get(i))) {
                            inCodesList.remove(i);
                        }
                        inNosList.remove(i);
                    }
                }
                finArEntry.set("e_invoicedqty", (Object)invoicedqty);
                finArEntry.set("e_uninvoicedqty", (Object)unInvoicedQty);
                finArEntry.set("e_invoicedamt", (Object)invoicedAmt);
                finArEntry.set("e_invoicedlocalamt", (Object)invoiceLocalAmt);
                finArEntry.set("e_uninvoicedamt", (Object)unInvoicedAmt);
                finArEntry.set("e_uninvoicedlocalamt", (Object)unInvoicedLocalAmt);
                finArEntry.set("e_issueinvqty", (Object)issueInvQty);
                finArEntry.set("e_issueinvamt", (Object)issueInvAmt);
                finArEntry.set("e_issueinvlocalamt", (Object)issueInvLocalAmt);
                finArEntry.set("e_issueinvtax", (Object)issueInvTax);
                finArEntry.set("e_issueinvlocaltax", (Object)issueInvLocalTax);
                finArEntry.set("e_issueinvrecamt", (Object)issueInvRecAmt);
                finArEntry.set("e_issueinvreclocalamt", (Object)issueInvRecLocalAmt);
                finArEntry.set("e_issueinvreclocalamt", (Object)issueInvRecLocalAmt);
                finArEntry.set("e_issueinvreclocalamt", (Object)issueInvRecLocalAmt);
                finArEntry.set("e_invoicecode", (Object)String.join((CharSequence)", ", inCodesList));
                finArEntry.set("e_invoiceno", (Object)String.join((CharSequence)", ", inNosList));
            }
            finArBill.set("invoicedamt", (Object)headInvoicedamt);
            finArBill.set("invoicedlocalamt", (Object)headInvoicedlocalamt);
            finArBill.set("uninvoicedamt", (Object)headUnInvoicedamt);
            finArBill.set("uninvoicedlocalamt", (Object)headUnInvoicedlocalamt);
            finArBill.set("issueinvrecamt", (Object)headIssueinvrecamt);
            finArBill.set("issueinvreclocalamt", (Object)headIssueinvreclocalamt);
        }
        this.doArHeadInvNoCode(finArBills);
    }

    private void doArHeadInvNoCode(DynamicObject[] arBills) {
        for (DynamicObject arBill : arBills) {
            DynamicObjectCollection entrys = arBill.getDynamicObjectCollection("entry");
            HashSet<String> headNosSet = new HashSet<String>(entrys.size());
            HashSet<String> headCodesSet = new HashSet<String>(entrys.size());
            for (DynamicObject entry : entrys) {
                String invCode = entry.getString("e_invoicecode");
                String invNo = entry.getString("e_invoiceno");
                ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invNo.split(", ")));
                ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invCode.split(", ")));
                inCodesList.remove("");
                inNosList.remove("");
                if (!ObjectUtils.isEmpty(inCodesList)) {
                    headCodesSet.addAll(inCodesList);
                }
                if (ObjectUtils.isEmpty(inNosList)) continue;
                headNosSet.addAll(inNosList);
            }
            arBill.set("invoicecode", (Object)String.join((CharSequence)", ", headCodesSet));
            arBill.set("invoiceno", (Object)String.join((CharSequence)", ", headNosSet));
        }
        SaveServiceHelper.save((DynamicObject[])arBills);
    }

    private void disposeOriginalService(Set<Long> idSet, List<DynamicObject> redRecords) {
        HashMap disposeMap = new HashMap(redRecords.size());
        for (DynamicObject redRecord : redRecords) {
            DynamicObjectCollection entrys = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal verifyqty;
                BigDecimal verifylocpricetax;
                BigDecimal verifypricetax;
                HashMap<String, BigDecimal> entryDisposeMap;
                long entryId = entry.getLong("assbillentryid");
                ArrayList mapList = (ArrayList)disposeMap.get(entryId);
                if (ObjectUtils.isEmpty((Object)mapList)) {
                    mapList = new ArrayList(redRecords.size());
                    entryDisposeMap = new HashMap(redRecords.size());
                    verifypricetax = entry.getBigDecimal("assverifypricetax");
                    verifylocpricetax = entry.getBigDecimal("assverifylocpricetax");
                    verifyqty = entry.getBigDecimal("assverifyqty");
                    entryDisposeMap.put("verifypricetax", verifypricetax);
                    entryDisposeMap.put("verifylocpricetax", verifylocpricetax);
                    entryDisposeMap.put("verifyqty", verifyqty);
                    mapList.add(entryDisposeMap);
                } else {
                    entryDisposeMap = new HashMap<String, BigDecimal>(redRecords.size());
                    verifypricetax = entry.getBigDecimal("assverifypricetax");
                    verifylocpricetax = entry.getBigDecimal("assverifylocpricetax");
                    verifyqty = entry.getBigDecimal("assverifyqty");
                    entryDisposeMap.put("verifypricetax", verifypricetax);
                    entryDisposeMap.put("verifylocpricetax", verifylocpricetax);
                    entryDisposeMap.put("verifyqty", verifyqty);
                    mapList.add(entryDisposeMap);
                }
                disposeMap.put(entryId, mapList);
            }
        }
        CommonParam commonParam = new CommonParam();
        commonParam.put((Object)"disposemap", disposeMap);
        commonParam.put((Object)"ids", idSet);
        commonParam.put((Object)"isredrecord", (Object)Boolean.TRUE);
        commonParam.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_original_verify", "ar_original_verify_wboriginal", "fi", "ar", "ArOriginalWBOriginalECService", (Param)commonParam, "", new ArrayList<Object>(idSet));
    }

    public void disposeUnVerify(DynamicObject[] dataEntities) {
        DynamicObject[] records;
        List<DynamicObject> writeOffBillList = ArOriginalUnWriteOffService.listWriteOffBill(dataEntities);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(writeOffBillList.size());
        for (DynamicObject writeOffBill : writeOffBillList) {
            Long srcBillId = writeOffBill.getLong("sourcebillid");
            srcBillIds.add(srcBillId);
        }
        QFilter mainBillIdFilter = new QFilter("entry.billid", "in", srcBillIds);
        QFilter isRedFilter = new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject[] redRecords = BusinessDataServiceHelper.load((String)AR_ORIGINAL_WFRECORD, (String)"id", (QFilter[])new QFilter[]{mainBillIdFilter, isRedFilter});
        List recordIds = Arrays.stream(redRecords).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (recordIds.isEmpty()) {
            return;
        }
        CommonParam param = new CommonParam();
        param.put((Object)"ids", recordIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_original_verify", "ar_original_unverifyimpl", "fi", "ar", "ArOriginalDisposeUnVerifyECService", (Param)param, "", new ArrayList<Object>(recordIds));
        QFilter hadRedFilter = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE);
        for (DynamicObject record : records = BusinessDataServiceHelper.load((String)AR_ORIGINAL_WFRECORD, (String)"id,entry.billid,entry.e_hadwrittenoff", (QFilter[])new QFilter[]{mainBillIdFilter, hadRedFilter})) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                if (!srcBillIds.contains(entry.getLong("billid"))) continue;
                entry.set("e_hadwrittenoff", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records);
    }

    private static List<DynamicObject> listWriteOffBill(DynamicObject[] billList) {
        ArrayList<DynamicObject> writeOffBillList = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill : billList) {
            boolean writeOff = bill.getBoolean("iswrittenoff");
            if (!writeOff) continue;
            writeOffBillList.add(bill);
        }
        return writeOffBillList;
    }
}

