/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArOriginalVerifyRecordList
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)commonFilterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"writeofftypeid.number".equals(fieldName)) continue;
            commonFilter.getComboItems().clear();
            commonFilter.setComboItems(this.getWriteOffTypesComboItem());
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object isView = listShowParameter.getCustomParam("isView");
        if (!EmptyUtils.isEmpty(isView)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            filterColumnList.clear();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("writeofftypeid.number".equals(fieldName) || "writeofftypeid.name".equals(fieldName) || "writeofftypeid.id".equals(fieldName)) {
            args.addCustomQFilter(new QFilter("id", "in", this.getWriteOffTypesSet()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("billno".equals(fieldName) || "assbillno".equals(fieldName)) {
            args.setCancel(true);
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            BillList billList = (BillList)hyperLinkClickEvent.getSource();
            Object pkId = billList.getFocusRowPkId();
            DynamicObject verifyRecord = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.getRecordEntityName(), (String)"billid,assbillid");
            BillList list = (BillList)this.getControl("billlistap");
            long rowId = 0L;
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int indexOffset = -1;
            for (ListSelectedRow row : selectedRows) {
                int rowKey = row.getRowKey();
                if (rowKey == -1) {
                    if (rowIndex != ++indexOffset) continue;
                    rowId = (Long)row.getEntryPrimaryKeyValue();
                    break;
                }
                if (rowIndex == rowKey) {
                    rowId = (Long)row.getEntryPrimaryKeyValue();
                    break;
                }
                indexOffset = rowKey;
            }
            DynamicObjectCollection entryColl = verifyRecord.getDynamicObjectCollection("entry");
            DynamicObject entry = null;
            for (DynamicObject entryObj : entryColl) {
                long entryId = (Long)entryObj.getPkValue();
                if (rowId != entryId) continue;
                entry = entryObj;
                break;
            }
            if (entry != null) {
                BillShowParameter param = new BillShowParameter();
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                if ("billno".equals(fieldName)) {
                    this.setBillShowParameter(param, entry.get("billid"), true);
                } else {
                    this.setBillShowParameter(param, entry.get("assbillid"), false);
                }
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public List<ComboItem> getWriteOffTypesComboItem() {
        DynamicObject[] writeofftypeArray;
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(2);
        for (DynamicObject writeOffType : writeofftypeArray = BusinessDataServiceHelper.load((Object[])this.getWriteOffTypesSet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msmod_writeofftype"))) {
            comboItemList.add(new ComboItem(new LocaleString(writeOffType.getLocaleString("name").getLocaleValue()), writeOffType.getPkValue().toString()));
        }
        return comboItemList;
    }

    public Set<Long> getWriteOffTypesSet() {
        HashSet<Long> idSet = new HashSet<Long>(8);
        idSet.add(1678144407779420160L);
        idSet.add(1678148494499522560L);
        idSet.add(1693749472343164928L);
        idSet.add(1693748335779055616L);
        return idSet;
    }

    public void setBillShowParameter(BillShowParameter param, Object pk, boolean isMain) {
        if (isMain) {
            param.setFormId("ar_finarbill");
        } else {
            param.setFormId("sim_original_bill");
        }
        param.setPkId(pk);
    }

    public String getRecordEntityName() {
        return "ar_originalwfrecord";
    }
}

