/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;

public class ArRevManualVerifyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> orgIds = this.getOrgIdList();
        if (orgIds.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            this.getModel().setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
        }
        this.setDateRange();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableAndVisible();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("wfmanual".equals(operateKey)) {
            this.checkSelectRows();
            this.checkAsstactAndCur();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
    }

    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey) {
        int count = tableValueSetter.getCount();
        for (int i = 0; i < count; ++i) {
            if ("entry_a".equals(curEntryKey)) {
                tableValueSetter.set("e_unconfirmamt_cur_a", tableValueSetter.get("e_unconfirmamt_a", i), i);
                tableValueSetter.set("e_unconfirmqty_cur_a", tableValueSetter.get("e_unconfirmqty_a", i), i);
            }
            if (!"entry_b".equals(curEntryKey)) continue;
            tableValueSetter.set("e_unrecamt_cur_b", tableValueSetter.get("e_unrecamt_b", i), i);
            tableValueSetter.set("e_unrecqty_cur_b", tableValueSetter.get("e_unrecqty_b", i), i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("writeofftype".equals(name)) {
            this.writeOffTypeChange();
        } else if ("org".equals(name)) {
            this.setCurrencyByOrg();
        } else if ("e_unconfirmbaseqty_cur_a".equals(name) || "e_unrecbaseqty_cur_b".equals(name)) {
            this.verifyMainFieldChange(name, e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName = e.getProperty().getName();
        if ("org".equals(proName)) {
            this.beforeF7Org(e);
        }
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        List<Long> orgIds = this.getOrgIdList();
        QFilter qFilter = new QFilter("id", "in", orgIds);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
    }

    private void writeOffTypeChange() {
        this.getModel().deleteEntryData("entry_a");
        this.getModel().deleteEntryData("entry_b");
        this.setEnableAndVisible();
    }

    private void setEnableAndVisible() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        long wfTypeId = wfType.getLong("id");
        if (1566715159244716032L == wfTypeId) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_unconfirmamt_cur_a"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_unrecamt_cur_b"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_unconfirmbaseqty_cur_a"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_unrecbaseqty_cur_b"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_unconfirmqty_cur_a"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_unconfirmbaseqty_cur_a"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_unrecqty_cur_b"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_unrecbaseqty_cur_b"});
        }
        if (1569651463666271232L == wfTypeId) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_unconfirmamt_cur_a"});
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"e_unrecamt_cur_b"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_unconfirmbaseqty_cur_a"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"e_unrecbaseqty_cur_b"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_unconfirmqty_cur_a"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_unconfirmbaseqty_cur_a"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_unrecqty_cur_b"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_unrecbaseqty_cur_b"});
        }
    }

    private void checkAsstactAndCur() {
        Map<String, Set<Long>> mainAsstactAndCurMap = this.getAsstactAndCurByType("A");
        Map<String, Set<Long>> assistAsstactAndCurMap = this.getAsstactAndCurByType("B");
        boolean isDiffAsstact = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "asstact");
        boolean isDiffCurrency = this.getIsDiffValue(mainAsstactAndCurMap, assistAsstactAndCurMap, "currency");
        if (isDiffAsstact || isDiffCurrency) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5f80\u6765\u6237\u6216\u5e01\u79cd\u4e0d\u540c\uff0c\u65e0\u6cd5\u6838\u9500\u3002", (String)"ArRevManualVerifyPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void checkSelectRows() {
        EntryGrid entryGridA = (EntryGrid)this.getControl("entry_a");
        EntryGrid entryGridB = (EntryGrid)this.getControl("entry_b");
        if (entryGridA.getSelectRows().length <= 0 || entryGridB.getSelectRows().length <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"ArRevManualVerifyPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private boolean getIsDiffValue(Map<String, Set<Long>> mainAsstactAndCurMap, Map<String, Set<Long>> assistAsstactAndCurMap, String fieldName) {
        boolean isDiffValue = false;
        Set<Long> mainbillSet = mainAsstactAndCurMap.get(fieldName);
        Set<Long> assistbillSet = assistAsstactAndCurMap.get(fieldName);
        if (mainbillSet.size() != assistbillSet.size()) {
            isDiffValue = true;
        } else {
            for (Long mainBillId : mainbillSet) {
                if (assistbillSet.contains(mainBillId)) continue;
                isDiffValue = true;
                break;
            }
            for (Long assistBillId : assistbillSet) {
                if (mainbillSet.contains(assistBillId)) continue;
                isDiffValue = true;
                break;
            }
        }
        return isDiffValue;
    }

    private Map<String, Set<Long>> getAsstactAndCurByType(String type) {
        String entityNum;
        String billIdFieldName;
        String entryName;
        HashMap<String, Set<Long>> asstactAndCurrencyMap = new HashMap<String, Set<Long>>(16);
        IDataModel model = this.getModel();
        if ("A".equals(type)) {
            entryName = "entry_a";
            billIdFieldName = "billid_a";
            entityNum = "ar_finarbill";
        } else {
            entryName = "entry_b";
            billIdFieldName = "billid_b";
            entityNum = "ar_revcfmbill";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (int index : selectedRowIndexs) {
            Long billId = (Long)model.getValue(billIdFieldName, index);
            billIdSet.add(billId);
        }
        String asstactName = "asstact";
        String currencyName = "currency";
        String selectFiled = asstactName + "," + currencyName;
        DataSet scmBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNum, (String)selectFiled, (QFilter[])new QFilter("id", "in", billIdSet).toArray(), null);
        billIdSet.clear();
        for (Row bill : scmBillDataSet) {
            Long asstactId = bill.getLong(asstactName);
            Long currencyId = bill.getLong(currencyName);
            HashSet<Long> asstactIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("asstact");
            HashSet<Long> currencyIdSet = (HashSet<Long>)asstactAndCurrencyMap.get("currency");
            if (asstactIdSet == null) {
                asstactIdSet = new HashSet<Long>(16);
            }
            if (currencyIdSet == null) {
                currencyIdSet = new HashSet<Long>(16);
            }
            asstactIdSet.add(asstactId);
            currencyIdSet.add(currencyId);
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
            asstactAndCurrencyMap.put("currency", currencyIdSet);
        }
        Set asstactIdSet = (Set)asstactAndCurrencyMap.get("asstact");
        if (asstactIdSet != null) {
            DataSet asstactDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"masterid", (QFilter[])new QFilter("id", "in", (Object)asstactIdSet).toArray(), null);
            asstactIdSet.clear();
            for (Row row : asstactDataSet) {
                asstactIdSet.add(row.getLong("masterid"));
            }
            asstactAndCurrencyMap.put("asstact", asstactIdSet);
        }
        return asstactAndCurrencyMap;
    }

    private void setDateRange() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(5, 1);
        endDate.set(5, endDate.getActualMaximum(5));
        this.getModel().setValue("startdate", (Object)sdf.format(startDate.getTime()));
        this.getModel().setValue("enddate", (Object)sdf.format(endDate.getTime()));
    }

    private void setCurrencyByOrg() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            model.setValue("currency", null);
            return;
        }
        Long orgId = org.getLong("id");
        DynamicObject init = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        model.setValue("currency", init.getDynamicObject("standardcurrency").getPkValue());
    }

    private void verifyMainFieldChange(String name, PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal verifyMainField = (BigDecimal)e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "e_unconfirmbaseqty_cur_a": {
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_a").get(rowIndex);
                int precision = entryRow.getInt("currency_a.amtprecision");
                BigDecimal convertRate = (BigDecimal)model.getValue("e_unitcoefficient_a", rowIndex);
                BigDecimal unVerifyBaseQty = (BigDecimal)model.getValue("e_unconfirmbaseqty_a", rowIndex);
                DynamicObject unit = (DynamicObject)model.getValue("e_measureunit_a", rowIndex);
                BigDecimal verifyQty = UnitConvertHelper.getUnitQty(verifyMainField, convertRate, unit);
                BigDecimal unitprice = (BigDecimal)model.getValue("e_unitprice_a", rowIndex);
                BigDecimal unVerifyAmt = (BigDecimal)model.getValue("e_unconfirmamt_a", rowIndex);
                BigDecimal verifyAmt = unVerifyAmt.compareTo(BigDecimal.ZERO) == 0 && unitprice.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ZERO : (verifyMainField.compareTo(unVerifyBaseQty) == 0 ? unVerifyAmt : verifyQty.multiply(unitprice).setScale(precision, RoundingMode.HALF_UP));
                model.setValue("e_unconfirmqty_cur_a", (Object)verifyQty, rowIndex);
                model.setValue("e_unconfirmamt_cur_a", (Object)verifyAmt, rowIndex);
                break;
            }
            case "e_unrecbaseqty_cur_b": {
                DynamicObject entryRow = (DynamicObject)this.getModel().getEntryEntity("entry_b").get(rowIndex);
                int precision = entryRow.getInt("currency_b.amtprecision");
                BigDecimal convertRate = (BigDecimal)model.getValue("e_unitcoefficient_b", rowIndex);
                BigDecimal unVerifyBaseQty = (BigDecimal)model.getValue("e_unrecbaseqty_b", rowIndex);
                DynamicObject unit = (DynamicObject)model.getValue("e_measureunit_b", rowIndex);
                BigDecimal verifyQty = UnitConvertHelper.getUnitQty(verifyMainField, convertRate, unit);
                BigDecimal unitprice = (BigDecimal)model.getValue("e_unitprice_b", rowIndex);
                BigDecimal unVerifyAmt = (BigDecimal)model.getValue("e_unrecamt_b", rowIndex);
                BigDecimal verifyAmt = unVerifyAmt.compareTo(BigDecimal.ZERO) == 0 && unitprice.compareTo(BigDecimal.ZERO) != 0 ? BigDecimal.ZERO : (verifyMainField.compareTo(unVerifyBaseQty) == 0 ? unVerifyAmt : verifyQty.multiply(unitprice).setScale(precision, RoundingMode.HALF_UP));
                model.setValue("e_unrecqty_cur_b", (Object)verifyQty, rowIndex);
                model.setValue("e_unrecamt_cur_b", (Object)verifyAmt, rowIndex);
                break;
            }
        }
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject material = (DynamicObject)model.getValue("material");
        DynamicObject asstact = (DynamicObject)model.getValue("customer");
        QFilter billQ = new QFilter("org", "=", (Object)org.getLong("id"));
        billQ.and("billstatus", "=", (Object)"C");
        billQ.and("bookdate", ">=", (Object)startDate);
        billQ.and("bookdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        billQ.and("currency", "=", (Object)currency.getLong("id"));
        if (asstact != null) {
            billQ.and("asstact", "in", (Object)asstact.getLong("id"));
        }
        if (material != null) {
            billQ.and("entry.e_material", "=", (Object)material.getLong("id"));
        }
        billFilters.add(billQ);
    }

    private List<Long> getOrgIdList() {
        return OrgHelper.getAuthorizedInitializedOrgIds("ar_rev_manualverify", "47150e89000000ac", true);
    }
}

