/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.RevCfmChargeAgainstService;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class ArRevWrittenOffVerifyService {
    private static final Log logger = LogFactory.getLog(ArRevWrittenOffVerifyService.class);
    private final boolean isMain;

    public ArRevWrittenOffVerifyService() {
        this.isMain = true;
    }

    public ArRevWrittenOffVerifyService(boolean isMain) {
        this.isMain = isMain;
    }

    public void writtenOffVerify(List<DynamicObject> writeOffBills) {
        ArrayList<Long> srcBillIds = new ArrayList<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            Long srcBillId = writeOffBill.getLong("sourcebillid");
            srcBillIds.add(srcBillId);
        }
        if (srcBillIds.size() < 1) {
            return;
        }
        QFilter billIdFilter = this.isMain ? new QFilter("entry.billid", "in", srcBillIds) : new QFilter("entry.assbillid", "in", srcBillIds);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)ArRevWrittenOffVerifyService.getVerifyRecordSelector(), (QFilter[])new QFilter[]{billIdFilter});
        if (records.length == 0) {
            return;
        }
        HashMap<Long, List<Long>> srcIdAndEntryId = new HashMap<Long, List<Long>>(8);
        for (DynamicObject record : records) {
            Long id = record.getLong("id");
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                boolean hadwrittenoff = entry.getBoolean("e_hadwrittenoff");
                boolean iswrittenoff = entry.getBoolean("e_iswrittenoff");
                Long billid = this.isMain ? entry.getLong("billid") : entry.getLong("assbillid");
                if (!srcBillIds.contains(billid) || hadwrittenoff || iswrittenoff) continue;
                List entryIdList = (List)srcIdAndEntryId.get(id);
                if (entryIdList == null) {
                    ArrayList<Long> temp = new ArrayList<Long>(8);
                    temp.add(entryId);
                    srcIdAndEntryId.put(id, temp);
                    continue;
                }
                entryIdList.add(entryId);
            }
        }
        if (srcIdAndEntryId.size() == 0) {
            return;
        }
        List<DynamicObject> redVerifyRecords = BOTPHelper.push4Result("ar_revcrm_verifyrecord", "entry", "ar_revcrm_verifyrecord", "1665242369961803776", srcIdAndEntryId);
        BookDateHelper.setVerifyDate(redVerifyRecords, true);
        this.updateSrcVerifyRecordStatus(records, srcBillIds);
        this.disposeSrcBill(redVerifyRecords, true);
        List<DynamicObject> redRevCfmBills = this.buildRedAdjustRevBills(redVerifyRecords);
        if (redRevCfmBills.size() > 0) {
            this.updateRedVerifyRecordsAdjustRevBillId(redVerifyRecords, redRevCfmBills);
        }
        this.updateWrittenOffSrcId(redVerifyRecords);
        String arRevVerifyIsExecuteSaveOp = StdConfig.get("arRevVerifyIsExecuteSaveOp");
        if ("true".equals(arRevVerifyIsExecuteSaveOp)) {
            OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcrm_verifyrecord", (DynamicObject[])redVerifyRecords.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        } else {
            SaveServiceHelper.save((DynamicObject[])redVerifyRecords.toArray(new DynamicObject[0]));
        }
    }

    private void updateWrittenOffSrcId(List<DynamicObject> redVerifyRecords) {
        for (DynamicObject redVerifyRecord : redVerifyRecords) {
            DynamicObjectCollection recordEntrys = redVerifyRecord.getDynamicObjectCollection("entry");
            for (DynamicObject recordEntry : recordEntrys) {
                Long writtenoffsrcid = this.isMain ? recordEntry.getLong("billid") : recordEntry.getLong("assbillid");
                recordEntry.set("writtenoffsrcid", (Object)writtenoffsrcid);
            }
        }
    }

    public void writtenOffUnVerify(Set<Long> srcFinBillIds) {
        Set<Long> redRevBillIds;
        logger.info("ArRevWrittenOffVerifyService.writtenOffUnVerify begin");
        QFilter mianBillIdFilter = new QFilter("entry.billid", "in", srcFinBillIds);
        QFilter isWrittenOffFilter = new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE);
        String verifyRecordSelector = ArRevWrittenOffVerifyService.getVerifyRecordSelector();
        DynamicObject[] redRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)verifyRecordSelector, (QFilter[])new QFilter[]{mianBillIdFilter, isWrittenOffFilter});
        if (redRecords.length == 0) {
            return;
        }
        QFilter hadWrittenOffFilter = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject[] hadWrittenOffRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)verifyRecordSelector, (QFilter[])new QFilter[]{mianBillIdFilter, hadWrittenOffFilter});
        HashSet<Long> srcRevBillIds = new HashSet<Long>(8);
        for (DynamicObject record2 : hadWrittenOffRecords) {
            DynamicObjectCollection recordEntry = record2.getDynamicObjectCollection("entry");
            for (DynamicObject entry2 : recordEntry) {
                if (!srcFinBillIds.contains(entry2.getLong("billid"))) continue;
                entry2.set("e_hadwrittenoff", (Object)Boolean.FALSE);
                long revbillid = entry2.getLong("revbillid");
                if (revbillid == 0L) continue;
                srcRevBillIds.add(revbillid);
            }
        }
        SaveServiceHelper.save((DynamicObject[])hadWrittenOffRecords);
        if (srcRevBillIds.size() > 0) {
            this.updateSrcRevCfmBillStatus(srcRevBillIds);
            ValidOperationServiceHelper.valid("ar_revcfmbill", srcRevBillIds.toArray());
        }
        if ((redRevBillIds = Arrays.stream(redRecords).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(entry -> entry.getLong("revbillid") != 0L).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet())).size() > 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("nochk", "true");
            OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"noprotocolunaudit", (String)"ar_revcfmbill", (Object[])redRevBillIds.toArray(new Long[0]), (OperateOption)op);
            OperationHelper.assertResult(unauditResult);
            OperationServiceHelper.executeOperate((String)"nocheckdel", (String)"ar_revcfmbill", (Object[])redRevBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        }
        this.disposeSrcBill(Arrays.asList(redRecords), false);
        ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0063", null, new Object[]{redRecords});
        Set<Long> redRecordIds = Arrays.stream(redRecords).map(record -> record.getLong("id")).collect(Collectors.toSet());
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_revcrm_verifyrecord", (Object[])redRecordIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
    }

    private void updateSrcRevCfmBillStatus(Set<Long> srcRevBillIds) {
        DynamicObject[] revcfmBills;
        for (DynamicObject revcfmBill : revcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", srcRevBillIds), new QFilter("hadwrittenoff", "=", (Object)Boolean.TRUE)})) {
            revcfmBill.set("hadwrittenoff", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])revcfmBills);
    }

    private void updateRedVerifyRecordsAdjustRevBillId(List<DynamicObject> redVerifyRecords, List<DynamicObject> redRevCfmBills) {
        HashMap<Long, RedRevBillInfo> revSrcIdToRedBillMap = new HashMap<Long, RedRevBillInfo>(redRevCfmBills.size());
        for (DynamicObject redRevCfmBill : redRevCfmBills) {
            Long srcBillId = redRevCfmBill.getLong("sourcebillid");
            RedRevBillInfo redRevBillInfo = new RedRevBillInfo();
            redRevBillInfo.id = redRevCfmBill.getLong("id");
            redRevBillInfo.billno = redRevCfmBill.getString("billno");
            revSrcIdToRedBillMap.put(srcBillId, redRevBillInfo);
        }
        for (DynamicObject redRecord : redVerifyRecords) {
            DynamicObjectCollection recordEntry = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                RedRevBillInfo redRevBillInfo = (RedRevBillInfo)revSrcIdToRedBillMap.get(entry.getLong("revbillid"));
                if (ObjectUtils.isEmpty((Object)redRevBillInfo)) continue;
                entry.set("revbillid", (Object)redRevBillInfo.id);
                entry.set("revbillno", (Object)redRevBillInfo.billno);
            }
        }
    }

    private List<DynamicObject> buildRedAdjustRevBills(List<DynamicObject> redVerifyRecords) {
        HashMap<Long, Date> srcAdjustRev2BookDateMap = new HashMap<Long, Date>(8);
        for (DynamicObject redVerifyRecord : redVerifyRecords) {
            Date verifyDate = redVerifyRecord.getDate("createtime");
            DynamicObjectCollection entrys = redVerifyRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long revbillid = entry.getLong("revbillid");
                if (revbillid == 0L) continue;
                srcAdjustRev2BookDateMap.put(revbillid, verifyDate);
            }
        }
        List<DynamicObject> againstRevCfmBills = new ArrayList<DynamicObject>(srcAdjustRev2BookDateMap.size());
        if (srcAdjustRev2BookDateMap.size() > 0) {
            logger.info("ArRevWrittenOffVerifyService.buildRedAdjustRevBills.revBillIds.size:" + srcAdjustRev2BookDateMap.size());
            RevCfmChargeAgainstService againstService = new RevCfmChargeAgainstService();
            againstRevCfmBills = BOTPHelper.push("ar_revcfmbill", "ar_revcfmbill", "1281716490650811392", new ArrayList<Long>(srcAdjustRev2BookDateMap.keySet()));
            for (DynamicObject againstRevCfmBill : againstRevCfmBills) {
                againstRevCfmBill.set("bizdate", srcAdjustRev2BookDateMap.get(againstRevCfmBill.getLong("sourcebillid")));
                againstRevCfmBill.set("billsrctype", (Object)BillSrcTypeEnum.VERIFY.getValue());
            }
            againstService.executeSubmitAndAudit(againstRevCfmBills);
            againstService.executeSourceBillDispose(againstRevCfmBills);
        }
        return againstRevCfmBills;
    }

    private void updateSrcVerifyRecordStatus(DynamicObject[] records, List<Long> hadWrittenOffBillIds) {
        for (DynamicObject record : records) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                boolean hadwrittenoff = entry.getBoolean("e_hadwrittenoff");
                boolean iswrittenoff = entry.getBoolean("e_iswrittenoff");
                Long billid = this.isMain ? entry.getLong("billid") : entry.getLong("assbillid");
                if (!hadWrittenOffBillIds.contains(billid) || hadwrittenoff || iswrittenoff) continue;
                entry.set("e_hadwrittenoff", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records);
    }

    private void disposeSrcBill(List<DynamicObject> redVerifyRecords, boolean forward) {
        ArrayList<DisposeParam> disMainParamList = new ArrayList<DisposeParam>(8);
        ArrayList<DisposeParam> disAsstParamList = new ArrayList<DisposeParam>(8);
        this.buildDisposeParam(redVerifyRecords, disMainParamList, disAsstParamList, forward);
        this.disposeMainBill(disMainParamList);
        this.disposeAsstBill(disAsstParamList);
    }

    private void buildDisposeParam(List<DynamicObject> redVerifyRecords, List<DisposeParam> disMainParamList, List<DisposeParam> disAsstParamList, boolean forward) {
        for (DynamicObject redRecord : redVerifyRecords) {
            DynamicObjectCollection recordEntry = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                DisposeParam disposeMainParam = new DisposeParam();
                disposeMainParam.id = entry.getLong("billid");
                disposeMainParam.entryId = entry.getLong("billentryid");
                disposeMainParam.verifyAmt = forward ? entry.getBigDecimal("verifyamt") : entry.getBigDecimal("verifyamt").negate();
                disposeMainParam.verifyQty = forward ? entry.getBigDecimal("verifyqty") : entry.getBigDecimal("verifyqty").negate();
                disposeMainParam.verifyBaseQty = forward ? entry.getBigDecimal("verifybaseqty") : entry.getBigDecimal("verifybaseqty").negate();
                disMainParamList.add(disposeMainParam);
                DisposeParam disposeAsstParam = new DisposeParam();
                disposeAsstParam.id = entry.getLong("assbillid");
                disposeAsstParam.entryId = entry.getLong("assbillentryid");
                disposeAsstParam.verifyAmt = forward ? entry.getBigDecimal("assverifyamt") : entry.getBigDecimal("assverifyamt").negate();
                disposeAsstParam.verifyQty = forward ? entry.getBigDecimal("assverifyqty") : entry.getBigDecimal("assverifyqty").negate();
                disposeAsstParam.verifyBaseQty = forward ? entry.getBigDecimal("assverifybaseqty") : entry.getBigDecimal("assverifybaseqty").negate();
                disAsstParamList.add(disposeAsstParam);
            }
        }
    }

    public static String getVerifyRecordSelector() {
        ArrayList<String> selector = new ArrayList<String>(50);
        selector.add("id");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        selector.add("entry.e_hadwrittenoff");
        selector.add("entry.e_iswrittenoff");
        selector.add("entry.revbillno");
        selector.add("entry.revbillid");
        selector.add("entry.verifyamt");
        selector.add("entry.verifyqty");
        selector.add("entry.verifybaseqty");
        selector.add("entry.assbillid");
        selector.add("entry.assbillentryid");
        selector.add("entry.assverifyamt");
        selector.add("entry.assverifyqty");
        selector.add("entry.assverifybaseqty");
        return String.join((CharSequence)",", selector);
    }

    private void disposeMainBill(List<DisposeParam> disMainParamList) {
        logger.info("ArRevWrittenOffVerifyService.disposeMainBill start");
        if (disMainParamList.size() > 0) {
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(disMainParamList.size());
            for (DisposeParam disposeParam : disMainParamList) {
                Object[] param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            String disposeSql = "update t_ar_finarbillentry set fconfirmedqty =fconfirmedqty + ?,funconfirmqty = funconfirmqty - ?,fconfirmedbaseqty = fconfirmedbaseqty + ?, funconfirmbaseqty = funconfirmbaseqty - ?,fconfirmedamt = fconfirmedamt + ?, funconfirmamt = funconfirmamt - ? where fentryid =? and fid = ?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
    }

    private void disposeAsstBill(List<DisposeParam> disAstParamList) {
        logger.info("ArRevWrittenOffVerifyService.disposeAsstBill start");
        if (disAstParamList.size() > 0) {
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(disAstParamList.size());
            for (DisposeParam disposeParam : disAstParamList) {
                Object[] param = new Object[]{disposeParam.verifyQty, disposeParam.verifyQty, disposeParam.verifyBaseQty, disposeParam.verifyBaseQty, disposeParam.verifyAmt, disposeParam.verifyAmt, disposeParam.entryId, disposeParam.id};
                sqlParams.add(param);
            }
            String disposeSql = "update t_ar_revcfmbillentry set frecqty =frecqty + ?,funrecqty = funrecqty - ?,frecbaseqty = frecbaseqty + ?, funrecbaseqty = funrecbaseqty - ?,frecamt = frecamt + ?, funrecamt = funrecamt - ? where fentryid =? and fid =?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)disposeSql, sqlParams);
        }
    }

    static class DisposeParam {
        long id;
        long entryId;
        BigDecimal verifyBaseQty;
        BigDecimal verifyQty;
        BigDecimal verifyAmt;

        DisposeParam() {
        }
    }

    static class RedRevBillInfo {
        long id;
        String billno;

        RedRevBillInfo() {
        }
    }
}

