/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;

public class ArSaloutUnWriteOffService {
    private static final Log logger = LogFactory.getLog(ArSaloutUnWriteOffService.class);
    private static final String AR_SALOUT_WFRECORD = "ar_saloutwfrecord";
    private static final String RULEID = "1692181545080643584";
    private static final Long HXLB_AR_SAL_CORE = 1679120508043735040L;

    public void generateRedWfRecord(List<DynamicObject> writeOffBills) {
        ArrayList<Long> srcBillIds = new ArrayList<Long>(writeOffBills.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (DynamicObject writeOffBill : writeOffBills) {
            orgIds.add(writeOffBill.getLong("org.id"));
            Long srcBillId = writeOffBill.getLong("sourcebillid");
            srcBillIds.add(srcBillId);
        }
        if (srcBillIds.size() < 1) {
            return;
        }
        QFilter mainBillIdFilter = new QFilter("entry.billid", "in", srcBillIds);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter hadWrittenOffFilter = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE);
        QFilter isWrittenOffFilter = new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)AR_SALOUT_WFRECORD, (String)"id,entry.id,entry.billid,entry.billentryid,entry.e_hadwrittenoff,entry.assbillid,entry.assbillentryid,entry.billtypeid,entry.assbilltypeid", (QFilter[])new QFilter[]{mainBillIdFilter, orgFilter, hadWrittenOffFilter, isWrittenOffFilter});
        HashMap<Long, List<Long>> srcIdAndEntryId = new HashMap<Long, List<Long>>(8);
        for (DynamicObject record : records) {
            Long id = record.getLong("id");
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                Long finBillId = entry.getLong("billid");
                if (!srcBillIds.contains(finBillId)) continue;
                List entryIdList = (List)srcIdAndEntryId.get(id);
                if (entryIdList == null) {
                    ArrayList<Long> temp = new ArrayList<Long>(8);
                    temp.add(entryId);
                    srcIdAndEntryId.put(id, temp);
                    continue;
                }
                entryIdList.add(entryId);
            }
        }
        if (srcIdAndEntryId.size() < 1) {
            return;
        }
        List<DynamicObject> redRecords = BOTPHelper.push4Result(AR_SALOUT_WFRECORD, "entry", AR_SALOUT_WFRECORD, RULEID, srcIdAndEntryId);
        if (redRecords.size() < 1) {
            return;
        }
        this.updateSrcRecordsHadWrittenOff(redRecords, records, true);
        List<Long> redRecordsForFinArBillIds = this.updateRedRecords(redRecords, records);
        List<DynamicObject> coreRecord = redRecords.stream().filter(e -> HXLB_AR_SAL_CORE.equals(e.getLong("writeofftypeid.id"))).collect(Collectors.toList());
        this.writeBackSaloutBills(coreRecord);
        DynamicObject[] finArBills = this.writeBackFinArBills(redRecordsForFinArBillIds, redRecords);
        if (finArBills.length < 1) {
            return;
        }
        this.writeBackOrderAndContract(coreRecord, finArBills);
    }

    public void disposeUnVerify(DynamicObject[] dataEntities) {
        DynamicObject[] records;
        List<DynamicObject> writeOffBillList = ArSaloutUnWriteOffService.listWriteOffBill(dataEntities);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(writeOffBillList.size());
        for (DynamicObject writeOffBill : writeOffBillList) {
            Long srcBillId = writeOffBill.getLong("sourcebillid");
            srcBillIds.add(srcBillId);
        }
        if (srcBillIds.size() < 1) {
            return;
        }
        QFilter mainBillIdFilter = new QFilter("entry.billid", "in", srcBillIds);
        QFilter isRedFilter = new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection redRecords = QueryServiceHelper.query((String)AR_SALOUT_WFRECORD, (String)"id,entry.billid", (QFilter[])new QFilter[]{mainBillIdFilter, isRedFilter});
        List<Object> recordIds = redRecords.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        List writeOffFinArBillIds = redRecords.stream().map(e -> e.getLong("entry.billid")).collect(Collectors.toList());
        if (recordIds.isEmpty()) {
            return;
        }
        CommonParam param = new CommonParam();
        long uniqueKey = DB.genGlobalLongId();
        param.put((Object)"uniquekey", (Object)uniqueKey);
        param.put((Object)"ids", recordIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_salout_verify", "ar_salout_unverifyimpl", "fi", "ar", "ArSaloutDisposeUnVerifyECService", (Param)param, "", recordIds);
        if (writeOffFinArBillIds.size() < 1) {
            return;
        }
        QFilter hadRedFilter = new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE);
        QFilter hadRedBillIdFilter = new QFilter("entry.billid", "in", writeOffFinArBillIds);
        for (DynamicObject record : records = BusinessDataServiceHelper.load((String)AR_SALOUT_WFRECORD, (String)"id,entry.billid,entry.e_hadwrittenoff,entry.verifyamt", (QFilter[])new QFilter[]{hadRedBillIdFilter, hadRedFilter})) {
            DynamicObjectCollection recordEntry = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : recordEntry) {
                Long billId = entry.getLong("billid");
                if (!srcBillIds.contains(billId)) continue;
                entry.set("e_hadwrittenoff", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records);
    }

    private static List<DynamicObject> listWriteOffBill(DynamicObject[] billList) {
        ArrayList<DynamicObject> writeOffBillList = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill : billList) {
            boolean writeOff = bill.getBoolean("iswrittenoff");
            if (!writeOff) continue;
            writeOffBillList.add(bill);
        }
        return writeOffBillList;
    }

    private List<Map<String, Object>> buildArToSalParam(List<DynamicObject> records, DynamicObject[] finArBills) {
        Long finArEntryId;
        Set seqTemp;
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        Map<Long, Boolean> assactInterMap = this.isExistInternalBusinessUnit(records);
        HashMap<Long, BigDecimal> entryIdQAndQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> entryIdQAndAmt = new HashMap<Long, BigDecimal>(8);
        HashSet<Long> updateFinArEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billEntryId = entry.getLong("billentryid");
                updateFinArEntryIdSet.add(billEntryId);
                entryIdQAndQty.merge(billEntryId, entry.getBigDecimal("verifybaseqty"), BigDecimal::add);
                entryIdQAndAmt.merge(billEntryId, entry.getBigDecimal("verifypricetotal"), BigDecimal::add);
            }
        }
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<String> conBillNos = new HashSet<String>(8);
        HashMap coreNoAndSeqs = new HashMap(8);
        HashMap conNoAndSeqs = new HashMap(8);
        HashMap<String, Long> coreNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        HashMap<String, Long> conNoSeqMapAndFinArEntryId = new HashMap<String, Long>(8);
        for (DynamicObject finArBill : finArBills) {
            DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                if (!updateFinArEntryIdSet.contains(entryId)) continue;
                String coreBillType = entry.getString("e_corebilltype");
                String coreBillNo = entry.getString("e_corebillno");
                int coreBillEntrySeq = entry.getInt("e_corebillentryseq");
                if (!StringUtils.isEmpty((CharSequence)coreBillType) && !StringUtils.isEmpty((CharSequence)coreBillNo) && coreBillEntrySeq != 0) {
                    coreNoSeqMapAndFinArEntryId.put(coreBillNo + coreBillEntrySeq, entryId);
                    coreBillNos.add(coreBillNo);
                    seqTemp = (Set)coreNoAndSeqs.get(coreBillNo);
                    if (seqTemp == null) {
                        HashSet<Integer> seqList = new HashSet<Integer>(8);
                        seqList.add(coreBillEntrySeq);
                        coreNoAndSeqs.put(coreBillNo, seqList);
                    } else {
                        seqTemp.add(coreBillEntrySeq);
                    }
                }
                String conBillType = entry.getString("e_conbillentity.number");
                String conBillNo = entry.getString("e_conbillnumber");
                String conBillEntrySeq = entry.getString("e_conbillrownum");
                if (StringUtils.isEmpty((CharSequence)conBillType) || StringUtils.isEmpty((CharSequence)conBillNo) || StringUtils.isEmpty((CharSequence)conBillEntrySeq) || !conBillEntrySeq.matches("^[0-9]*$")) continue;
                conNoSeqMapAndFinArEntryId.put(conBillNo + conBillEntrySeq, entryId);
                conBillNos.add(conBillNo);
                Set seqTemp2 = (Set)conNoAndSeqs.get(conBillNo);
                if (seqTemp2 == null) {
                    HashSet<String> seqList = new HashSet<String>(8);
                    seqList.add(conBillEntrySeq);
                    conNoAndSeqs.put(coreBillNo, seqList);
                    continue;
                }
                seqTemp2.add(conBillEntrySeq);
            }
        }
        HashMap finArEntryIdAndCoreIdEntryId = new HashMap(8);
        HashMap finArEntryIdAndConIdEntryId = new HashMap(8);
        if (coreBillNos.size() > 0) {
            DynamicObjectCollection salOrderBills = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billno,billentry.id,billentry.seq", (QFilter[])new QFilter[]{new QFilter("billno", "in", coreBillNos)});
            for (DynamicObject salOrderBill : salOrderBills) {
                long salOrderId = salOrderBill.getLong("id");
                long salOrderEntryId = salOrderBill.getLong("billentry.id");
                int salOrderEntrySeq = salOrderBill.getInt("billentry.seq");
                String salOrderNo = salOrderBill.getString("billno");
                seqTemp = (Set)coreNoAndSeqs.get(salOrderNo);
                if (seqTemp == null || !seqTemp.contains(salOrderEntrySeq) || (finArEntryId = (Long)coreNoSeqMapAndFinArEntryId.get(salOrderNo + salOrderEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndCoreIdEntryId.get(finArEntryId) != null) continue;
                HashMap<String, Long> coreIdAndEntryId = new HashMap<String, Long>(8);
                coreIdAndEntryId.put("coreid", salOrderId);
                coreIdAndEntryId.put("coreentryid", salOrderEntryId);
                finArEntryIdAndCoreIdEntryId.put(finArEntryId, coreIdAndEntryId);
            }
        }
        if (conBillNos.size() > 0) {
            DynamicObjectCollection salContractBills = QueryServiceHelper.query((String)"conm_salcontract", (String)"id,billno,billentry.id,billentry.lineno", (QFilter[])new QFilter[]{new QFilter("billno", "in", conBillNos)});
            for (DynamicObject salContractBill : salContractBills) {
                long salConId = salContractBill.getLong("id");
                long salConEntryId = salContractBill.getLong("billentry.id");
                String salConEntrySeq = salContractBill.getString("billentry.lineno");
                String salConNo = salContractBill.getString("billno");
                seqTemp = (Set)conNoAndSeqs.get(salConNo);
                if (seqTemp == null || !seqTemp.contains(salConEntrySeq) || (finArEntryId = (Long)conNoSeqMapAndFinArEntryId.get(salConNo + salConEntrySeq)) == null || finArEntryId == 0L || finArEntryIdAndConIdEntryId.get(finArEntryId) != null) continue;
                HashMap<String, Long> conIdAndEntryId = new HashMap<String, Long>(8);
                conIdAndEntryId.put("conid", salConId);
                conIdAndEntryId.put("conentryid", salConEntryId);
                finArEntryIdAndConIdEntryId.put(finArEntryId, conIdAndEntryId);
            }
        }
        for (DynamicObject finArBill : finArBills) {
            Long billId = finArBill.getLong("id");
            String sourceBillType = finArBill.getString("sourcebilltype");
            Long settleOrgId = finArBill.getLong("org.id");
            Long asstactId = finArBill.getLong("asstact.id");
            int amtPrecision = finArBill.getInt("currency.amtprecision");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                if (!updateFinArEntryIdSet.contains(entryId)) continue;
                String coreBillType = entry.getString("e_corebilltype");
                Map coreIdAndEntryId = (Map)finArEntryIdAndCoreIdEntryId.get(entryId);
                if (coreIdAndEntryId == null || coreIdAndEntryId.size() < 1) continue;
                Long coreBillId = (Long)coreIdAndEntryId.get("coreid");
                Long coreBillEntryId = (Long)coreIdAndEntryId.get("coreentryid");
                BigDecimal baseQty = (BigDecimal)entryIdQAndQty.get(entryId);
                BigDecimal amount = (BigDecimal)entryIdQAndAmt.get(entryId);
                Map conIdAndEntryId = (Map)finArEntryIdAndConIdEntryId.get(entryId);
                Long conbillid = 0L;
                Long conbillentryid = 0L;
                if (conIdAndEntryId != null && conIdAndEntryId.size() > 0) {
                    conbillid = (Long)conIdAndEntryId.get("conid");
                    conbillentryid = (Long)conIdAndEntryId.get("conentryid");
                }
                String conbillentity = entry.getString("e_conbillentity.number");
                if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
                String wbType = "sm_salorder".equals(coreBillType) ? "salorder" : "salcontract";
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("arinternalasst", isExistInternal);
                map.put("arasstactid", asstactId);
                map.put("arsettleorgid", settleOrgId);
                map.put("arMainBillEntity", coreBillType);
                map.put("soid", coreBillId);
                map.put("soentryid", coreBillEntryId);
                map.put("baseqty", baseQty);
                map.put("amount", amount.setScale(amtPrecision, RoundingMode.HALF_UP));
                map.put("conbillentity", conbillentity);
                map.put("conbillid", conbillid);
                map.put("conbillentryid", conbillentryid);
                map.put("wbtype", wbType);
                map.put("ArApBillId", billId);
                if ("sm_salorder".equals(sourceBillType)) {
                    map.put("sourcebilltype", "sm_salorder");
                }
                params.add(map);
            }
        }
        return params;
    }

    private Map<Long, Boolean> isExistInternalBusinessUnit(List<DynamicObject> records) {
        Map<Long, Boolean> tempAssactMap;
        HashSet<Long> supplierIds = new HashSet<Long>(8);
        HashSet<Long> customerIds = new HashSet<Long>(8);
        for (DynamicObject adjust : records) {
            String asstactType = adjust.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(adjust.getLong("asstact.id"));
            }
            if (!"bd_customer".equals(asstactType)) continue;
            customerIds.add(adjust.getLong("asstact.id"));
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(records.size());
        if (!supplierIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_supplier", supplierIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        if (!customerIds.isEmpty() && (tempAssactMap = this.checkInternalBusinessUnit("bd_customer", customerIds)).isEmpty()) {
            result.putAll(tempAssactMap);
        }
        return result;
    }

    private Map<Long, Boolean> checkInternalBusinessUnit(String entityName, Set<Long> assIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(assIds.size());
        Map assactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", assIds)});
        for (Map.Entry entrySet : assactMap.entrySet()) {
            DynamicObject asstact = (DynamicObject)entrySet.getValue();
            DynamicObject internalCompany = asstact.getDynamicObject("internal_company");
            if (internalCompany == null) {
                result.put(asstact.getLong("id"), Boolean.FALSE);
                continue;
            }
            if (internalCompany.getPkValue() != null && (Long)internalCompany.getPkValue() != 0L) {
                result.put(asstact.getLong("id"), Boolean.TRUE);
                continue;
            }
            result.put(asstact.getLong("id"), Boolean.FALSE);
        }
        return result;
    }

    private void disposeSalOrderService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSOAr");
        logger.info("ArSaloutUnWriteOffService.disposeSalOrderService.params:" + params);
        List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
        logger.info("ArSaloutUnWriteOffService.disposeSalOrderService.billid: " + arApBillIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_salout_verify", "ar_salout_verify_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
    }

    private void disposeSalContractService(List<Map<String, Object>> params) {
        long uniqueKey = DB.genGlobalLongId();
        for (Map<String, Object> dispose : params) {
            dispose.put("uniquekey", uniqueKey);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"list", params);
        param.put((Object)"method", (Object)"wbSalContAr");
        logger.info("ArSaloutUnWriteOffService.disposeSalContractService.params:" + params);
        List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
        logger.info("ArSaloutUnWriteOffService.disposeSalContractService.billid:" + arApBillIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_salout_verify", "ar_salout_verify_wbcontract", "scmc", "conm", "SalConmService", (Param)param, "", arApBillIds);
    }

    private void disposeWriteOffSalout(CommonParam param, List<Long> saloutIds) {
        if (param == null || saloutIds == null || saloutIds.size() < 1) {
            return;
        }
        logger.info("ArSaloutUnWriteOffService.disposeWriteOffSalout.pararms: " + param);
        List<Object> idList = Collections.singletonList(saloutIds);
        ECServiceHelper.beginAndRegisterWithBusInfo("ar_salout_verify", "ar_salout_verify_wbsalout", "fi", "ar", "ArSaloutVerifyUpdateSaloutECService", (Param)param, "", idList);
    }

    public void updateSrcRecordsHadWrittenOff(List<DynamicObject> redRecords, DynamicObject[] records, boolean isMain) {
        ArrayList<Long> redRecordSrcBillIds = new ArrayList<Long>(8);
        String idKey = isMain ? "billid" : "assbillid";
        for (DynamicObject record : redRecords) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                redRecordSrcBillIds.add(entry.getLong(idKey));
            }
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long billId = entry.getLong(idKey);
                if (!redRecordSrcBillIds.contains(billId)) continue;
                entry.set("e_hadwrittenoff", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records);
    }

    public List<Long> updateRedRecords(List<DynamicObject> redRecords, DynamicObject[] records) {
        BookDateHelper.setVerifyDate(redRecords, true);
        ArrayList<Long> redRecordsForFinArBillIds = new ArrayList<Long>(8);
        for (DynamicObject redRecord : redRecords) {
            DynamicObjectCollection redEntries = redRecord.getDynamicObjectCollection("entry");
            for (DynamicObject redEntry : redEntries) {
                String writeBackType;
                Object writeBackTypeTemp;
                List backWriteDetailList;
                Map mainInfoMap;
                Object backWriteDetailListTemp;
                Long billId = redEntry.getLong("billid");
                redRecordsForFinArBillIds.add(billId);
                Long billEntryId = redEntry.getLong("billentryid");
                Long assBillEntryId = redEntry.getLong("assbillentryid");
                for (DynamicObject record : records) {
                    DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        Long finArBillEntryId = entry.getLong("billentryid");
                        Long saloutEntryId = entry.getLong("assbillentryid");
                        if (!billEntryId.equals(finArBillEntryId) || !assBillEntryId.equals(saloutEntryId)) continue;
                        redEntry.set("billtypeid", entry.get("billtypeid"));
                        redEntry.set("assbilltypeid", entry.get("assbilltypeid"));
                    }
                }
                String mainWfInfo_tag = redEntry.getString("mainwfinfo_tag");
                String assWfInfo_tag = redEntry.getString("asswfinfo_tag");
                String mainInfoStr = null;
                String assInfoStr = null;
                if (StringUtils.isNotEmpty((CharSequence)mainWfInfo_tag) && (backWriteDetailListTemp = (mainInfoMap = (Map)SerializationUtils.fromJsonString((String)mainWfInfo_tag, Map.class)).get("backWriteDetailList")) != null) {
                    backWriteDetailList = (List)backWriteDetailListTemp;
                    for (Map infoMap : backWriteDetailList) {
                        writeBackTypeTemp = infoMap.get("writeBackType");
                        if (writeBackTypeTemp == null || !StringUtils.isNotEmpty((CharSequence)(writeBackType = (String)writeBackTypeTemp))) continue;
                        if ("1".equals(writeBackType)) {
                            infoMap.put("writeBackType", "0");
                        }
                        if (!"0".equals(writeBackType)) continue;
                        infoMap.put("writeBackType", "1");
                    }
                    mainInfoStr = SerializationUtils.toJsonString((Object)mainInfoMap);
                }
                if (StringUtils.isNotEmpty((CharSequence)assWfInfo_tag)) {
                    Map assInfoMap = (Map)SerializationUtils.fromJsonString((String)assWfInfo_tag, Map.class);
                    backWriteDetailListTemp = assInfoMap.get("backWriteDetailList");
                    if (backWriteDetailListTemp != null) {
                        backWriteDetailList = (List)backWriteDetailListTemp;
                        for (Map infoMap : backWriteDetailList) {
                            writeBackTypeTemp = infoMap.get("writeBackType");
                            if (writeBackTypeTemp == null || !StringUtils.isNotEmpty((CharSequence)(writeBackType = (String)writeBackTypeTemp))) continue;
                            if ("1".equals(writeBackType)) {
                                infoMap.put("writeBackType", "0");
                            }
                            if (!"0".equals(writeBackType)) continue;
                            infoMap.put("writeBackType", "1");
                        }
                    }
                    assInfoStr = SerializationUtils.toJsonString((Object)assInfoMap);
                }
                if (StringUtils.isNotEmpty(mainInfoStr)) {
                    redEntry.set("mainwfinfo_tag", mainInfoStr);
                }
                if (!StringUtils.isNotEmpty(assInfoStr)) continue;
                redEntry.set("asswfinfo_tag", assInfoStr);
            }
        }
        SaveServiceHelper.save((DynamicObject[])redRecords.toArray(new DynamicObject[0]));
        return redRecordsForFinArBillIds;
    }

    public void writeBackSaloutBills(List<DynamicObject> coreRecord) {
        ArrayList<Long> saloutIds = new ArrayList<Long>(8);
        CommonParam commonParam = new CommonParam();
        HashMap<Long, HashSet<Long>> assIdAndAssEntries = new HashMap<Long, HashSet<Long>>(8);
        HashMap<Long, BigDecimal> entryIdAndAssVerifyQty = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> entryIdAndAssVerifyBaseQty = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject record : coreRecord) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long assBillId = entry.getLong("assbillid");
                Long assBillEntryId = entry.getLong("assbillentryid");
                saloutIds.add(assBillId);
                HashSet<Long> entryIds = (HashSet<Long>)assIdAndAssEntries.get(assBillId);
                if (entryIds == null) {
                    entryIds = new HashSet<Long>(8);
                }
                entryIds.add(assBillEntryId);
                assIdAndAssEntries.put(assBillId, entryIds);
                entryIdAndAssVerifyQty.merge(assBillEntryId, entry.getBigDecimal("assverifyqty"), BigDecimal::add);
                entryIdAndAssVerifyBaseQty.merge(assBillEntryId, entry.getBigDecimal("assverifybaseqty"), BigDecimal::add);
            }
        }
        long uniqueKey = DB.genGlobalLongId();
        commonParam.put((Object)"uniquekey", (Object)uniqueKey);
        commonParam.put((Object)"ids", assIdAndAssEntries);
        commonParam.put((Object)"qty", entryIdAndAssVerifyQty);
        commonParam.put((Object)"baseqty", entryIdAndAssVerifyBaseQty);
        this.disposeWriteOffSalout(commonParam, saloutIds);
    }

    public DynamicObject[] writeBackFinArBills(List<Long> redRecordsForFinArBillIds, List<DynamicObject> redRecords) {
        DynamicObject[] finArBills;
        for (DynamicObject finArBill : finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,amount,unverifyamount,verifystatus,entry.id,entry.e_unverifybaseqty,entry.e_verifybaseqty,entry.e_verifiedqty,entry.e_unverifyqty,entry.e_verifiedamt,entry.e_unverifyamt,sourcebilltype,org.id,asstact.id,currency.amtprecision,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum", (QFilter[])new QFilter[]{new QFilter("id", "in", redRecordsForFinArBillIds)})) {
            BigDecimal amount = finArBill.getBigDecimal("amount");
            BigDecimal unVerifyAmount = finArBill.getBigDecimal("unverifyamount");
            DynamicObjectCollection finArEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject finArEntry : finArEntries) {
                Long entryId = finArEntry.getLong("id");
                BigDecimal unverifyBaseQty = finArEntry.getBigDecimal("e_unverifybaseqty");
                BigDecimal verifyBaseQty = finArEntry.getBigDecimal("e_verifybaseqty");
                BigDecimal unverifyQty = finArEntry.getBigDecimal("e_unverifyqty");
                BigDecimal verifyQty = finArEntry.getBigDecimal("e_verifiedqty");
                BigDecimal unverifyAmt = finArEntry.getBigDecimal("e_unverifyamt");
                BigDecimal verifyAmt = finArEntry.getBigDecimal("e_verifiedamt");
                for (DynamicObject redRecord : redRecords) {
                    DynamicObjectCollection entries = redRecord.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        Long billEntryId = entry.getLong("billentryid");
                        if (!entryId.equals(billEntryId)) continue;
                        unverifyBaseQty = unverifyBaseQty.subtract(entry.getBigDecimal("verifybaseqty"));
                        verifyBaseQty = verifyBaseQty.add(entry.getBigDecimal("verifybaseqty"));
                        unverifyQty = unverifyQty.subtract(entry.getBigDecimal("verifyqty"));
                        verifyQty = verifyQty.add(entry.getBigDecimal("verifyqty"));
                        unverifyAmt = unverifyAmt.subtract(entry.getBigDecimal("verifyamt"));
                        verifyAmt = verifyAmt.add(entry.getBigDecimal("verifyamt"));
                        unVerifyAmount = unVerifyAmount.subtract(entry.getBigDecimal("verifyamt"));
                    }
                }
                finArEntry.set("e_unverifybaseqty", (Object)unverifyBaseQty);
                finArEntry.set("e_verifybaseqty", (Object)verifyBaseQty);
                finArEntry.set("e_unverifyqty", (Object)unverifyQty);
                finArEntry.set("e_verifiedqty", (Object)verifyQty);
                finArEntry.set("e_unverifyamt", (Object)unverifyAmt);
                finArEntry.set("e_verifiedamt", (Object)verifyAmt);
            }
            finArBill.set("unverifyamount", (Object)unVerifyAmount);
            if (amount.compareTo(unVerifyAmount) == 0) {
                finArBill.set("verifystatus", (Object)"unverify");
                continue;
            }
            if (BigDecimal.ZERO.compareTo(unVerifyAmount) == 0) {
                finArBill.set("verifystatus", (Object)"verified");
                continue;
            }
            finArBill.set("verifystatus", (Object)"partverify");
        }
        SaveServiceHelper.save((DynamicObject[])finArBills);
        return finArBills;
    }

    public void writeBackOrderAndContract(List<DynamicObject> coreRecord, DynamicObject[] finArBills) {
        try {
            List<Map<String, Object>> paramList = this.buildArToSalParam(coreRecord, finArBills);
            List<Map<String, Object>> salOrderParamList = paramList.stream().filter(map -> "salorder".equals(map.get("wbtype"))).collect(Collectors.toList());
            List<Map<String, Object>> salContractParamList = paramList.stream().filter(map -> "salcontract".equals(map.get("wbtype"))).collect(Collectors.toList());
            if (salOrderParamList.size() > 0) {
                ArrayList<Map<String, Object>> salOrderParamHasSourceList = new ArrayList<Map<String, Object>>(8);
                for (Map map2 : salOrderParamList) {
                    if (map2.get("sourcebilltype") != null) {
                        map2.remove("sourcebilltype");
                        continue;
                    }
                    salOrderParamHasSourceList.add(map2);
                }
                this.disposeSalOrderService(salOrderParamHasSourceList);
                this.disposeSalContractService(salOrderParamList);
            }
            if (salContractParamList.size() > 0) {
                this.disposeSalContractService(salContractParamList);
            }
        }
        catch (RuntimeException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

