/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.TaxPriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;

@Deprecated
public class BusRedBlueVerifyWriteOffHandle {
    private static final Log logger = LogFactory.getLog(BusRedBlueVerifyWriteOffHandle.class);
    private boolean isAr;

    public void afterWfRecordStrategy(List<DynamicObject> records) {
        logger.info("BusRedBlueVerifyWriteOffHandle.afterWfRecordStrategy start");
        if (records.size() == 0) {
            return;
        }
        this.isAr = this.isAr(records.get(0));
        DynamicObject[] recordArray = BusinessDataServiceHelper.load((Object[])records.stream().map(record -> record.getLong("id")).toArray(Object[]::new), (DynamicObjectType)records.get(0).getDynamicObjectType());
        ArrayList<DynamicObject> verifyRecords = new ArrayList<DynamicObject>(recordArray.length);
        verifyRecords.addAll(Arrays.asList(recordArray));
        logger.info("BusRedBlueVerifyWriteOffHandle.afterWfRecordStrategy reload records size" + records.size());
        DynamicObject[] busBills = this.getNeedPushBusBills(verifyRecords);
        Map<Long, BusEntryParam> busEntryMap = this.getBusEntryParamMap(busBills);
        this.fillAndSaveVerifyRecord(verifyRecords, busEntryMap);
        List<Long> needPushBusBillIds = Arrays.stream(busBills).map(busBill -> busBill.getLong("id")).collect(Collectors.toList());
        this.executeWoff(needPushBusBillIds, verifyRecords);
        logger.info("BusRedBlueVerifyWriteOffHandle.afterWfRecordStrategy end");
    }

    private DynamicObject[] getNeedPushBusBills(List<DynamicObject> records) {
        HashSet<Long> busBilIds = new HashSet<Long>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long mainBillId = entry.getLong("billid");
                long asstBillId = entry.getLong("assbillid");
                busBilIds.add(mainBillId);
                busBilIds.add(asstBillId);
            }
        }
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        return BusinessDataServiceHelper.load((String)busBillEntity, (String)"id,entryid,quotation,exchangerate,currency,basecurrency,e_unitcoefficient,e_measureunit,e_baseunit,e_actunitprice,e_acttaxunitprice", (QFilter[])new QFilter[]{new QFilter("id", "in", busBilIds)});
    }

    private Map<Long, BusEntryParam> getBusEntryParamMap(DynamicObject[] busBills) {
        HashMap<Long, BusEntryParam> busEntryMap = new HashMap<Long, BusEntryParam>(8);
        for (DynamicObject busBill : busBills) {
            DynamicObjectCollection entries = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BusEntryParam param = new BusEntryParam();
                param.exchangerate = busBill.getBigDecimal("exchangerate");
                param.quotation = busBill.getString("quotation");
                DynamicObject currency = busBill.getDynamicObject("currency");
                int scale = currency == null ? 2 : currency.getInt("amtprecision");
                DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
                int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
                param.currencyPrecision = scale;
                param.baseCurrencyPrecision = baseScale;
                param.unitcoefficient = entry.getBigDecimal("e_unitcoefficient");
                param.acttaxunitprice = entry.getBigDecimal("e_acttaxunitprice");
                param.unitPrecision = entry.getDynamicObject("e_measureunit");
                param.baseunitPrecision = entry.getDynamicObject("e_baseunit");
                busEntryMap.put(entry.getLong("id"), param);
            }
        }
        return busEntryMap;
    }

    private void fillAndSaveVerifyRecord(List<DynamicObject> records, Map<Long, BusEntryParam> busEntryMap) {
        for (DynamicObject recordBill : records) {
            DynamicObject payProperty = recordBill.getDynamicObject("payproperty");
            boolean isAmtFlag = payProperty.getBoolean("isbasedonamt");
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (isAmtFlag) {
                    this.fillVerifyRecordByAmt(entry, busEntryMap);
                    continue;
                }
                this.fillVerifyRecordByQty(entry, busEntryMap);
            }
        }
        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private void fillVerifyRecordByAmt(DynamicObject entry, Map<Long, BusEntryParam> busEntryMap) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        BusEntryParam mainParam = busEntryMap.get(entry.getLong("billentryid"));
        BigDecimal mainVerifyQty = new BigDecimal(1);
        entry.set("verifyqty", (Object)mainVerifyQty);
        entry.set("baseqty", (Object)UnitConvertHelper.getBaseunitqty(mainVerifyQty, mainParam.unitcoefficient, mainParam.baseunitPrecision));
        BigDecimal mainAmount = mainVerifyValue.setScale(mainParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("amount", (Object)mainAmount);
        entry.set("localamount", (Object)this.getLocalAmt(mainAmount, mainParam.quotation, mainParam.exchangerate, mainParam.baseCurrencyPrecision));
        BusEntryParam asstParam = busEntryMap.get(entry.getLong("assbillentryid"));
        BigDecimal asstVerifyQty = new BigDecimal(-1);
        entry.set("asstverifyqty", (Object)asstVerifyQty);
        entry.set("asstbaseqty", (Object)UnitConvertHelper.getBaseunitqty(asstVerifyQty, asstParam.unitcoefficient, asstParam.baseunitPrecision));
        BigDecimal asstAmount = asstVerifyValue.setScale(asstParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("asstamount", (Object)asstAmount);
        entry.set("asstlocalamount", (Object)this.getLocalAmt(asstAmount, asstParam.quotation, asstParam.exchangerate, asstParam.baseCurrencyPrecision));
    }

    private void fillVerifyRecordByQty(DynamicObject entry, Map<Long, BusEntryParam> busEntryMap) {
        BigDecimal mainVerifyValue = entry.getBigDecimal("qty");
        BigDecimal asstVerifyValue = entry.getBigDecimal("assqty");
        BusEntryParam mainParam = busEntryMap.get(entry.getLong("billentryid"));
        BigDecimal mainVerifyQty = this.getQtyByUnitPresicion(mainVerifyValue, mainParam.unitPrecision);
        entry.set("verifyqty", (Object)mainVerifyQty);
        entry.set("baseqty", (Object)UnitConvertHelper.getBaseunitqty(mainVerifyQty, mainParam.unitcoefficient, mainParam.baseunitPrecision));
        BigDecimal mainAmount = mainVerifyQty.multiply(mainParam.acttaxunitprice).setScale(mainParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("amount", (Object)mainAmount);
        entry.set("localamount", (Object)this.getLocalAmt(mainAmount, mainParam.quotation, mainParam.exchangerate, mainParam.baseCurrencyPrecision));
        BusEntryParam asstParam = busEntryMap.get(entry.getLong("assbillentryid"));
        BigDecimal asstVerifyQty = this.getQtyByUnitPresicion(asstVerifyValue, asstParam.unitPrecision);
        entry.set("asstverifyqty", (Object)asstVerifyQty);
        entry.set("asstbaseqty", (Object)UnitConvertHelper.getBaseunitqty(asstVerifyQty, asstParam.unitcoefficient, asstParam.baseunitPrecision));
        BigDecimal asstAmount = asstVerifyQty.multiply(asstParam.acttaxunitprice).setScale(asstParam.currencyPrecision, RoundingMode.HALF_UP);
        entry.set("asstamount", (Object)asstAmount);
        entry.set("asstlocalamount", (Object)this.getLocalAmt(asstAmount, asstParam.quotation, asstParam.exchangerate, asstParam.baseCurrencyPrecision));
    }

    private void executeWoff(List<Long> busBillIds, List<DynamicObject> records) {
        DynamicObject[] busWoffBills;
        Map<Long, PushedEntryParam> pushedEntryParamMap = this.getPushedEntryParamMap(records);
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> pushedBusBills = BOTPHelper.push(busBillEntity, busBillEntity, this.isAr ? "697561685841434624" : "712748085842822144", busBillIds);
        for (DynamicObject pushedBusBill : pushedBusBills) {
            DynamicObject payProperty = pushedBusBill.getDynamicObject("payproperty");
            boolean isAmtFlag = payProperty.getBoolean("isbasedonamt");
            DynamicObject[] entries = pushedBusBill.getDynamicObjectCollection("entry");
            Iterator itr = entries.iterator();
            while (itr.hasNext()) {
                DynamicObject entry = (DynamicObject)itr.next();
                long srcEntryId = entry.getLong("e_srcentryid");
                PushedEntryParam pushedEntryParam = pushedEntryParamMap.get(srcEntryId);
                if (pushedEntryParam == null) {
                    itr.remove();
                    continue;
                }
                if (isAmtFlag) {
                    BigDecimal needWoffAmt = pushedEntryParam.entryNeedWoffAmt;
                    this.recalculateEntryByAmt(pushedBusBill, entry, needWoffAmt);
                    continue;
                }
                BigDecimal needWoffQty = pushedEntryParam.entryNeedWoffQty;
                this.recalculateEntryByQty(pushedBusBill, entry, needWoffQty);
            }
            this.recalculateHead(pushedBusBill);
        }
        this.setBusBillNumber(pushedBusBills);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)busBillEntity, (DynamicObject[])pushedBusBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)busBillEntity, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
        for (DynamicObject woffBusBill : busWoffBills = BusinessDataServiceHelper.load((String)busBillEntity, (String)"id,entryid,e_srcentryid,isverifybusiness", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)auditResult.getSuccessPkIds())})) {
            woffBusBill.set("isverifybusiness", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])busWoffBills);
        HashMap<Long, BusWoffBillInfo> srcEntryIdToBusWoffInfo = new HashMap<Long, BusWoffBillInfo>(8);
        for (DynamicObject busWoffBill : busWoffBills) {
            long busWoffBillId = busWoffBill.getLong("id");
            DynamicObjectCollection entries = busWoffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long entryId = entry.getLong("id");
                long srcEntryId = entry.getLong("e_srcentryid");
                BusWoffBillInfo info = new BusWoffBillInfo();
                info.id = busWoffBillId;
                info.entryId = entryId;
                srcEntryIdToBusWoffInfo.put(srcEntryId, info);
            }
        }
        for (DynamicObject record : records) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long mainEntryId = entry.getLong("billentryid");
                long asstEntryId = entry.getLong("assbillentryid");
                BusWoffBillInfo mainWoffBillInfo = (BusWoffBillInfo)srcEntryIdToBusWoffInfo.get(mainEntryId);
                BusWoffBillInfo asstWoffBillInfo = (BusWoffBillInfo)srcEntryIdToBusWoffInfo.get(asstEntryId);
                entry.set("woffbillid", (Object)mainWoffBillInfo.id);
                entry.set("woffbillentryId", (Object)mainWoffBillInfo.entryId);
                entry.set("asstwoffbillid", (Object)asstWoffBillInfo.id);
                entry.set("asstwoffbillentryId", (Object)asstWoffBillInfo.entryId);
            }
        }
        SaveServiceHelper.update((DynamicObject[])records.toArray(new DynamicObject[0]));
    }

    private Map<Long, PushedEntryParam> getPushedEntryParamMap(List<DynamicObject> records) {
        HashMap<Long, PushedEntryParam> entryParamMap = new HashMap<Long, PushedEntryParam>(8);
        for (DynamicObject recordBill : records) {
            DynamicObjectCollection entries = recordBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long mainEntryId = entry.getLong("billentryid");
                long asstEntryId = entry.getLong("assbillentryid");
                PushedEntryParam entryParam = new PushedEntryParam();
                entryParam.entryNeedWoffAmt = entry.getBigDecimal("asstamount");
                entryParam.entryNeedWoffQty = entry.getBigDecimal("asstverifyqty");
                PushedEntryParam mainEntryParam = (PushedEntryParam)entryParamMap.get(mainEntryId);
                if (mainEntryParam == null) {
                    PushedEntryParam entryParamReverse = new PushedEntryParam();
                    entryParamReverse.entryNeedWoffAmt = entryParam.entryNeedWoffAmt.negate();
                    entryParamReverse.entryNeedWoffQty = entryParam.entryNeedWoffQty.negate();
                    entryParamMap.put(mainEntryId, entryParamReverse);
                } else {
                    mainEntryParam.entryNeedWoffAmt = mainEntryParam.entryNeedWoffAmt.add(entryParam.entryNeedWoffAmt.negate());
                    mainEntryParam.entryNeedWoffQty = mainEntryParam.entryNeedWoffQty.add(entryParam.entryNeedWoffQty.negate());
                }
                PushedEntryParam asstEntryParam = (PushedEntryParam)entryParamMap.get(asstEntryId);
                if (asstEntryParam == null) {
                    entryParamMap.put(asstEntryId, entryParam);
                    continue;
                }
                asstEntryParam.entryNeedWoffAmt = asstEntryParam.entryNeedWoffAmt.add(entryParam.entryNeedWoffAmt);
                asstEntryParam.entryNeedWoffQty = asstEntryParam.entryNeedWoffQty.add(entryParam.entryNeedWoffQty);
            }
        }
        return entryParamMap;
    }

    private void recalculateEntryByQty(DynamicObject busBill, DynamicObject entry, BigDecimal needWoffQty) {
        BigDecimal woffBillQty;
        BigDecimal billQty = entry.getBigDecimal("e_quantity");
        if (billQty.compareTo(woffBillQty = needWoffQty.negate()) != 0) {
            AbstractPriceCalculator calculator;
            BigDecimal exchangerate = busBill.getBigDecimal("exchangerate");
            boolean includeTax = busBill.getBoolean("isincludetax");
            DynamicObject currency = busBill.getDynamicObject("currency");
            int scale = currency == null ? 2 : currency.getInt("amtprecision");
            DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
            int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
            String quotation = busBill.getString("quotation");
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            String discountMode = entry.getString("e_discountmode");
            BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
            BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
            BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            if (includeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                calculator = new TaxUnitPriceCalculator(woffBillQty, taxUnitPrice, taxRate, discountMode, discountRate, scale, BigDecimal.ZERO, discountAmt);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                calculator = new UnitPriceCalculator(woffBillQty, unitPrice, taxRate, discountMode, discountRate, scale, BigDecimal.ZERO, discountAmt);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, baseScale, quotation);
            localCalculator.calculate();
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_amount", (Object)localCalculator.getAmount());
            entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set(this.isAr ? "e_recamount" : "e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
            entry.set(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_uninvoicedlocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwoffamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_unwofflocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_quantity", (Object)woffBillQty);
            entry.set("e_uninvoicedqty", (Object)woffBillQty);
            entry.set("e_unwoffqty", (Object)woffBillQty);
            entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(woffBillQty, covertRate, baseUnit));
        }
    }

    private void recalculateEntryByAmt(DynamicObject busBill, DynamicObject entry, BigDecimal needWoffAmt) {
        BigDecimal woffBillAmt;
        BigDecimal billAmt = entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal");
        if (billAmt.compareTo(woffBillAmt = needWoffAmt.negate()) != 0) {
            BigDecimal exchangerate = busBill.getBigDecimal("exchangerate");
            boolean includeTax = busBill.getBoolean("isincludetax");
            DynamicObject currency = busBill.getDynamicObject("currency");
            int scale = currency == null ? 2 : currency.getInt("amtprecision");
            DynamicObject basecurrency = busBill.getDynamicObject("basecurrency");
            int baseScale = basecurrency == null ? 2 : basecurrency.getInt("amtprecision");
            String quotation = busBill.getString("quotation");
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            BigDecimal qty = entry.getBigDecimal("e_quantity");
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if (!entry.getBoolean("e_ispresent")) {
                qty = new BigDecimal(woffBillAmt.compareTo(BigDecimal.ZERO));
            }
            String discountMode = "NULL";
            BigDecimal discountRate = BigDecimal.ZERO;
            AbstractPriceCalculator calculator = includeTax ? new TaxPriceTaxTotalCalculator(qty, woffBillAmt, taxRate, discountMode, discountRate, scale) : new PriceTaxTotalCalculator(qty, woffBillAmt, taxRate, discountMode, discountRate, scale);
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangerate, baseScale, quotation);
            localCalculator.calculate();
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_amount", (Object)localCalculator.getAmount());
            entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set(this.isAr ? "e_recamount" : "e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
            entry.set(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_uninvoicedlocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_unwoffamt", (Object)localCalculator.getPricetaxtotal());
            entry.set("e_unwofflocamt", (Object)localCalculator.getPricetaxtotallocal());
            entry.set("e_quantity", (Object)qty);
            entry.set("e_uninvoicedqty", (Object)qty);
            entry.set("e_unwoffqty", (Object)qty);
            entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(qty, covertRate, baseUnit));
            entry.set("e_discountmode", (Object)discountMode);
            entry.set("e_discountrate", (Object)discountRate);
        }
    }

    private void recalculateHead(DynamicObject pushedBusBill) {
        BigDecimal taxTotal = BigDecimal.ZERO;
        BigDecimal taxLocalTotal = BigDecimal.ZERO;
        BigDecimal amountTotal = BigDecimal.ZERO;
        BigDecimal localAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxLocalTotal = BigDecimal.ZERO;
        DynamicObjectCollection entries = pushedBusBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            taxTotal = taxTotal.add(entry.getBigDecimal("e_tax"));
            taxLocalTotal = taxLocalTotal.add(entry.getBigDecimal("e_taxlocalamt"));
            amountTotal = amountTotal.add(entry.getBigDecimal("e_amount"));
            localAmtTotal = localAmtTotal.add(entry.getBigDecimal("e_localamt"));
            priceTaxTotal = priceTaxTotal.add(entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal"));
            priceTaxLocalTotal = priceTaxLocalTotal.add(entry.getBigDecimal(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase"));
        }
        pushedBusBill.set("tax", (Object)taxTotal);
        pushedBusBill.set("taxlocamt", (Object)taxLocalTotal);
        pushedBusBill.set("amount", (Object)amountTotal);
        pushedBusBill.set("localamt", (Object)localAmtTotal);
        pushedBusBill.set(this.isAr ? "recamount" : "pricetaxtotal", (Object)priceTaxTotal);
        pushedBusBill.set(this.isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)priceTaxLocalTotal);
        pushedBusBill.set("uninvoicedamt", (Object)priceTaxTotal);
        pushedBusBill.set("uninvoicedlocamt", (Object)priceTaxLocalTotal);
        pushedBusBill.set("unwoffamt", (Object)priceTaxTotal);
        pushedBusBill.set("unwofflocamt", (Object)priceTaxLocalTotal);
    }

    private void setBusBillNumber(List<DynamicObject> trgBills) {
        String busBillEntity = this.isAr ? "ar_busbill" : "ap_busbill";
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.forEach((key, targetBills) -> {
            int size = targetBills.size();
            Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)busBillEntity, (DynamicObject)((DynamicObject)targetBills.get(0)), (String)key, (int)size);
            if (ObjectUtils.isEmpty((Object[])numbers) || numbers.length < size) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u7f16\u7801\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u3002", (String)"FinWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", numbers[i]);
                ++i;
            }
        });
    }

    private BigDecimal getQtyByUnitPresicion(BigDecimal verifyValue, DynamicObject unit) {
        BigDecimal result;
        if (unit == null) {
            result = verifyValue.setScale(10, 4);
        } else {
            int precisionaccount = unit.getInt("precisionaccount");
            int precision = unit.getInt("precision");
            result = precisionaccount == 2 ? verifyValue.setScale(precision, 1) : (precisionaccount == 3 ? verifyValue.setScale(precision, 0) : verifyValue.setScale(precision, 4));
        }
        return result;
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchangerate, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchangerate, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchangerate).setScale(precision, RoundingMode.HALF_UP);
    }

    private boolean isAr(DynamicObject recordBill) {
        String verifyRecordEntity = recordBill.getDataEntityType().getName();
        return !"ap_bus_verifyrecord".equals(verifyRecordEntity);
    }

    static class BusWoffBillInfo {
        Long id;
        Long entryId;

        BusWoffBillInfo() {
        }
    }

    static class PushedEntryParam {
        BigDecimal entryNeedWoffAmt;
        BigDecimal entryNeedWoffQty;

        PushedEntryParam() {
        }
    }

    static class BusEntryParam {
        String quotation;
        BigDecimal exchangerate;
        BigDecimal unitcoefficient;
        DynamicObject unitPrecision;
        DynamicObject baseunitPrecision;
        BigDecimal acttaxunitprice;
        int currencyPrecision;
        int baseCurrencyPrecision;

        BusEntryParam() {
        }
    }
}

