/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.woff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class WoffHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BusEntryInfo> getPreWoffBills(String busEntityKey, List<Long> pks, List<Long> entryPks) {
        ArrayList<BusEntryInfo> preWoffBills = new ArrayList<BusEntryInfo>(64);
        QFilter fixQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        fixQf.and(new QFilter("isadjust", "=", (Object)"1"));
        fixQf.and(new QFilter("writeoffbusiness", "=", (Object)Boolean.FALSE));
        QFilter qFilter = new QFilter("entry.e_srcbillid", "in", pks);
        qFilter.and(new QFilter("entry.e_srcentryid", "in", entryPks));
        boolean isAr = "ar_busbill".equals(busEntityKey);
        String recAmountKey = isAr ? "entry.e_recamount" : "entry.e_pricetaxtotal";
        String recLocAmtKey = isAr ? "entry.e_reclocalamt" : "entry.e_pricetaxtotalbase";
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"woff.getPreWoffBillList", (String)busEntityKey, (String)("entry.id, entry.e_srcbillid, entry.e_srcentryid, entry.e_quantity fqty, entry.e_tax ftax, entry.e_taxlocalamt ftaxlocamt, entry.e_amount famt, entry.e_localamt flocamt, " + recAmountKey + " frecamt," + recLocAmtKey + " freclocamt"), (QFilter[])new QFilter[]{fixQf, qFilter}, null);
            for (Row data : ds) {
                BusEntryInfo weInfo = new BusEntryInfo();
                weInfo.setEntryPk(data.getLong("entry.id"));
                weInfo.setSrcPk(data.getLong("entry.e_srcbillid"));
                weInfo.setSrcEntryPk(data.getLong("entry.e_srcentryid"));
                weInfo.setQuantity(data.getBigDecimal("fqty"));
                weInfo.setTax(data.getBigDecimal("ftax"));
                weInfo.setTaxLocAmt(data.getBigDecimal("ftaxlocamt"));
                weInfo.setAmount(data.getBigDecimal("famt"));
                weInfo.setLocalAmt(data.getBigDecimal("flocamt"));
                weInfo.setRecAmount(data.getBigDecimal("frecamt"));
                weInfo.setRecLocAmt(data.getBigDecimal("freclocamt"));
                preWoffBills.add(weInfo);
            }
        }
        return preWoffBills;
    }

    public static List<BusEntryInfo> calculate(List<BusEntryInfo> busList, List<BusEntryInfo> preWoffBills, List<BusEntryInfo> lastGenWoffs, boolean isAmt) {
        List<BusEntryInfo> busBills = busList;
        if (!ObjectUtils.isEmpty(preWoffBills)) {
            WoffHelper.subtract(busBills, preWoffBills, isAmt);
        }
        if (!ObjectUtils.isEmpty(lastGenWoffs)) {
            WoffHelper.subtract(busBills, lastGenWoffs, isAmt);
        }
        return busBills;
    }

    private static void subtract(List<BusEntryInfo> busBills, List<BusEntryInfo> woffBills, boolean isAmt) {
        for (BusEntryInfo beInfo : busBills) {
            Long busPk = beInfo.getPk();
            Long busEntryPk = beInfo.getEntryPk();
            for (BusEntryInfo woff : woffBills) {
                if (!busPk.equals(woff.getSrcPk()) || !busEntryPk.equals(woff.getSrcEntryPk())) continue;
                if (beInfo.getQuantity().compareTo(BigDecimal.ZERO) < 0) {
                    if (!isAmt) {
                        beInfo.setQuantity(beInfo.getQuantity().add(woff.getQuantity().abs()));
                    }
                    beInfo.setTax(beInfo.getTax().add(woff.getTax().abs()));
                    beInfo.setTaxLocAmt(beInfo.getTaxLocAmt().add(woff.getTaxLocAmt().abs()));
                    beInfo.setAmount(beInfo.getAmount().add(woff.getAmount().abs()));
                    beInfo.setLocalAmt(beInfo.getLocalAmt().add(woff.getLocalAmt().abs()));
                    beInfo.setRecAmount(beInfo.getRecAmount().add(woff.getRecAmount().abs()));
                    beInfo.setRecLocAmt(beInfo.getRecLocAmt().add(woff.getRecLocAmt().abs()));
                    continue;
                }
                if (!isAmt) {
                    beInfo.setQuantity(beInfo.getQuantity().subtract(woff.getQuantity().abs()));
                }
                beInfo.setTax(beInfo.getTax().subtract(woff.getTax().abs()));
                beInfo.setTaxLocAmt(beInfo.getTaxLocAmt().subtract(woff.getTaxLocAmt().abs()));
                beInfo.setAmount(beInfo.getAmount().subtract(woff.getAmount().abs()));
                beInfo.setLocalAmt(beInfo.getLocalAmt().subtract(woff.getLocalAmt().abs()));
                beInfo.setRecAmount(beInfo.getRecAmount().subtract(woff.getRecAmount().abs()));
                beInfo.setRecLocAmt(beInfo.getRecLocAmt().subtract(woff.getRecLocAmt().abs()));
            }
        }
    }

    public static void setTrgEntry(DynamicObject trgEntry, BusEntryInfo srcBusEntry, String quotation, BigDecimal rate, boolean includeTax, int precision, int localprecision, boolean isAr, boolean isAmt, boolean isSelfWoff) {
        boolean different;
        BigDecimal quantity = srcBusEntry.getQuantity().negate();
        if (quantity == null) {
            quantity = BigDecimal.ZERO;
        }
        BigDecimal unwofftaxamt = srcBusEntry.getRecAmount().negate();
        BigDecimal unWoffAmt = srcBusEntry.getAmount().negate();
        AbstractPriceCalculator calculator = null;
        BigDecimal taxRate = trgEntry.getBigDecimal("e_taxrate");
        String discountMode = trgEntry.getString("e_discountmode");
        BigDecimal discountRate = trgEntry.getBigDecimal("e_discountrate");
        BigDecimal discountAmt = trgEntry.getBigDecimal("e_discountamount");
        if (isAmt) {
            if (!trgEntry.getBoolean("e_ispresent") && unwofftaxamt.compareTo(BigDecimal.ZERO) != 0) {
                quantity = new BigDecimal(unwofftaxamt.compareTo(BigDecimal.ZERO));
            }
            discountMode = "NULL";
            trgEntry.set("e_discountmode", (Object)discountMode);
            discountRate = BigDecimal.ZERO;
            trgEntry.set("e_discountrate", (Object)discountRate);
            calculator = new PriceTotalCalculator(quantity, unWoffAmt, taxRate, discountMode, discountRate, precision);
        } else {
            calculator = includeTax ? new TaxUnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_taxunitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt) : new UnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_unitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        trgEntry.set("e_quantity", (Object)quantity);
        BigDecimal covertRate = trgEntry.getBigDecimal("e_unitcoefficient");
        DynamicObject material = trgEntry.getDynamicObject("e_material");
        DynamicObject measureUnit = trgEntry.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = trgEntry.getDynamicObject("e_baseunit");
        if (EmptyUtils.isEmpty(covertRate)) {
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    trgEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                covertRate = UnitConvertHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
            } else {
                covertRate = BigDecimal.ONE;
            }
            trgEntry.set("e_unitcoefficient", (Object)covertRate);
        }
        trgEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
        localCalculator.calculate();
        trgEntry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
        BigDecimal tax = localCalculator.getTax();
        BigDecimal taxlocalamt = localCalculator.getTaxlocal();
        BigDecimal amount = localCalculator.getAmount();
        BigDecimal localamt = localCalculator.getAmountlocal();
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        BigDecimal unwofflocamt = srcBusEntry.getRecLocAmt().negate();
        BigDecimal unwofftax = srcBusEntry.getTax().negate();
        BigDecimal unwofftaxlocalamt = srcBusEntry.getTaxLocAmt().negate();
        BigDecimal unwoffamount = srcBusEntry.getAmount().negate();
        BigDecimal unwofflocalamt = srcBusEntry.getLocalAmt().negate();
        boolean bl = different = !isSelfWoff && srcBusEntry.isWoff();
        if (different) {
            boolean bl2 = different = recamount.compareTo(unwofftaxamt) != 0 || reclocalamt.compareTo(unwofflocamt) != 0 || tax.compareTo(unwofftax) != 0 || taxlocalamt.compareTo(unwofftaxlocalamt) != 0 || amount.compareTo(unwoffamount) != 0 || localamt.compareTo(unwofflocalamt) != 0;
        }
        if (different) {
            tax = unwofftax;
            taxlocalamt = unwofftaxlocalamt;
            amount = unwoffamount;
            localamt = unwofflocalamt;
            recamount = unwofftaxamt;
            reclocalamt = unwofflocamt;
        }
        trgEntry.set("e_tax", (Object)tax);
        trgEntry.set("e_taxlocalamt", (Object)taxlocalamt);
        trgEntry.set("e_amount", (Object)amount);
        trgEntry.set("e_localamt", (Object)localamt);
        trgEntry.set(isAr ? "e_recamount" : "e_pricetaxtotal", (Object)recamount);
        trgEntry.set(isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)reclocalamt);
        trgEntry.set("e_uninvoicedqty", (Object)quantity);
        trgEntry.set("e_uninvoicedamt", (Object)recamount);
        trgEntry.set("e_uninvoicedlocamt", (Object)reclocalamt);
        trgEntry.set("e_unwoffqty", (Object)quantity);
        trgEntry.set("e_unwoffamt", (Object)recamount);
        trgEntry.set("e_unwofflocamt", (Object)reclocalamt);
        trgEntry.set("e_unwoffnotaxamt", (Object)amount);
        trgEntry.set("e_unwoffnotaxlocamt", (Object)localamt);
        trgEntry.set("e_unwofftax", (Object)tax);
        trgEntry.set("e_unwofftaxlocal", (Object)taxlocalamt);
        trgEntry.set("e_uninvnotaxamt", (Object)amount);
        trgEntry.set("e_uninvnotaxlocalamt", (Object)localamt);
        if (isAmt) {
            trgEntry.set("e_unitprice", (Object)localCalculator.getUnitprice());
            trgEntry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
            trgEntry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
            trgEntry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
        }
    }

    public static void executeWriteOffBillWoff(List<DynamicObject> billList) {
        DynamicObject[] subAdjustBusBillListInDB;
        boolean ar = "ar_finarbill".equals(billList.get(0).getDataEntityType().getName());
        String busBillEntityName = ar ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> adjustBusBillList = WoffHelper.rebuildAdjustBusBillList(billList, busBillEntityName);
        if (EmptyUtils.isEmpty(adjustBusBillList)) {
            return;
        }
        List<DynamicObject> subAdjustBusBillList = WoffHelper.generatePushAdjustBusBillList(billList, adjustBusBillList, busBillEntityName, "ar_busbill".equals(busBillEntityName));
        SaveServiceHelper.update((DynamicObject[])adjustBusBillList.toArray(new DynamicObject[0]));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)busBillEntityName, (DynamicObject[])subAdjustBusBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        try {
            OperationHelper.assertResult(operationResult);
        }
        catch (Exception e) {
            WoffHelper.joinErrorMsg(e.getMessage());
        }
        for (DynamicObject newBusBill : subAdjustBusBillListInDB = BusinessDataServiceHelper.load((String)busBillEntityName, (String)"isselfwoff", (QFilter[])new QFilter[]{new QFilter("id", "in", subAdjustBusBillList.stream().map(bus -> bus.getLong("id")).collect(Collectors.toSet()))})) {
            newBusBill.set("isselfwoff", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.update((DynamicObject[])subAdjustBusBillListInDB);
    }

    private static void joinErrorMsg(String message) {
        throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u6682\u4f30\u51b2\u56de\u5355%s", (String)"WoffHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{message}));
    }

    private static Map<Long, Long> getAdjustBusBillIdTofinBillIdMap(List<DynamicObject> billList, List<DynamicObject> adjustBusBillList) {
        HashMap adjustBusBillIdToSrcFinBillIdMap = new HashMap(16);
        adjustBusBillList.stream().forEach(entity -> adjustBusBillIdToSrcFinBillIdMap.put(entity.getLong("id"), entity.getLong("srcfinbillid")));
        HashMap sourceBillIdToFinBillIdMap = new HashMap(16);
        billList.stream().forEach(entity -> sourceBillIdToFinBillIdMap.put(entity.getLong("sourcebillid"), entity.getLong("id")));
        HashMap<Long, Long> adjustBusBillIdTofinBillIdMap = new HashMap<Long, Long>(16);
        adjustBusBillIdToSrcFinBillIdMap.keySet().stream().forEach(key -> {
            long srcFinBillId = (Long)adjustBusBillIdToSrcFinBillIdMap.get(key);
            long finBillId = (Long)sourceBillIdToFinBillIdMap.get(srcFinBillId);
            adjustBusBillIdTofinBillIdMap.put((Long)key, finBillId);
        });
        return adjustBusBillIdTofinBillIdMap;
    }

    private static List<DynamicObject> generatePushAdjustBusBillList(List<DynamicObject> billList, List<DynamicObject> adjustBusBillList, String adjustEntityName, boolean arBill) {
        List<Long> busBillIds = adjustBusBillList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        String ruleId = arBill ? "697561685841434624" : "712748085842822144";
        List<DynamicObject> subWriteOffBusBillList = BOTPHelper.push(adjustEntityName, adjustEntityName, ruleId, busBillIds);
        Map<Long, Long> adjustBusBillIdToFinBillIdMap = WoffHelper.getAdjustBusBillIdTofinBillIdMap(billList, adjustBusBillList);
        HashMap busBillIdToAdjustBusBillMap = new HashMap(16);
        adjustBusBillList.forEach(entity -> {
            String billNo = entity.getString("billno");
            busBillIdToAdjustBusBillMap.put(entity.getLong("id"), String.format(ResManager.loadKDString((String)"\u51b2\u9500%s", (String)"BusBillWriteBackFromFinBillAuditService_0", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
        });
        Map writeOffBillIdMap = billList.stream().collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        subWriteOffBusBillList.forEach(entity -> {
            entity.set("isselfwoff", (Object)Boolean.TRUE);
            long sourceBillId = entity.getLong("sourcebillid");
            long srcFinBillId = adjustBusBillIdToFinBillIdMap.getOrDefault(sourceBillId, 0L);
            if (srcFinBillId > 0L) {
                entity.set("srcfinbillid", (Object)srcFinBillId);
                entity.set("writeoffbusiness", (Object)Boolean.TRUE);
                entity.set("remark", busBillIdToAdjustBusBillMap.get(sourceBillId));
                Date date = EmptyUtils.isEmpty(writeOffBillIdMap.get(srcFinBillId)) ? entity.getDate("bizdate") : ((DynamicObject)writeOffBillIdMap.get(srcFinBillId)).getDate("bizdate");
                entity.set("bizdate", (Object)date);
            }
        });
        return subWriteOffBusBillList;
    }

    private static List<DynamicObject> rebuildAdjustBusBillList(List<DynamicObject> billList, String busBillEntityName) {
        List<DynamicObject> adjustBusBillList = WoffHelper.listAdjustBusBillByFinBill(billList, busBillEntityName);
        adjustBusBillList.forEach(entity -> {
            entity.set("writeoffbusiness", (Object)Boolean.TRUE);
            entity.getDynamicObjectCollection("entry").forEach(rowEntity -> rowEntity.set("e_iswriteoff", (Object)Boolean.TRUE));
        });
        return adjustBusBillList;
    }

    private static List<DynamicObject> listAdjustBusBillByFinBill(List<DynamicObject> billList, String busBillEntityName) {
        List finBillIds = billList.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        return Arrays.asList(BusinessDataServiceHelper.load((String)busBillEntityName, (String)"id,billno,srcfinbillid,writeoffbusiness,entry.e_iswriteoff", (QFilter[])new QFilter("srcfinbillid", "in", finBillIds).and(new QFilter("isadjust", "=", (Object)Boolean.TRUE)).toArray()));
    }

    public static void executeWriteOffBillUnWoff(List<DynamicObject> billList) {
        boolean ar = "ar_finarbill".equals(billList.get(0).getDataEntityType().getName());
        String busBillEntityName = ar ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> upstreamAdjustBusBillList = WoffHelper.rebuildUpstreamAdjustBusBill(billList, busBillEntityName);
        if (EmptyUtils.isEmpty(upstreamAdjustBusBillList)) {
            return;
        }
        SaveServiceHelper.update((DynamicObject[])upstreamAdjustBusBillList.toArray(new DynamicObject[upstreamAdjustBusBillList.size()]));
    }

    private static List<DynamicObject> rebuildUpstreamAdjustBusBill(List<DynamicObject> billList, String busBillEntityName) {
        DynamicObject[] upstreamAdjustBusBillList;
        List finSourceBillIds = billList.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        for (DynamicObject entity2 : upstreamAdjustBusBillList = BusinessDataServiceHelper.load((String)busBillEntityName, (String)"id,writeoffbusiness,entry.e_iswriteoff", (QFilter[])new QFilter("srcfinbillid", "in", finSourceBillIds).and(new QFilter("isadjust", "=", (Object)Boolean.TRUE)).toArray())) {
            entity2.set("writeoffbusiness", (Object)Boolean.FALSE);
            entity2.getDynamicObjectCollection("entry").forEach(rowEntity -> rowEntity.set("e_iswriteoff", (Object)Boolean.FALSE));
        }
        return Arrays.asList(upstreamAdjustBusBillList);
    }
}

