/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.woff.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.woff.AbstractWriteOff;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class SrcBillSameImpl
extends AbstractWriteOff {
    private String sourceBillType;

    public SrcBillSameImpl(boolean isAr, String sourceBillType, boolean isAmt) {
        super(isAr ? "ar_busbill" : "ap_busbill", isAr);
        this.sourceBillType = sourceBillType;
        this.isAmt = isAmt;
    }

    @Override
    public List<BusEntryInfo> getBusBills(DynamicObject finBill) {
        List<BusEntryInfo> busList = null;
        long finPk = (Long)finBill.getPkValue();
        long orgId = (Long)finBill.getDynamicObject("org").getPkValue();
        Map linkBills = BFTrackerServiceHelper.findSourceBills((String)(this.isAr ? "ar_finarbill" : "ap_finapbill"), (Long[])new Long[]{finPk});
        if (EmptyUtils.isEmpty(linkBills.get(this.sourceBillType))) {
            return null;
        }
        ArrayList imSrcPks = new ArrayList((Collection)linkBills.get(this.sourceBillType));
        String sql4bus = "id, entry.id, e_quantity, e_uninvoicedqty, e_srcbillid, e_srcentryid, e_iswriteoff, e_tax, e_taxlocalamt, e_amount, e_localamt, " + this.recAmountKey + "," + this.recLocAmtKey;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entry.e_srcbillid", "in", imSrcPks));
        QFilter amtFilter = new QFilter("payproperty.isbasedonamt", "=", (Object)this.isAmt);
        QFilter wFilter = new QFilter("entry.e_iswriteoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)sql4bus, (QFilter[])new QFilter[]{qFilter, wFilter, amtFilter});
        busList = this.getBusEntries(finBill, busBills);
        return busList;
    }

    @Override
    public List<BusEntryInfo> getSrcBusEntries(DynamicObject finBill, List<BusEntryInfo> calcBusBills) {
        DynamicObjectCollection finEntrys = finBill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
        String quantityKey = this.isAr ? "e_quantity" : "quantity";
        for (DynamicObject finEntry : finEntrys) {
            Long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
            Long e_srcEntryId = finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid");
            BigDecimal finInvoiceQty = finEntry.getBigDecimal(quantityKey);
            BigDecimal amount = finEntry.getBigDecimal("e_amount");
            for (BusEntryInfo beInfo : calcBusBills) {
                boolean overflow;
                if (!e_srcId.equals(beInfo.getSrcPk()) || !e_srcEntryId.equals(beInfo.getSrcEntryPk())) continue;
                BigDecimal unInvoicedQty = beInfo.getQuantity();
                BigDecimal unInvoicedAmt = beInfo.getRecAmount();
                if (!this.isAmt) {
                    boolean bl = overflow = unInvoicedQty.abs().compareTo(finInvoiceQty.abs()) <= 0;
                    if (overflow) {
                        beInfo.setIsWoff(true);
                        continue;
                    }
                    beInfo.setQuantity(finInvoiceQty);
                    continue;
                }
                boolean bl = overflow = unInvoicedAmt.abs().compareTo(amount.abs()) <= 0;
                if (overflow) {
                    beInfo.setIsWoff(true);
                    continue;
                }
                beInfo.setAmount(amount);
            }
        }
        return calcBusBills;
    }

    private List<BusEntryInfo> getBusEntries(DynamicObject finBill, DynamicObject[] busBills) {
        ArrayList<BusEntryInfo> busList = new ArrayList<BusEntryInfo>();
        DynamicObjectCollection finEntrys = finBill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
        for (DynamicObject finEntry : finEntrys) {
            long e_srcId = finEntry.getLong(this.isAr ? "e_srcid" : "e_sourcebillid");
            long e_srcEntryId = finEntry.getLong(this.isAr ? "e_srcentryid" : "e_sourcebillentryid");
            block1: for (DynamicObject busBill : busBills) {
                for (DynamicObject busEntry : busBill.getDynamicObjectCollection("entry")) {
                    if (busEntry.getLong("e_srcbillid") != e_srcId || busEntry.getLong("e_srcentryid") != e_srcEntryId) continue;
                    BusEntryInfo beInfo = new BusEntryInfo();
                    beInfo.setPk(busBill.getLong("id"));
                    beInfo.setEntryPk(busEntry.getLong("id"));
                    beInfo.setIsAmt(this.isAmt);
                    beInfo.setSrcPk(e_srcId);
                    beInfo.setSrcEntryPk(e_srcEntryId);
                    beInfo.setQuantity(busEntry.getBigDecimal("e_quantity"));
                    beInfo.setTax(busEntry.getBigDecimal("e_tax"));
                    beInfo.setTaxLocAmt(busEntry.getBigDecimal("e_taxlocalamt"));
                    beInfo.setAmount(busEntry.getBigDecimal("e_amount"));
                    beInfo.setLocalAmt(busEntry.getBigDecimal("e_localamt"));
                    beInfo.setRecAmount(busEntry.getBigDecimal(this.recAmountKey));
                    beInfo.setRecLocAmt(busEntry.getBigDecimal(this.recLocAmtKey));
                    busList.add(beInfo);
                    continue block1;
                }
            }
        }
        return busList;
    }

    @Override
    public boolean setIsSelfwoff() {
        return true;
    }
}

