/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.base;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.writeback.base.DefaultWriteBackCallBack;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.IEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.WriteBackCallBack;

public abstract class AbstractEntryWriteBacker
implements IEntryWriteBacker {
    private static final Log logger = LogFactory.getLog(AbstractEntryWriteBacker.class);
    protected String entryPriceTaxTotalKey;
    protected String entryUnWriteBackKey;
    protected String entryWriteBackKey;
    protected String currencyKey;

    @Override
    public void init(EntryWriteBackParam param) {
        this.entryPriceTaxTotalKey = param.getEntryPriceTaxTotalKey();
        this.entryUnWriteBackKey = param.getEntryUnWriteBackKey();
        this.entryWriteBackKey = param.getEntryWriteBackKey();
        this.currencyKey = param.getCurrencyKey();
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        this.directWriteBack(finBill, entries, writeBackAmt, new DefaultWriteBackCallBack());
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt, WriteBackCallBack writeBackCallBack) {
        BigDecimal entryPriceTaxTotalAmt;
        BigDecimal writeBackedTotalAmt = this.sumWriteBackedTotalAmt(entries);
        BigDecimal needWriteBackAmt = writeBackedTotalAmt.add(writeBackAmt);
        if (needWriteBackAmt.compareTo(entryPriceTaxTotalAmt = this.sumEntryPriceTaxTotalAmt(entries)) == 0) {
            for (DynamicObject entry : entries) {
                this.setFinished(entry);
                writeBackCallBack.writeBackFinish(entry);
            }
        } else {
            for (DynamicObject entry : entries) {
                this.setInitial(entry);
                writeBackCallBack.writeBackInitial(entry);
            }
            this.doWriteBack(finBill, entries, entryPriceTaxTotalAmt, needWriteBackAmt, writeBackCallBack);
        }
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        this.inverseWriteBack(finBill, entries, writeBackAmt, new DefaultWriteBackCallBack());
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt, WriteBackCallBack writeBackCallBack) {
        BigDecimal writeBackedTotalAmt = this.sumWriteBackedTotalAmt(entries);
        BigDecimal needWriteBackAmt = writeBackedTotalAmt.subtract(writeBackAmt);
        if (needWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) {
            for (DynamicObject entry : entries) {
                this.setInitial(entry);
                writeBackCallBack.writeBackInitial(entry);
            }
        } else {
            for (DynamicObject entry : entries) {
                this.setInitial(entry);
                writeBackCallBack.writeBackInitial(entry);
            }
            BigDecimal entryPriceTaxTotalAmt = this.sumEntryPriceTaxTotalAmt(entries);
            this.doWriteBack(finBill, entries, entryPriceTaxTotalAmt, needWriteBackAmt, writeBackCallBack);
        }
    }

    protected abstract void doWriteBack(DynamicObject var1, DynamicObjectCollection var2, BigDecimal var3, BigDecimal var4, WriteBackCallBack var5);

    private BigDecimal sumWriteBackedTotalAmt(DynamicObjectCollection writeBackEntries) {
        BigDecimal writeBackedTotalAmt = BigDecimal.ZERO;
        for (DynamicObject writeBackEntry : writeBackEntries) {
            BigDecimal writeBackedAmt = writeBackEntry.getBigDecimal(this.entryWriteBackKey);
            writeBackedTotalAmt = writeBackedTotalAmt.add(writeBackedAmt);
        }
        return writeBackedTotalAmt;
    }

    private BigDecimal sumEntryPriceTaxTotalAmt(DynamicObjectCollection writeBackEntries) {
        BigDecimal entryPriceTaxTotalAmt = BigDecimal.ZERO;
        for (DynamicObject writeBackEntry : writeBackEntries) {
            BigDecimal entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
            entryPriceTaxTotalAmt = entryPriceTaxTotalAmt.add(entryPriceTaxAmt);
        }
        return entryPriceTaxTotalAmt;
    }

    protected void setInitial(DynamicObject writeBackEntry) {
        writeBackEntry.set(this.entryUnWriteBackKey, (Object)writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey));
        writeBackEntry.set(this.entryWriteBackKey, (Object)BigDecimal.ZERO);
    }

    protected void setFinished(DynamicObject writeBackEntry) {
        writeBackEntry.set(this.entryUnWriteBackKey, (Object)BigDecimal.ZERO);
        writeBackEntry.set(this.entryWriteBackKey, (Object)writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey));
    }

    protected void increaseAmount(DynamicObject entry, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = entry.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.add(amount);
        entry.set(amountKey, (Object)result);
    }

    protected void reduceAmount(DynamicObject entry, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = entry.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.subtract(amount);
        entry.set(amountKey, (Object)result);
    }

    protected int getPrecision(DynamicObject finBill) {
        DynamicObject currency = finBill.getDynamicObject(this.currencyKey);
        return currency == null ? 2 : currency.getInt("amtprecision");
    }
}

