/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.IProportionCalculator;

public class ProportionCalculator
implements IProportionCalculator {
    private String entryPriceTaxTotalKey;
    private String currencyKey;

    @Override
    public void init(EntryCalculateParam param) {
        this.entryPriceTaxTotalKey = param.getEntryPriceTaxTotalKey();
        this.currencyKey = param.getCurrencyKey();
    }

    @Override
    public Map<Long, BigDecimal> loadEntryWriteBackAmtMap(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        ArrayList<DynamicObject> noZeroEntries = new ArrayList<DynamicObject>(entries.size());
        for (DynamicObject entry : entries) {
            if (entry.getBigDecimal(this.entryPriceTaxTotalKey).compareTo(BigDecimal.ZERO) == 0) continue;
            noZeroEntries.add(entry);
        }
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(noZeroEntries.size());
        BigDecimal entryPriceTaxTotalAmt = this.sumEntryPriceTaxTotalAmt(noZeroEntries);
        if (writeBackAmt.compareTo(entryPriceTaxTotalAmt) == 0) {
            for (DynamicObject noZeroEntry : noZeroEntries) {
                BigDecimal entryPriceTaxAmt = noZeroEntry.getBigDecimal(this.entryPriceTaxTotalKey);
                result.put(noZeroEntry.getLong("id"), entryPriceTaxAmt);
            }
        } else {
            int scale = this.getPrecision(finBill);
            BigDecimal remainWriteBackAmt = writeBackAmt;
            int size = noZeroEntries.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal entryPriceTaxAmt;
                DynamicObject writeBackEntry = (DynamicObject)noZeroEntries.get(i);
                if (i == size - 1) {
                    entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
                    BigDecimal endWriteBackedNoWriteBackAmt = BigDecimal.ZERO;
                    if (remainWriteBackAmt.signum() == entryPriceTaxAmt.signum()) {
                        if (remainWriteBackAmt.abs().compareTo(entryPriceTaxAmt.abs()) > 0) {
                            result.put(writeBackEntry.getLong("id"), entryPriceTaxAmt);
                            endWriteBackedNoWriteBackAmt = remainWriteBackAmt.subtract(entryPriceTaxAmt);
                        } else {
                            result.put(writeBackEntry.getLong("id"), remainWriteBackAmt);
                        }
                    } else {
                        endWriteBackedNoWriteBackAmt = remainWriteBackAmt;
                    }
                    if (endWriteBackedNoWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.writeBackBottomToTop(noZeroEntries, endWriteBackedNoWriteBackAmt, result);
                    continue;
                }
                entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
                BigDecimal proportion = entryPriceTaxAmt.divide(entryPriceTaxTotalAmt, 10, RoundingMode.DOWN);
                BigDecimal curWriteBackAmt = writeBackAmt.multiply(proportion).setScale(scale, RoundingMode.DOWN);
                result.put(writeBackEntry.getLong("id"), curWriteBackAmt);
                remainWriteBackAmt = remainWriteBackAmt.subtract(curWriteBackAmt);
            }
        }
        return result;
    }

    private void writeBackBottomToTop(List<DynamicObject> writeBackEntries, BigDecimal remainNoWriteBackAmt, Map<Long, BigDecimal> result) {
        for (int index = writeBackEntries.size() - 2; index >= 0; --index) {
            DynamicObject writeBackEntry = writeBackEntries.get(index);
            long entryId = writeBackEntry.getLong("id");
            BigDecimal entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
            if (remainNoWriteBackAmt.signum() != entryPriceTaxAmt.signum()) continue;
            BigDecimal beforeWriteBackAmt = result.get(entryId);
            if (beforeWriteBackAmt == null) {
                if (remainNoWriteBackAmt.abs().compareTo(entryPriceTaxAmt.abs()) > 0) {
                    result.put(entryId, entryPriceTaxAmt);
                    remainNoWriteBackAmt = remainNoWriteBackAmt.subtract(entryPriceTaxAmt);
                } else {
                    result.put(entryId, remainNoWriteBackAmt);
                    remainNoWriteBackAmt = BigDecimal.ZERO;
                }
            } else {
                BigDecimal allowWriteBackAmt = entryPriceTaxAmt.subtract(beforeWriteBackAmt);
                if (remainNoWriteBackAmt.abs().compareTo(allowWriteBackAmt.abs()) > 0) {
                    result.put(entryId, entryPriceTaxAmt);
                    remainNoWriteBackAmt = remainNoWriteBackAmt.subtract(allowWriteBackAmt);
                } else {
                    result.put(entryId, beforeWriteBackAmt.add(remainNoWriteBackAmt));
                    remainNoWriteBackAmt = BigDecimal.ZERO;
                }
            }
            if (remainNoWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    private BigDecimal sumEntryPriceTaxTotalAmt(List<DynamicObject> writeBackEntries) {
        BigDecimal entryPriceTaxTotalAmt = BigDecimal.ZERO;
        for (DynamicObject writeBackEntry : writeBackEntries) {
            BigDecimal entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
            entryPriceTaxTotalAmt = entryPriceTaxTotalAmt.add(entryPriceTaxAmt);
        }
        return entryPriceTaxTotalAmt;
    }

    private int getPrecision(DynamicObject finBill) {
        DynamicObject currency = finBill.getDynamicObject(this.currencyKey);
        return currency == null ? 2 : currency.getInt("amtprecision");
    }
}

