/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.writeback.base.AbstractEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.WriteBackCallBack;

public class ProportionEntryWriteBacker
extends AbstractEntryWriteBacker {
    protected String entryFixLockedKey;
    protected String entryFixedKey;

    @Override
    public void init(EntryWriteBackParam param) {
        super.init(param);
        this.entryFixLockedKey = param.getEntryFixLockedKey();
        this.entryFixedKey = param.getEntryFixedKey();
    }

    @Override
    protected void doWriteBack(DynamicObject finBill, DynamicObjectCollection writeBackEntries, BigDecimal entryPriceTaxTotalAmt, BigDecimal needWriteBackAmt, WriteBackCallBack writeBackCallBack) {
        ArrayList<DynamicObject> noZeroEntries = new ArrayList<DynamicObject>(writeBackEntries.size());
        for (DynamicObject entry : writeBackEntries) {
            if (entry.getBigDecimal(this.entryPriceTaxTotalKey).compareTo(BigDecimal.ZERO) == 0) continue;
            noZeroEntries.add(entry);
        }
        for (DynamicObject writeBackEntry : noZeroEntries) {
            needWriteBackAmt = needWriteBackAmt.subtract(writeBackEntry.getBigDecimal(this.entryFixedKey));
        }
        int scale = this.getPrecision(finBill);
        BigDecimal remainWriteBackAmt = needWriteBackAmt;
        BigDecimal remainNoWriteBackAmt = BigDecimal.ZERO;
        int size = noZeroEntries.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal entryPriceTaxAmt;
            DynamicObject writeBackEntry = (DynamicObject)noZeroEntries.get(i);
            if (i == size - 1) {
                entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
                BigDecimal entryUnWriteBackAmt = entryPriceTaxAmt.subtract(writeBackEntry.getBigDecimal(this.entryFixLockedKey));
                BigDecimal endWriteBackedNoWriteBackAmt = BigDecimal.ZERO;
                if (remainWriteBackAmt.signum() == entryPriceTaxAmt.signum()) {
                    if (remainWriteBackAmt.abs().compareTo(entryUnWriteBackAmt.abs()) > 0) {
                        this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, entryUnWriteBackAmt);
                        this.increaseAmount(writeBackEntry, this.entryWriteBackKey, entryUnWriteBackAmt);
                        endWriteBackedNoWriteBackAmt = remainWriteBackAmt.subtract(entryUnWriteBackAmt);
                    } else {
                        this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, remainWriteBackAmt);
                        this.increaseAmount(writeBackEntry, this.entryWriteBackKey, remainWriteBackAmt);
                    }
                } else {
                    endWriteBackedNoWriteBackAmt = remainWriteBackAmt;
                }
                if (endWriteBackedNoWriteBackAmt.compareTo(BigDecimal.ZERO) != 0) {
                    this.writeBackBottomToTop(finBill, noZeroEntries, endWriteBackedNoWriteBackAmt, writeBackCallBack);
                }
            } else {
                entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
                BigDecimal proportion = entryPriceTaxAmt.divide(entryPriceTaxTotalAmt, 10, RoundingMode.DOWN);
                BigDecimal proporWriteBackAmt = needWriteBackAmt.multiply(proportion).setScale(scale, RoundingMode.DOWN);
                BigDecimal curWriteBackAmt = remainNoWriteBackAmt.add(proporWriteBackAmt);
                if (curWriteBackAmt.signum() == entryPriceTaxAmt.signum()) {
                    BigDecimal entryUnWriteBackAmt = entryPriceTaxAmt.subtract(writeBackEntry.getBigDecimal(this.entryFixLockedKey));
                    if (curWriteBackAmt.abs().compareTo(entryUnWriteBackAmt.abs()) > 0) {
                        this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, entryUnWriteBackAmt);
                        this.increaseAmount(writeBackEntry, this.entryWriteBackKey, entryUnWriteBackAmt);
                        remainNoWriteBackAmt = curWriteBackAmt.subtract(entryUnWriteBackAmt);
                        remainWriteBackAmt = remainWriteBackAmt.subtract(entryUnWriteBackAmt);
                    } else {
                        this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, curWriteBackAmt);
                        this.increaseAmount(writeBackEntry, this.entryWriteBackKey, curWriteBackAmt);
                        remainNoWriteBackAmt = BigDecimal.ZERO;
                        remainWriteBackAmt = remainWriteBackAmt.subtract(curWriteBackAmt);
                    }
                }
            }
            this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, writeBackEntry.getBigDecimal(this.entryFixedKey));
            this.increaseAmount(writeBackEntry, this.entryWriteBackKey, writeBackEntry.getBigDecimal(this.entryFixedKey));
            if (writeBackEntry.getBigDecimal(this.entryUnWriteBackKey).compareTo(BigDecimal.ZERO) == 0) {
                writeBackCallBack.writeBackFinish(writeBackEntry);
                continue;
            }
            writeBackCallBack.writeBacking(finBill, writeBackEntry);
        }
    }

    private void writeBackBottomToTop(DynamicObject finBill, List<DynamicObject> writeBackEntries, BigDecimal remainNoWriteBackAmt, WriteBackCallBack writeBackCallBack) {
        for (int index = writeBackEntries.size() - 2; index >= 0; --index) {
            DynamicObject writeBackEntry = writeBackEntries.get(index);
            BigDecimal entryPriceTaxAmt = writeBackEntry.getBigDecimal(this.entryPriceTaxTotalKey);
            BigDecimal entryUnWriteBackAmt = entryPriceTaxAmt.subtract(writeBackEntry.getBigDecimal(this.entryFixLockedKey)).subtract(writeBackEntry.getBigDecimal(this.entryWriteBackKey));
            if (remainNoWriteBackAmt.signum() == entryPriceTaxAmt.signum()) {
                if (remainNoWriteBackAmt.abs().compareTo(entryUnWriteBackAmt.abs()) > 0) {
                    this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, entryUnWriteBackAmt);
                    this.increaseAmount(writeBackEntry, this.entryWriteBackKey, entryUnWriteBackAmt);
                    remainNoWriteBackAmt = remainNoWriteBackAmt.subtract(entryUnWriteBackAmt);
                } else {
                    this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, remainNoWriteBackAmt);
                    this.increaseAmount(writeBackEntry, this.entryWriteBackKey, remainNoWriteBackAmt);
                    remainNoWriteBackAmt = BigDecimal.ZERO;
                }
            }
            this.reduceAmount(writeBackEntry, this.entryUnWriteBackKey, writeBackEntry.getBigDecimal(this.entryFixedKey));
            this.increaseAmount(writeBackEntry, this.entryWriteBackKey, writeBackEntry.getBigDecimal(this.entryFixedKey));
            if (writeBackEntry.getBigDecimal(this.entryUnWriteBackKey).compareTo(BigDecimal.ZERO) == 0) {
                writeBackCallBack.writeBackFinish(writeBackEntry);
            } else {
                writeBackCallBack.writeBacking(finBill, writeBackEntry);
            }
            if (remainNoWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }
}

