/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.fin.ApMaterialEntryDisposer;
import kd.fi.arapcommon.service.fin.ApPlanEntryDisposer;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class FinApLockWBServiceHelper {
    private static final Log logger = LogFactory.getLog(FinApLockWBServiceHelper.class);

    public static void directWriteBack(Set<Long> finApBillIds, Map<Long, DisposerInfo> disposerInfoMap) {
        FinApLockWBServiceHelper.writeBack(finApBillIds, disposerInfoMap, true);
    }

    public static void inverseWriteBack(Set<Long> finApBillIds, Map<Long, DisposerInfo> disposerInfoMap) {
        FinApLockWBServiceHelper.writeBack(finApBillIds, disposerInfoMap, false);
    }

    private static void writeBack(Set<Long> finApBillIds, Map<Long, DisposerInfo> disposerInfoMap, boolean isDirect) {
        Long orgId;
        DynamicObject finBill;
        List<String> disposeSelectors = FinApBillHandleHelper.getLockWBSelector();
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", disposeSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finApBillIds.toArray())});
        logger.info("FinApLockWBServiceHelper.writeBack load bill size : " + apBills.length + ",isDirect:" + isDirect);
        if (apBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> apBillOldMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> apBillNewMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject apBill : apBills) {
            boolean bl = SettleVersionServiceHelper.isOldVersion(apBill);
            if (bl) {
                apBillOldMap.put(apBill.getLong("id"), apBill);
                continue;
            }
            apBillNewMap.put(apBill.getLong("id"), apBill);
        }
        Set<Long> orgIds = Arrays.stream(apBills).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Integer> settleParamMap = ArApHelper.batchGetApSettleParam(orgIds);
        if (apBillOldMap.size() > 0) {
            logger.info("FinApLockWBServiceHelper.writeBack olddata");
            HashMap<Long, BigDecimal> planEntryWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
            ApMaterialEntryDisposer detailEntryDisposer = new ApMaterialEntryDisposer();
            ApPlanEntryDisposer apPlanEntryDisposer = new ApPlanEntryDisposer();
            for (Map.Entry<Long, DisposerInfo> entry : disposerInfoMap.entrySet()) {
                Long sourceId;
                DisposerInfo disposerInfo = entry.getValue();
                BigDecimal disposeAmt = disposerInfo.getDisposeAmt();
                if (disposeAmt.compareTo(BigDecimal.ZERO) == 0 || (finBill = (DynamicObject)apBillOldMap.get(sourceId = disposerInfo.getSourceId())) == null) continue;
                orgId = finBill.getLong("org.id");
                if (settleParamMap.get(orgId) == 1) {
                    planEntryWriteBackAmtMap.merge(sourceId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    continue;
                }
                if (isDirect) {
                    detailEntryDisposer.saveDispose(finBill, disposeAmt);
                    continue;
                }
                detailEntryDisposer.deleteDispose(finBill, disposeAmt);
            }
            for (Map.Entry<Long, DisposerInfo> entry : planEntryWriteBackAmtMap.entrySet()) {
                if (isDirect) {
                    apPlanEntryDisposer.saveDispose((DynamicObject)apBillOldMap.get(entry.getKey()), (BigDecimal)((Object)entry.getValue()));
                    continue;
                }
                apPlanEntryDisposer.deleteDispose((DynamicObject)apBillOldMap.get(entry.getKey()), (BigDecimal)((Object)entry.getValue()));
            }
            SaveServiceHelper.save((DynamicObject[])apBillOldMap.values().toArray(new DynamicObject[0]));
        }
        if (apBillNewMap.size() > 0) {
            logger.info("FinApLockWBServiceHelper.writeBack newdata");
            HashMap<Long, BigDecimal> sourceEntryIdToWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
            for (Map.Entry entry : disposerInfoMap.entrySet()) {
                DisposerInfo disposerInfo = (DisposerInfo)entry.getValue();
                BigDecimal bigDecimal = disposerInfo.getDisposeAmt();
                if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
                Long sourceId = disposerInfo.getSourceId();
                Long sourceEntryId = disposerInfo.getSourceEntryId();
                DynamicObject finBill2 = (DynamicObject)apBillNewMap.get(sourceId);
                if (finBill2 == null) continue;
                sourceEntryIdToWriteBackAmtMap.merge(sourceEntryId, bigDecimal, (a, b) -> b.add((BigDecimal)a));
            }
            HashMap billToDimensionToNeedWriteBackAmtMap = new HashMap(8);
            HashMap hashMap = new HashMap(8);
            for (Map.Entry entry : apBillNewMap.entrySet()) {
                Object planEntry32;
                long dimensionId;
                BigDecimal writeBackAmt;
                DynamicObject finBill3 = (DynamicObject)entry.getValue();
                HashMap<Long, BigDecimal> dimensionToNeedWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
                billToDimensionToNeedWriteBackAmtMap.put(finBill3.getLong("id"), dimensionToNeedWriteBackAmtMap);
                HashMap<Long, List> needWriteBackEntriesByDimension = new HashMap<Long, List>(8);
                hashMap.put(finBill3.getLong("id"), needWriteBackEntriesByDimension);
                Long orgId2 = finBill3.getLong("org.id");
                if (settleParamMap.get(orgId2) == 1) {
                    Object detailEntry22;
                    DynamicObjectCollection detailEntries = finBill3.getDynamicObjectCollection("detailentry");
                    for (Object detailEntry22 : detailEntries) {
                        long entryId = detailEntry22.getLong("id");
                        writeBackAmt = (BigDecimal)sourceEntryIdToWriteBackAmtMap.get(entryId);
                        if (writeBackAmt == null || writeBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        long dimensionId2 = detailEntry22.getLong("e_splitdimensionid");
                        dimensionToNeedWriteBackAmtMap.merge(dimensionId2, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                    Iterator planEntries = finBill3.getDynamicObjectCollection("planentity");
                    detailEntry22 = planEntries.iterator();
                    while (detailEntry22.hasNext()) {
                        DynamicObject planEntry2 = (DynamicObject)detailEntry22.next();
                        dimensionId = planEntry2.getLong("p_splitdimensionid");
                        if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                        List writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                        writeBackEntries.add(planEntry2);
                        needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
                    }
                    continue;
                }
                DynamicObjectCollection planEntries = finBill3.getDynamicObjectCollection("planentity");
                for (Object planEntry32 : planEntries) {
                    long entryId = planEntry32.getLong("id");
                    writeBackAmt = (BigDecimal)sourceEntryIdToWriteBackAmtMap.get(entryId);
                    if (writeBackAmt == null || writeBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    long dimensionId3 = planEntry32.getLong("p_splitdimensionid");
                    dimensionToNeedWriteBackAmtMap.merge(dimensionId3, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
                }
                DynamicObjectCollection detailEntries = finBill3.getDynamicObjectCollection("detailentry");
                planEntry32 = detailEntries.iterator();
                while (planEntry32.hasNext()) {
                    DynamicObject detailEntry = (DynamicObject)planEntry32.next();
                    dimensionId = detailEntry.getLong("e_splitdimensionid");
                    if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                    List writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                    writeBackEntries.add(detailEntry);
                    needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
                }
            }
            IFinEntryWriteBacker detailEntryLockWriteBacker = WriteBackerFactory.getDetailEntryLockWriteBacker("ap_finapbill");
            IFinEntryWriteBacker iFinEntryWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ap_finapbill");
            for (Map.Entry writeBackInfo : billToDimensionToNeedWriteBackAmtMap.entrySet()) {
                Long finBillId = (Long)writeBackInfo.getKey();
                finBill = (DynamicObject)apBillNewMap.get(finBillId);
                orgId = finBill.getLong("org.id");
                Map dimensionToNeedWriteBackAmtMap = (Map)writeBackInfo.getValue();
                Map dimensionToNeedWriteBackEntriesMap = (Map)hashMap.get(finBillId);
                for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                    List needWriteBackEntries;
                    Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                    BigDecimal writeBackAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                    if (writeBackAmt.compareTo(BigDecimal.ZERO) == 0 || (needWriteBackEntries = (List)dimensionToNeedWriteBackEntriesMap.get(dimensionId)).size() == 0) continue;
                    DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                    needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                    if (settleParamMap.get(orgId) == 1) {
                        if (isDirect) {
                            iFinEntryWriteBacker.directWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                            continue;
                        }
                        iFinEntryWriteBacker.inverseWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                        continue;
                    }
                    if (isDirect) {
                        detailEntryLockWriteBacker.directWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                        continue;
                    }
                    detailEntryLockWriteBacker.inverseWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                }
            }
            SaveServiceHelper.save((DynamicObject[])apBillNewMap.values().toArray(new DynamicObject[0]));
        }
    }
}

