/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.IEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.ProportionEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class DetailEntryLockWriteBacker
implements IFinEntryWriteBacker {
    private final IEntryWriteBacker writeBacker;
    private final BillModel billModel;

    public DetailEntryLockWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.writeBacker = new ProportionEntryWriteBacker();
        EntryWriteBackParam param = new EntryWriteBackParam();
        param.setEntryPriceTaxTotalKey(this.billModel.E_PRICETAXTOTAL);
        param.setEntryUnWriteBackKey(this.billModel.E_UNLOCKAMT);
        param.setEntryWriteBackKey(this.billModel.E_LOCKEDAMT);
        param.setEntryFixLockedKey(this.billModel.E_FIXLOCKEDAMT);
        param.setEntryFixedKey(this.billModel.E_FIXLOCKEDAMT);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.writeBacker.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.directWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection detailEntries, BigDecimal writeBackAmt) {
        this.writeBacker.directWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.inverseWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection detailEntries, BigDecimal writeBackAmt) {
        this.writeBacker.inverseWriteBack(finBill, detailEntries, writeBackAmt);
    }
}

