/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.IEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.ProportionEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.WriteBackCallBack;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class DetailEntrySettleWriteBacker
implements IFinEntryWriteBacker {
    private final IEntryWriteBacker writeBacker;
    private final BillModel billModel;

    public DetailEntrySettleWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.writeBacker = new ProportionEntryWriteBacker();
        EntryWriteBackParam param = new EntryWriteBackParam();
        param.setEntryPriceTaxTotalKey(this.billModel.E_PRICETAXTOTAL);
        param.setEntryUnWriteBackKey(this.billModel.E_UNSETTLEAMT);
        param.setEntryWriteBackKey(this.billModel.E_SETTLEDAMT);
        param.setEntryFixLockedKey(this.billModel.E_FIXLOCKEDAMT);
        param.setEntryFixedKey(this.billModel.E_FIXSETTLEEDAMT);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.writeBacker.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.directWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection detailEntries, BigDecimal writeBackAmt) {
        this.writeBacker.directWriteBack(finBill, detailEntries, writeBackAmt, new SettleWriteBackCallBack());
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.inverseWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection detailEntries, BigDecimal writeBackAmt) {
        this.writeBacker.inverseWriteBack(finBill, detailEntries, writeBackAmt, new SettleWriteBackCallBack());
    }

    class SettleWriteBackCallBack
    implements WriteBackCallBack {
        SettleWriteBackCallBack() {
        }

        @Override
        public void writeBackInitial(DynamicObject writeBackEntry) {
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_UNSETTLELOCALAMT, (Object)writeBackEntry.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_PRICETAXTOTALLOC));
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_SETTLEDLOCALAMT, (Object)BigDecimal.ZERO);
        }

        @Override
        public void writeBackFinish(DynamicObject writeBackEntry) {
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_SETTLEDLOCALAMT, (Object)writeBackEntry.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_PRICETAXTOTALLOC));
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_UNSETTLELOCALAMT, (Object)BigDecimal.ZERO);
        }

        @Override
        public void writeBacking(DynamicObject finBill, DynamicObject writeBackEntry) {
            BigDecimal localAmt = this.getLocalAmt(finBill, writeBackEntry.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_SETTLEDAMT));
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_SETTLEDLOCALAMT, (Object)writeBackEntry.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_SETTLEDLOCALAMT).add(localAmt));
            writeBackEntry.set(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_UNSETTLELOCALAMT, (Object)writeBackEntry.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.E_UNSETTLELOCALAMT).subtract(localAmt));
        }

        private BigDecimal getLocalAmt(DynamicObject finBill, BigDecimal srcAmt) {
            int basePrecision = this.getPrecision(finBill);
            BigDecimal exchange = finBill.getBigDecimal(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.HEAD_EXCHANGERATE);
            if ("1".equals(finBill.getString(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.HEAD_QUOTATION))) {
                return srcAmt.divide(exchange, basePrecision, RoundingMode.HALF_UP);
            }
            return srcAmt.multiply(exchange).setScale(basePrecision, RoundingMode.HALF_UP);
        }

        private int getPrecision(DynamicObject finBill) {
            DynamicObject baseCurrency = finBill.getDynamicObject(((DetailEntrySettleWriteBacker)DetailEntrySettleWriteBacker.this).billModel.HEAD_BASECURRENCY);
            return baseCurrency == null ? 2 : baseCurrency.getInt("amtprecision");
        }
    }
}

