/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.IEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.OrdinalEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class PlanEntryLockWriteBacker
implements IFinEntryWriteBacker {
    private final IEntryWriteBacker writeBacker;
    private final BillModel billModel;

    public PlanEntryLockWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.writeBacker = new OrdinalEntryWriteBacker();
        EntryWriteBackParam param = new EntryWriteBackParam();
        param.setEntryPriceTaxTotalKey(this.billModel.P_PLANPRICETAX);
        param.setEntryUnWriteBackKey(this.billModel.P_UNPLANLOCKAMT);
        param.setEntryWriteBackKey(this.billModel.P_PLANLOCKEDAMT);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.writeBacker.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.directWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection planEntries, BigDecimal writeBackAmt) {
        this.writeBacker.directWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.inverseWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection planEntries, BigDecimal writeBackAmt) {
        this.writeBacker.inverseWriteBack(finBill, planEntries, writeBackAmt);
    }
}

