/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.IProportionCalculator;
import kd.fi.arapcommon.service.writeback.base.ProportionCalculator;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class PremiumPlanEntryProportionLockWriteBacker
implements IFinEntryWriteBacker {
    private final IProportionCalculator calculator;
    private final BillModel billModel;

    public PremiumPlanEntryProportionLockWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.calculator = new ProportionCalculator();
        EntryCalculateParam param = new EntryCalculateParam();
        param.setEntryPriceTaxTotalKey(this.billModel.P_PLANPRICETAX);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.calculator.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.directWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        Map<Long, BigDecimal> entryIdToWriteBackAmt = this.calculator.loadEntryWriteBackAmtMap(finBill, entries, writeBackAmt);
        for (DynamicObject planEntry : entries) {
            BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(planEntry.getLong("id"));
            if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            planEntry.set(this.billModel.P_UNPLANLOCKAMT, (Object)planEntry.getBigDecimal(this.billModel.P_UNPLANLOCKAMT).subtract(entryWriteBackAmt));
            planEntry.set(this.billModel.P_PLANLOCKEDAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANLOCKEDAMT).add(entryWriteBackAmt));
        }
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.inverseWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        Map<Long, BigDecimal> entryIdToWriteBackAmt = this.calculator.loadEntryWriteBackAmtMap(finBill, entries, writeBackAmt);
        for (DynamicObject planEntry : entries) {
            BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(planEntry.getLong("id"));
            if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            planEntry.set(this.billModel.P_UNPLANLOCKAMT, (Object)planEntry.getBigDecimal(this.billModel.P_UNPLANLOCKAMT).add(entryWriteBackAmt));
            planEntry.set(this.billModel.P_PLANLOCKEDAMT, (Object)planEntry.getBigDecimal(this.billModel.P_PLANLOCKEDAMT).subtract(entryWriteBackAmt));
        }
    }
}

