/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.service.fin.ApPlanEntryDisposer;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinApLockWBServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class ApLiquWBFinBillServiceHelper {
    private static final Log logger = LogFactory.getLog(ApLiquWBFinBillServiceHelper.class);

    @Deprecated
    public static void directWriteBack(Set<Long> finApBillIds, DynamicObject[] liquidationBills) {
        ApLiquWBFinBillServiceHelper.writeBack(finApBillIds, liquidationBills, true);
    }

    @Deprecated
    public static void inverseWriteBack(Set<Long> finApBillIds, DynamicObject[] liquidationBills) {
        ApLiquWBFinBillServiceHelper.writeBack(finApBillIds, liquidationBills, false);
    }

    @Deprecated
    private static void writeBack(Set<Long> finApBillIds, DynamicObject[] liquidationBills, boolean isDirect) {
        ApLiquWBFinBillServiceHelper.writeBack(liquidationBills, isDirect);
    }

    public static void directWriteBack(DynamicObject[] liquidationBills) {
        ApLiquWBFinBillServiceHelper.writeBack(liquidationBills, true);
    }

    public static void inverseWriteBack(DynamicObject[] liquidationBills) {
        ApLiquWBFinBillServiceHelper.writeBack(liquidationBills, false);
    }

    private static void writeBack(DynamicObject[] liquidationBills, boolean isDirect) {
        DynamicObjectCollection entry;
        HashSet<Long> sourceIds;
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime("BIZ_V6.0.001_DataUpgrade");
        upgradeTime = upgradeTime == null ? DateUtils.parseDate("2023-10-01", "yyyy-MM-dd") : upgradeTime;
        ArrayList<DynamicObject> updateBeforeBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> updateAfterBills = new ArrayList<DynamicObject>(liquidationBills.length);
        for (DynamicObject liquidation : liquidationBills) {
            Date billCreateTime = liquidation.getDate("createtime");
            if (billCreateTime.compareTo(upgradeTime) <= 0) {
                updateBeforeBills.add(liquidation);
                continue;
            }
            updateAfterBills.add(liquidation);
        }
        if (updateBeforeBills.size() > 0) {
            logger.info("BIZ_V6.0.001 version execute history invalid writeback");
            sourceIds = new HashSet<Long>(64);
            HashMap<Long, BigDecimal> disposeTotalMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject liquidation : updateBeforeBills) {
                entry = liquidation.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entry) {
                    long sourceBillId = row.getLong("sourcebillid");
                    BigDecimal unsettleamt = row.getBigDecimal("unsettleamt");
                    BigDecimal disposeAmount = (BigDecimal)disposeTotalMap.get(sourceBillId);
                    disposeAmount = disposeAmount == null ? unsettleamt : disposeAmount.add(unsettleamt);
                    disposeTotalMap.put(sourceBillId, disposeAmount);
                    sourceIds.add(sourceBillId);
                }
            }
            String selector = String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector());
            DynamicObject[] srcFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", sourceIds)});
            ApPlanEntryDisposer planEntryDisposer = new ApPlanEntryDisposer();
            for (DynamicObject srcFinApBill : srcFinApBills) {
                BigDecimal disposeAmt = (BigDecimal)disposeTotalMap.get(srcFinApBill.getLong("id"));
                if (disposeAmt == null) continue;
                if (isDirect) {
                    planEntryDisposer.saveDispose(srcFinApBill, disposeAmt);
                    continue;
                }
                planEntryDisposer.deleteDispose(srcFinApBill, disposeAmt);
            }
            SaveServiceHelper.save((DynamicObject[])srcFinApBills);
        }
        if (updateAfterBills.size() > 0) {
            logger.info("BIZ_V6.0.001 version after execute writeback");
            sourceIds = new HashSet(64);
            HashMap<Long, DisposerInfo> liquEntryToAmtMap = new HashMap<Long, DisposerInfo>(8);
            for (DynamicObject liquidation : updateAfterBills) {
                entry = liquidation.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : entry) {
                    long entryId = row.getLong("id");
                    long sourceBillId = row.getLong("sourcebillid");
                    long sourceEntryId = row.getLong("sourceentryid");
                    BigDecimal disposeAmt = row.getBigDecimal("unsettleamt");
                    liquEntryToAmtMap.put(entryId, new DisposerInfo(sourceBillId, sourceEntryId, disposeAmt));
                    sourceIds.add(sourceBillId);
                }
            }
            if (isDirect) {
                FinApLockWBServiceHelper.directWriteBack(sourceIds, liquEntryToAmtMap);
            } else {
                FinApLockWBServiceHelper.inverseWriteBack(sourceIds, liquEntryToAmtMap);
            }
        }
    }
}

