/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeoff;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.ARSettleStatusEnum;
import kd.fi.arapcommon.service.writeoff.SubWriteOffDisposer;

class ARHeadAndEntryDisposer
extends SubWriteOffDisposer {
    private static final String selectFields = "unverifyamount, unsettleamount, unsettlelocalamt, exchangerate, verifystatus, settlestatus, hadwrittenoff, settleamount, settlelocalamt, isperiod, isbaddebt, e_unverifyqty, e_verifiedqty, e_unverifyamt, e_verifiedamt, e_lockedamt, e_unlockamt, e_settledamt, e_unsettleamt, e_settledlocalamt, e_unsettlelocalamt,entry";

    public ARHeadAndEntryDisposer(boolean isForward) {
        super(isForward);
    }

    @Override
    public String getSelectField() {
        return selectFields;
    }

    @Override
    public void execute() {
        this.dispose(this.mainBill, true);
        this.dispose(this.asstBill, false);
    }

    @Override
    protected void dispose(DynamicObject bill, boolean isMain) {
        int precision;
        List<DynamicObject> reserveList;
        String settleStatus;
        if (!this.isForward && !isMain) {
            return;
        }
        BigDecimal headUnsettleAmt = zero;
        BigDecimal headUnsettleLocalAmt = zero;
        BigDecimal headsettleAmt = zero;
        BigDecimal headsettleLocalAmt = zero;
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        boolean hadWrittenOff = false;
        if (this.isForward) {
            for (DynamicObject entry : entries) {
                this.forwardSetValue(entry, "e_lockedamt", "e_unlockamt");
                this.forwardSetValue(entry, "e_settledamt", "e_unsettleamt");
                this.forwardSetValue(entry, "e_settledlocalamt", "e_unsettlelocalamt");
                headsettleAmt = headsettleAmt.add(entry.getBigDecimal("e_settledamt"));
                headsettleLocalAmt = headsettleLocalAmt.add(entry.getBigDecimal("e_settledlocalamt"));
            }
            hadWrittenOff = isMain;
            settleStatus = ARSettleStatusEnum.SETTLED.getValue();
        } else {
            for (DynamicObject entry : entries) {
                this.reverseSetValue(entry, "e_lockedamt", "e_unlockamt");
                BigDecimal e_unsettleAmt = this.reverseSetValue(entry, "e_settledamt", "e_unsettleamt");
                headUnsettleAmt = headUnsettleAmt.add(e_unsettleAmt);
                BigDecimal e_unsettleLocalAmt = this.reverseSetValue(entry, "e_settledlocalamt", "e_unsettlelocalamt");
                headUnsettleLocalAmt = headUnsettleLocalAmt.add(e_unsettleLocalAmt);
            }
            settleStatus = ARSettleStatusEnum.UNSETTLE.getValue();
        }
        bill.set("hadwrittenoff", (Object)hadWrittenOff);
        bill.set("settlestatus", (Object)settleStatus);
        bill.set("unsettleamount", (Object)headUnsettleAmt);
        bill.set("unsettlelocalamt", (Object)headUnsettleLocalAmt);
        bill.set("settleamount", (Object)headsettleAmt);
        bill.set("settlelocalamt", (Object)headsettleLocalAmt);
        if (isMain && bill.getBoolean("isperiod") && bill.getBoolean("isbaddebt") && !(reserveList = this.disposeReserveBill(bill, precision = bill.getBigDecimal("exchangerate").scale())).isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])reserveList.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> disposeReserveBill(DynamicObject bill, int precision) {
        ArrayList<DynamicObject> reserveList = new ArrayList<DynamicObject>(64);
        QFilter qFilter = new QFilter("sourcebillid", "=", bill.getPkValue());
        DynamicObject[] initReserves = BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)"id, sourcebillid, unsettleamt, unsettlelocalamt, baddebtreserveamt, referencerate", (QFilter[])new QFilter[]{qFilter});
        BigDecimal unSettleLocAmt = bill.getBigDecimal("unsettlelocalamt");
        for (DynamicObject initReserve : initReserves) {
            initReserve.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamount"));
            initReserve.set("unsettlelocalamt", (Object)unSettleLocAmt);
            if (unSettleLocAmt.compareTo(BigDecimal.ZERO) != 0) {
                initReserve.set("referencerate", (Object)initReserve.getBigDecimal("baddebtreserveamt").divide(initReserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
            } else {
                initReserve.set("referencerate", (Object)BigDecimal.ZERO);
            }
            reserveList.add(initReserve);
        }
        return reserveList;
    }
}

