/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeoff;

import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.writeoff.APHeadAndEntryDisposer;
import kd.fi.arapcommon.service.writeoff.ARHeadAndEntryDisposer;
import kd.fi.arapcommon.service.writeoff.AbstractWriteOffDisposer;
import kd.fi.arapcommon.service.writeoff.IWriteOffDisposer;
import kd.fi.arapcommon.service.writeoff.SubWriteOffDisposer;

public class WriteOffDisposer
extends AbstractWriteOffDisposer {
    protected SubWriteOffDisposer HAEDisposer;
    private long mainBillID;
    private long asstBillID;
    private String entityName;
    private boolean isForward;

    public WriteOffDisposer(String entityName, long mainBillID, long asstBillID, boolean isForward) {
        this.mainBillID = mainBillID;
        this.asstBillID = asstBillID;
        this.entityName = entityName;
        this.isForward = isForward;
        this.initInnerDisposer();
    }

    public IWriteOffDisposer build() {
        QFilter mainFilter = new QFilter("id", "=", (Object)this.mainBillID);
        QFilter asstFilter = new QFilter("id", "=", (Object)this.asstBillID);
        QFilter[] filters = new QFilter[]{mainFilter};
        String selectFields = this.getSelectField();
        DynamicObject mainBill = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)selectFields, (QFilter[])filters);
        filters[0] = asstFilter;
        DynamicObject asstBill = BusinessDataServiceHelper.loadSingle((String)this.entityName, (String)selectFields, (QFilter[])filters);
        this.setMainBill(mainBill);
        this.setAsstBill(asstBill);
        return this;
    }

    @Override
    public String getSelectField() {
        return this.HAEDisposer.getSelectField();
    }

    @Override
    public void execute() {
        DynamicObject[] saveData;
        this.HAEDisposer.execute();
        if (this.isForward) {
            saveData = new DynamicObject[]{this.HAEDisposer.getMainBill(), this.HAEDisposer.getAsstBill()};
        } else {
            saveData = new DynamicObject[]{this.HAEDisposer.getMainBill()};
            this.deleteTgtBill();
        }
        SaveServiceHelper.save((DynamicObject[])saveData);
    }

    @Override
    public void setMainBill(DynamicObject mainBill) {
        this.HAEDisposer.setMainBill(mainBill);
    }

    @Override
    public void setAsstBill(DynamicObject asstBill) {
        this.HAEDisposer.setAsstBill(asstBill);
    }

    private void initInnerDisposer() {
        switch (this.entityName) {
            case "ar_finarbill": {
                this.HAEDisposer = new ARHeadAndEntryDisposer(this.isForward);
                break;
            }
            case "ap_finapbill": {
                this.HAEDisposer = new APHeadAndEntryDisposer(this.isForward);
                break;
            }
            default: {
                throw new RuntimeException("unsupported entity name:" + this.entityName);
            }
        }
    }

    private void deleteTgtBill() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"nocheckdelete", (String)this.entityName, (Object[])new Object[]{this.asstBillID}, (OperateOption)option);
        OperationHelper.assertResult(result);
    }

    private void deleteBotpRelation() {
        HashMap<String, Object> relation = new HashMap<String, Object>();
        relation.put("sourceBillId", this.mainBillID);
        relation.put("id", this.asstBillID);
        try (TXHandle tx = TX.requiresNew();){
            BOTPHelper.deleteRation(relation);
        }
    }
}

