/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.util.DateUtils;

public class CoordinateApAdjustTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CoordinateApAdjustTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("CoordinateApAdjustTask is execute\u3002");
        log.info("CoordinateApAdjustTask execute map is : " + map);
        Object days = map.get("days");
        Date farthestBizDate = ObjectUtils.isEmpty((Object)days) ? DateUtils.getLastDay(new Date(), 30) : DateUtils.getLastDay(new Date(), Integer.parseInt(String.valueOf(days)));
        QFilter filter = new QFilter("bizdate", ">=", (Object)farthestBizDate);
        filter.and("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
        filter.and("billstatus", "=", (Object)"C");
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_id", (String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");
        ArrayList<Long> arAdjustBillIds = new ArrayList<Long>(32);
        for (Row row : finArDataSet) {
            arAdjustBillIds.add(row.getLong("id"));
        }
        if (!arAdjustBillIds.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("WF", "false");
            operateOption.setVariableValue("mutex_ignoremodify", "false");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"coordinateapadjust", (String)"ar_finarbill", (Object[])arAdjustBillIds.toArray(new Long[0]), (OperateOption)operateOption);
            log.info("CoordinateApAdjustTask  operationResult is : " + operationResult.getAllErrorOrValidateInfo());
        }
        log.info("CoordinateApAdjustTask is end");
    }
}

