/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class InventoryCostLogCleanTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InventoryCostLogCleanTask.class);
    private static final String DAYS = "days";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("--begin execute inventory cost clean task--");
        int days = Integer.parseInt((String)map.get(DAYS));
        Instant endTime = Instant.now().minus(Duration.ofDays(days));
        QFilter endTimeFilter = new QFilter("exectime", "<=", (Object)Date.from(endTime));
        QFilter[] filters = new QFilter[]{endTimeFilter};
        int deletedRows = DeleteServiceHelper.delete((String)"ap_serviceinvokelog", (QFilter[])filters);
        LOGGER.info(MessageFormat.format("--end execute inventory cost clean task,deleted rows : {0}:--", deletedRows));
    }
}

