/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class MatchSchemeExecuteTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(MatchSchemeExecuteTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info(" MatchSchemeExecuteTask execute param: {}", paramMap);
        List schemeIds = (List)paramMap.get("schemeIds");
        String appId = (String)paramMap.get("appId");
        if (schemeIds.size() != 0) {
            for (Long schemeId : schemeIds) {
                this.executeScheme(schemeId, appId);
            }
        }
    }

    private void executeScheme(Long schemeId, String appId) {
        String schemeEntity = "ap_matchscheme";
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)schemeEntity);
        if (scheme != null) {
            OperateOption option = OperateOption.create();
            OperationResult result = OperationServiceHelper.executeOperate((String)"execute", (String)schemeEntity, (Object[])new Object[]{schemeId}, (OperateOption)option);
            OperationHelper.assertResult(result);
        }
    }
}

